/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.plugin.dialog;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.plugin.models.KStoreUsernamePasswordCredentials;
import com.kms.katalon.plugin.service.KStoreRestClient;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class KStoreLoginDialog
extends Dialog {
    private Text txtUsername;
    private Text txtPassword;
    private String username;
    private String password;
    private String token;
    private Label lblError;
    private Composite body;
    private Button btnConnect;
    private Button btnClose;
    private Button cbLicenseAgreement;
    private Link lnkLicenseAgreement;

    public KStoreLoginDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.body = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        this.body.setLayout((Layout)layout);
        GridData gdBody = new GridData(4, 4, true, true);
        gdBody.minimumWidth = 400;
        this.body.setLayoutData((Object)gdBody);
        Label lblInstruction = new Label(this.body, 64);
        lblInstruction.setText(StringConstants.KStoreLoginDialog_LBL_INSTRUCTION);
        lblInstruction.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite inputComposite = new Composite(this.body, 0);
        inputComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout glInput = new GridLayout(2, false);
        glInput.marginWidth = 0;
        inputComposite.setLayout((Layout)glInput);
        Label lblUsername = new Label(inputComposite, 0);
        lblUsername.setText(StringConstants.KStoreLoginDialog_LBL_USERNAME);
        this.txtUsername = new Text(inputComposite, 2048);
        this.txtUsername.setLayoutData((Object)new GridData(4, 4, true, false));
        this.username = ApplicationInfo.getAppProperty((String)"email");
        if (!StringUtils.isBlank((CharSequence)this.username)) {
            this.txtUsername.setText(this.username);
            this.txtUsername.setEditable(false);
        }
        Label lblPassword = new Label(inputComposite, 0);
        lblPassword.setText(StringConstants.KStoreLoginDialog_LBL_PASSWORD);
        this.txtPassword = new Text(inputComposite, 0x400800);
        this.txtPassword.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite licenseComposite = new Composite(this.body, 0);
        licenseComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        licenseComposite.setLayout((Layout)new GridLayout(2, false));
        this.cbLicenseAgreement = new Button(licenseComposite, 32);
        this.cbLicenseAgreement.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.lnkLicenseAgreement = new Link(licenseComposite, 64);
        this.lnkLicenseAgreement.setText(StringConstants.KStoreLoginDialog_LICENSE_AGREEMENT_MSG);
        GridData gdLicenseAgreement = new GridData(4, 4, true, false);
        gdLicenseAgreement.widthHint = 350;
        this.lnkLicenseAgreement.setLayoutData((Object)gdLicenseAgreement);
        this.lblError = new Label(this.body, 0);
        this.lblError.setLayoutData((Object)new GridData(4, 4, false, false));
        this.lblError.setForeground(Display.getCurrent().getSystemColor(3));
        ((GridData)this.lblError.getLayoutData()).exclude = true;
        this.lblError.setVisible(false);
        Composite buttonComposite = new Composite(this.body, 0);
        buttonComposite.setLayoutData((Object)new GridData(131072, 4, false, false));
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        this.btnClose = new Button(buttonComposite, 0x800000);
        this.btnClose.setText(IDialogConstants.CLOSE_LABEL);
        this.btnConnect = new Button(buttonComposite, 0x800000);
        this.btnConnect.setText(StringConstants.KStoreLoginDialog_BTN_CONNECT);
        this.btnConnect.setEnabled(false);
        this.registerControlListeners();
        return this.body;
    }

    private void registerControlListeners() {
        this.txtUsername.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KStoreLoginDialog.this.hideError();
                KStoreLoginDialog.this.username = KStoreLoginDialog.this.txtUsername.getText();
                KStoreLoginDialog.this.validate();
            }
        });
        this.txtPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KStoreLoginDialog.this.hideError();
                KStoreLoginDialog.this.password = KStoreLoginDialog.this.txtPassword.getText();
                KStoreLoginDialog.this.validate();
            }
        });
        this.btnConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KStoreLoginDialog.this.authenticate();
            }
        });
        this.btnClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KStoreLoginDialog.this.setReturnCode(1);
                KStoreLoginDialog.this.close();
            }
        });
        this.cbLicenseAgreement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KStoreLoginDialog.this.validate();
            }
        });
        this.lnkLicenseAgreement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)e.text);
            }
        });
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    private void validate() {
        if (StringUtils.isBlank((CharSequence)this.username) || StringUtils.isBlank((CharSequence)this.password) || !this.cbLicenseAgreement.getSelection()) {
            this.btnConnect.setEnabled(false);
        } else {
            this.btnConnect.setEnabled(true);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(StringConstants.KStoreLoginDialog_DIA_TITLE);
    }

    protected void authenticate() {
        block6: {
            KStoreUsernamePasswordCredentials credentials = new KStoreUsernamePasswordCredentials();
            credentials.setUsername(this.username);
            credentials.setPassword(this.password);
            try {
                try {
                    this.btnConnect.setEnabled(false);
                    KStoreRestClient restClient = new KStoreRestClient(credentials);
                    KStoreRestClient.AuthenticationResult authenticateResult = restClient.authenticate();
                    if (authenticateResult.isAuthenticated()) {
                        this.token = authenticateResult.getToken();
                        super.okPressed();
                        break block6;
                    }
                    this.showError(StringConstants.KStoreLoginDialog_INVALID_ACCOUNT_ERROR);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    this.showError(StringConstants.KStoreLoginDialog_FAILED_TO_AUTHENTICATE_MSG);
                    this.btnConnect.setEnabled(true);
                }
            }
            finally {
                this.btnConnect.setEnabled(true);
            }
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    private void showError(String errorMsg) {
        this.lblError.setText(errorMsg);
        this.setErrorMessageVisible(true);
    }

    private void hideError() {
        this.lblError.setText("");
        this.setErrorMessageVisible(false);
    }

    private void setErrorMessageVisible(boolean visible) {
        GridData gridData = (GridData)this.lblError.getLayoutData();
        gridData.exclude = !visible;
        this.lblError.setVisible(visible);
        this.getShell().pack();
    }
}

