/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.application;

import com.kms.katalon.addons.CommandBindingRemover;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.handlers.CloseHandler;
import com.kms.katalon.composer.handlers.QuitHandler;
import com.kms.katalon.composer.handlers.ResetPerspectiveHandler;
import com.kms.katalon.composer.handlers.SaveHandler;
import com.kms.katalon.composer.handlers.SearchHandler;
import com.kms.katalon.composer.handlers.WorkbenchSaveHandler;
import com.kms.katalon.composer.initializer.CommandBindingInitializer;
import com.kms.katalon.composer.initializer.ContentAssistProposalInitializer;
import com.kms.katalon.composer.initializer.DefaultTextFontInitializer;
import com.kms.katalon.composer.initializer.DisplayInitializer;
import com.kms.katalon.composer.initializer.ProblemViewImageInitializer;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.tracking.core.TrackingManager;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.ComposerActivationInfoCollector;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.osgi.framework.BundleException;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class LifeCycleManager {
    private void startUpGUIMode() throws Exception {
        this.refreshAllProjects();
        this.setupHandlers();
        this.setupPreferences();
        EventBrokerSingleton.getInstance().getEventBroker().post("WORKSPACE/CREATED", (Object)"");
    }

    protected void setupHandlers() throws BundleException {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.file.save", (IHandler)new SaveHandler());
        handlerService.activateHandler("org.eclipse.ui.file.close", (IHandler)new CloseHandler());
        handlerService.activateHandler("org.eclipse.ui.file.exit", (IHandler)new QuitHandler());
        handlerService.activateHandler("org.eclipse.search.ui.openSearchDialog", (IHandler)new SearchHandler());
        handlerService.activateHandler("com.kms.katalon.composer.menu.handler.resetPerspective", (IHandler)new ResetPerspectiveHandler());
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        contextService.activateContext("katalonContext");
        MTrimmedWindow model = (MTrimmedWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(MTrimmedWindow.class);
        IEclipseContext context = model.getContext();
        context.set(ISaveHandler.class, (Object)new WorkbenchSaveHandler());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener(new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                EventBrokerSingleton.getInstance().getEventBroker().post("EDITORS_CLOSED", (Object)partRef.getPart(true));
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                if ("org.eclipse.search.ui.views.SearchView".equals(partRef.getId())) {
                    SearchHandler.openSearchView();
                    return;
                }
                if ("org.codehaus.groovy.eclipse.editor.GroovyEditor".equals(partRef.getId())) {
                    EventUtil.post((String)"PROPERTIES/ENTITY", null);
                    new CommandBindingInitializer().resetDeleteKeyBinding();
                }
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        });
        new CommandBindingInitializer().setup();
        new CommandBindingRemover().setup();
        new ContentAssistProposalInitializer().setup();
        new ProblemViewImageInitializer().setup();
        new DefaultTextFontInitializer().setup();
        new DisplayInitializer().setup();
    }

    private void setupPreferences() {
        this.setupResourcePlugin();
        this.setupGroovyTemplatePlugin();
    }

    private void setupGroovyTemplatePlugin() {
        try {
            ScopedPreferenceStore prefStore = PreferenceStoreManager.getPreferenceStore((String)"org.codehaus.groovy.eclipse.quickfix");
            if (!prefStore.getBoolean("groovy.first.setup")) {
                prefStore.setDefault("groovy", "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><templates><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Checkpoint\" enabled=\"true\" name=\"cp\">${Checkpoint:newType(com.kms.katalon.core.checkpoint.Checkpoint)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Checkpoint Factory\" enabled=\"true\" name=\"cpf\">${CheckpointFactory:newType(com.kms.katalon.core.checkpoint.CheckpointFactory)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Failure Handling\" enabled=\"true\" name=\"fh\">${FailureHandling:newType(com.kms.katalon.core.model.FailureHandling)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Find Checkpoint\" enabled=\"true\" name=\"fcp\">${findCheckpoint:importStatic(com.kms.katalon.core.checkpoint.CheckpointFactory.findCheckpoint)}findCheckpoint(${word_selection}${null})${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Find Test Case\" enabled=\"true\" name=\"ftc\">${findTestCase:importStatic(com.kms.katalon.core.testcase.TestCaseFactory.findTestCase)}findTestCase(${word_selection}${null})${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Find Test Data\" enabled=\"true\" name=\"ftd\">${findTestData:importStatic(com.kms.katalon.core.testdata.TestDataFactory.findTestData)}findTestData(${word_selection}${null})${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Find Test Object\" enabled=\"true\" name=\"fto\">${findTestObject:importStatic(com.kms.katalon.core.testobject.ObjectRepository.findTestObject)}findTestObject(${word_selection}${null})${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Global Variables\" enabled=\"true\" name=\"gv\">${GlobalVariable:newType(internal.GlobalVariable)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Object Repository\" enabled=\"true\" name=\"tof\">${ObjectRepository:newType(com.kms.katalon.core.testobject.ObjectRepository)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Case\" enabled=\"true\" name=\"tc\">${TestCase:newType(com.kms.katalon.core.testcase.TestCase)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Case Factory\" enabled=\"true\" name=\"tcf\">${TestCaseFactory:newType(com.kms.katalon.core.testcase.TestCaseFactory)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Data\" enabled=\"true\" name=\"td\">${TestData:newType(com.kms.katalon.core.testdata.TestData)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Data Factory\" enabled=\"true\" name=\"tdf\">${TestDataFactory:newType(com.kms.katalon.core.testdata.TestDataFactory)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Object\" enabled=\"true\" name=\"to\">${TestObject:newType(com.kms.katalon.core.testobject.TestObject)}${cursor}</template></templates>");
                prefStore.setToDefault("groovy");
                prefStore.setValue("groovy.first.setup", true);
            }
            prefStore.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void setupResourcePlugin() {
        try {
            ScopedPreferenceStore runtimePrefStore = PreferenceStoreManager.getPreferenceStore((String)"org.eclipse.core.resources");
            if (!runtimePrefStore.getBoolean("description.autobuilding")) {
                runtimePrefStore.setValue("description.autobuilding", true);
            }
            if (!runtimePrefStore.getBoolean("refresh.lightweight.enabled")) {
                runtimePrefStore.setValue("refresh.lightweight.enabled", true);
            }
            runtimePrefStore.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void refreshAllProjects() throws Exception {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.checkProjectLocationDeleted(project);
            ++n2;
        }
    }

    void checkProjectLocationDeleted(IProject project) throws Exception {
        if (!project.exists()) {
            return;
        }
        IFileInfo location = IDEResourceInfoUtils.getFileInfo((URI)project.getLocationURI());
        if (!location.exists()) {
            project.delete(true, true, null);
        }
    }

    @PostContextCreate
    void postContextCreate(final IEventBroker eventBroker) {
        eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/appStartupComplete", new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    LifeCycleManager.this.startUpGUIMode();
                    this.scheduleCollectingStatistics();
                    if (this.checkActivation(eventBroker)) {
                        eventBroker.post("ACTIVATION/CHECKED", null);
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }

            private boolean checkActivation(IEventBroker eventBroker2) throws Exception {
                if (!ComposerActivationInfoCollector.checkActivation()) {
                    eventBroker2.send("PROJECT/CLOSE", null);
                    PlatformUI.getWorkbench().close();
                    return false;
                }
                try {
                    Trackings.trackOpenApplication((boolean)false, (String)"gui");
                }
                catch (Exception exception) {}
                return true;
            }

            private void scheduleCollectingStatistics() {
                int trackingTime = TrackingManager.getInstance().getTrackingTime();
                Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> Trackings.trackProjectStatistics((ProjectEntity)ProjectController.getInstance().getCurrentProject(), (!ActivationInfoCollector.isActivated() ? 1 : 0) != 0, (String)"gui"), trackingTime, trackingTime, TimeUnit.SECONDS);
            }
        });
    }
}

