/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.application;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.console.addons.MacOSAddon;
import com.kms.katalon.core.application.ApplicationWorkbenchAdvisor;
import com.kms.katalon.core.application.MetadataCorruptedResolver;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.support.testing.katserver.KatServer;
import com.kms.katalon.util.ApplicationSession;
import java.util.Map;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.osgi.framework.BundleException;

public class Application
implements IApplication {
    private static final String INVALID_RUNNING_MODE = "Invalid running mode.";
    public static final String RUN_MODE_OPTION = "runMode";
    public static final String RUN_MODE_OPTION_CONSOLE = "console";
    private static final Object RUN_MODE_OPTION_SELFTEST = "selfTest";

    public Object start(IApplicationContext context) {
        if (!this.activeLoggingBundle()) {
            return IApplication.EXIT_OK;
        }
        if (!this.activateInternalPlatformBundle()) {
            return IApplication.EXIT_OK;
        }
        this.preRunInit();
        Map args = context.getArguments();
        String[] appArgs = (String[])args.get("application.args");
        RunningModeParam runningModeParam = this.getRunningModeParamFromParam(this.parseOption(appArgs));
        switch (runningModeParam) {
            case CONSOLE: {
                return this.runConsole(context, appArgs);
            }
            case SELFTEST: {
                return this.runSelfTest();
            }
            case GUI: {
                return this.runGUI();
            }
        }
        System.out.println(INVALID_RUNNING_MODE);
        return IApplication.EXIT_OK;
    }

    private Object runConsole(IApplicationContext context, String[] appArgs) {
        try {
            context.applicationRunning();
            ApplicationRunningMode.setRunningMode((RunningMode)RunningMode.CONSOLE);
            return com.kms.katalon.console.application.Application.runConsole((String[])appArgs);
        }
        catch (Error e) {
            LogUtil.logError((Throwable)e);
            return this.resolve();
        }
    }

    private void preRunInit() {
        ApplicationSession.clean();
        MacOSAddon.initMacOSConfig();
        ApplicationInfo.setAppInfoIntoUserHomeDir();
    }

    private OptionSet parseOption(String[] appArgs) {
        OptionParser parser = new OptionParser(false);
        parser.allowsUnrecognizedOptions();
        parser.accepts(RUN_MODE_OPTION).withRequiredArg().ofType(String.class);
        OptionSet options = parser.parse(appArgs);
        return options;
    }

    private int runSelfTest() {
        ApplicationSingleton.getInstance().enableServerMode();
        new KatServer().start();
        return this.runGUI();
    }

    private int runGUI() {
        ApplicationRunningMode.setRunningMode((RunningMode)RunningMode.GUI);
        int returnCode = this.internalRunGUI();
        if (returnCode == 1) {
            return IApplication.EXIT_RESTART;
        }
        return IApplication.EXIT_OK;
    }

    private int internalRunGUI() {
        Display display = PlatformUI.createDisplay();
        try {
            int n = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            return n;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
        catch (Error e) {
            LogUtil.logError((Throwable)e);
            int n = this.resolve();
            return n;
        }
        finally {
            ApplicationSession.close();
            display.dispose();
        }
        return 0;
    }

    private int resolve() {
        MetadataCorruptedResolver resolver = new MetadataCorruptedResolver();
        if (!resolver.isMetaFolderCorrupted()) {
            return 2;
        }
        return resolver.resolve() ? 1 : 2;
    }

    private RunningModeParam getRunningModeParamFromParam(OptionSet options) {
        if (!options.has(RUN_MODE_OPTION)) {
            return RunningModeParam.GUI;
        }
        if (RUN_MODE_OPTION_CONSOLE.equals(options.valueOf(RUN_MODE_OPTION))) {
            return RunningModeParam.CONSOLE;
        }
        if (RUN_MODE_OPTION_SELFTEST.equals(options.valueOf(RUN_MODE_OPTION))) {
            return RunningModeParam.SELFTEST;
        }
        return RunningModeParam.INVALID;
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    private boolean activeLoggingBundle() {
        try {
            Platform.getBundle((String)"com.kms.katalon.logging").start();
            return true;
        }
        catch (BundleException bundleException) {
            return false;
        }
    }

    private boolean activateInternalPlatformBundle() {
        try {
            Platform.getBundle((String)"com.kms.katalon.platform.internal").start();
            return true;
        }
        catch (BundleException bundleException) {
            return false;
        }
    }

    public static enum RunningModeParam {
        GUI,
        CONSOLE,
        INVALID,
        SELFTEST;

    }
}

