/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.update.jobs;

import com.kms.katalon.composer.components.impl.util.PlatformUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.update.UpdateComponent;
import com.kms.katalon.composer.update.UpdateException;
import com.kms.katalon.composer.update.UpdateManager;
import com.kms.katalon.composer.update.download.DownloadProgressListener;
import com.kms.katalon.composer.update.download.FileDownloader;
import com.kms.katalon.composer.update.jobs.CheckForUpdatesJob;
import com.kms.katalon.composer.update.models.AppInfo;
import com.kms.katalon.composer.update.models.FileInfo;
import com.kms.katalon.composer.update.util.ExtractUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class DownloadUpdateJob
extends Job
implements UpdateComponent {
    private CheckForUpdatesJob.CheckForUpdateResult newUpdateResult;

    public DownloadUpdateJob(CheckForUpdatesJob.CheckForUpdateResult newUpdateResult) {
        super("Downloading Update...");
        this.newUpdateResult = newUpdateResult;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
            subMonitor.beginTask("", 100);
            SubMonitor downloadMonitor = subMonitor.split(80, 0);
            downloadMonitor.beginTask("Downloading Update Files...", 100);
            File downloadDir = this.getUpdateManager().getLocalDownloadDir(this.getLatestVersion());
            downloadDir.mkdir();
            FileUtils.cleanDirectory((File)downloadDir);
            long totalSize = this.newUpdateResult.getUpdateFiles().stream().mapToLong(f -> f.getSize()).reduce((a, b) -> a + b).getAsLong();
            for (FileInfo fileInfo : this.newUpdateResult.getUpdateFiles()) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                int subWork = Math.round((float)fileInfo.getSize() / (float)totalSize * 100.0f);
                SubMonitor downloadFileMonitor = downloadMonitor.newChild(subWork, 2);
                downloadFileMonitor.beginTask("", 100);
                try {
                    this.downloadFile(fileInfo, new DownloadProgressListenerImpl(downloadFileMonitor, fileInfo));
                }
                catch (InterruptedException interruptedException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
                downloadFileMonitor.done();
            }
            downloadMonitor.done();
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            SubMonitor extractMonitor = subMonitor.split(20, 4);
            extractMonitor.beginTask("Extracting Update Files...", 100);
            File extractDir = this.getUpdateManager().getLocalExtractDir(this.getLatestVersion());
            extractDir.mkdir();
            FileUtils.cleanDirectory((File)extractDir);
            for (FileInfo fileInfo : this.newUpdateResult.getUpdateFiles()) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                File downloadedFileInfo = new File(downloadDir, fileInfo.getLocation());
                ExtractUtils.extract(downloadedFileInfo, extractDir);
                int subWork = Math.round((float)fileInfo.getSize() / (float)totalSize * 100.0f);
                extractMonitor.worked(subWork);
            }
            FileUtils.cleanDirectory((File)downloadDir);
            this.replaceUpdater(extractDir);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (IOException e) {
            Status status = new Status(4, "com.kms.katalon", "Unable to download update file from Katalon server", (Throwable)new UpdateException(e));
            return status;
        }
        catch (UpdateException e) {
            Status status = new Status(4, "com.kms.katalon", "Unable to download update file from Katalon server", (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private void replaceUpdater(File extractDir) {
        try {
            File newUpdaterDir = new File(extractDir, "resources/update/updater");
            File oldUpdaterDir = this.getUpdateManager().getUpdateJar().getParentFile();
            if (newUpdaterDir.exists() && newUpdaterDir.isDirectory()) {
                FileUtils.copyDirectory((File)newUpdaterDir, (File)oldUpdaterDir);
            }
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private String getLatestVersion() {
        return this.newUpdateResult.getLatestAppInfo().getVersion();
    }

    private void downloadFile(FileInfo fileInfo, DownloadProgressListenerImpl downloadProgressListener) throws UpdateException, InterruptedException {
        String fileInfoUrl;
        File localFileInfo;
        UpdateManager updateManager = this.getUpdateManager();
        try {
            AppInfo latestAppInfo = this.newUpdateResult.getLatestAppInfo();
            localFileInfo = updateManager.getLocalDownloadFileInfo(latestAppInfo.getVersion(), fileInfo.getLocation());
            fileInfoUrl = updateManager.getFileInfoVersionUrl(this.newUpdateResult.getLatestVersionInfo().getLatestUpdateLocation(), PlatformUtil.getPlatform(), fileInfo.getLocation());
        }
        catch (IOException e) {
            throw new UpdateException(e);
        }
        localFileInfo.getParentFile().mkdirs();
        try {
            Throwable e = null;
            Object var7_10 = null;
            try (FileOutputStream outputStream = new FileOutputStream(localFileInfo);){
                FileDownloader fileDownloader = new FileDownloader(fileInfo.getSize());
                fileDownloader.addListener(downloadProgressListener);
                fileDownloader.download(fileInfoUrl, outputStream, (IProgressMonitor)downloadProgressListener.getMonitor());
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new UpdateException(e);
        }
    }

    private class DownloadProgressListenerImpl
    implements DownloadProgressListener {
        private SubMonitor monitor;
        private int currentWork = 0;
        private FileInfo fileInfo;

        public SubMonitor getMonitor() {
            return this.monitor;
        }

        public DownloadProgressListenerImpl(SubMonitor monitor, FileInfo fileInfo) {
            this.monitor = monitor;
            this.fileInfo = fileInfo;
        }

        @Override
        public void onProgressUpdate(long progress, long fileSize, long speedInKps) {
            int work = Math.round((float)progress / (float)fileSize * 100.0f);
            int nextWork = work - this.currentWork;
            if (nextWork > 0) {
                this.monitor.worked(nextWork);
                String subTaskName = MessageFormat.format("Downloading {0}...({1})", this.fileInfo.getLocation(), String.valueOf(FileUtils.byteCountToDisplaySize((long)speedInKps)) + "/s");
                this.monitor.subTask(subTaskName);
            }
            this.currentWork = work;
        }
    }
}

