/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.update.jobs;

import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.composer.components.impl.util.PlatformUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.update.UpdateComponent;
import com.kms.katalon.composer.update.UpdateException;
import com.kms.katalon.composer.update.UpdateManager;
import com.kms.katalon.composer.update.download.FileDownloader;
import com.kms.katalon.composer.update.models.AppInfo;
import com.kms.katalon.composer.update.models.FileInfo;
import com.kms.katalon.composer.update.models.LastestVersionInfo;
import com.kms.katalon.core.util.internal.JsonUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CheckForUpdatesJob
extends Job
implements UpdateComponent {
    private boolean silenceMode;
    private CheckForUpdateResult updateResult;

    public CheckForUpdatesJob(boolean silenceMode) {
        super("Checking for Updates...");
        this.silenceMode = silenceMode;
    }

    public CheckForUpdateResult getUpdateResult() {
        return this.updateResult;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        LastestVersionInfo lastestUpdateVersion;
        monitor.beginTask("Checking for Updates...", 100);
        if (VersionUtil.isStagingBuild() || VersionUtil.isDevelopmentBuild()) {
            this.updateResult = new CheckForUpdateResult();
            this.updateResult.setUpdateResult(UpdateResultValue.UP_TO_DATE);
            return Status.OK_STATUS;
        }
        UpdateManager updateManager = this.getUpdateManager();
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                FileDownloader downloader = new FileDownloader(-1L);
                downloader.download(updateManager.getLatestVersionUrl(), outputStream, monitor);
                lastestUpdateVersion = (LastestVersionInfo)JsonUtil.fromJson((String)outputStream.toString(), LastestVersionInfo.class);
                LastestVersionInfo localLatestVersion = updateManager.getLocalLatestVersion();
                if (!VersionUtil.isNewer((String)lastestUpdateVersion.getLatestVersion(), (String)VersionUtil.getCurrentVersion().getVersion()) || this.isIgnoredInSilenceMode(lastestUpdateVersion, localLatestVersion)) {
                    this.updateResult = new CheckForUpdateResult();
                    this.updateResult.setUpdateResult(UpdateResultValue.UP_TO_DATE);
                    return Status.OK_STATUS;
                }
                if (!lastestUpdateVersion.isNewMechanism()) {
                    this.updateResult = new CheckForUpdateResult();
                    this.updateResult.setUpdateResult(UpdateResultValue.APPLIED_LEGACY_MECHANISM);
                    return Status.OK_STATUS;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            this.updateResult = new CheckForUpdateResult();
            this.updateResult.setUpdateResult(UpdateResultValue.APPLIED_LEGACY_MECHANISM);
            return Status.OK_STATUS;
        }
        monitor.worked(40);
        try {
            monitor.setTaskName("Fetching new update info...");
            AppInfo latestAppInfo = this.downloadLastestAppInfo(lastestUpdateVersion, monitor);
            updateManager.saveAppInfo(latestAppInfo);
            monitor.worked(40);
            monitor.setTaskName("Determining update size...");
            AppInfo currentAppInfo = updateManager.getCurrentVersionLocalAppInfo();
            List<FileInfo> newDownloadFiles = this.determineUpdateFiles(currentAppInfo, latestAppInfo);
            this.updateResult = new CheckForUpdateResult();
            this.updateResult.setUpdateResult(UpdateResultValue.NEW_UPDATE_FOUND);
            this.updateResult.setLatestAppInfo(latestAppInfo);
            this.updateResult.setCurrentAppInfo(currentAppInfo);
            this.updateResult.setUpdateFiles(newDownloadFiles);
            this.updateResult.setLatestVersionInfo(lastestUpdateVersion);
            monitor.worked(20);
            iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (InterruptedException interruptedException) {
            iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (UpdateException e) {
            iStatus = new Status(4, "com.kms.katalon", "Unable to connect to katalon update server", (Throwable)e);
            return iStatus;
        }
        catch (Exception e) {
            iStatus = new Status(4, "com.kms.katalon", "Unable to connect to katalon update server", (Throwable)new UpdateException(e));
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private boolean isIgnoredInSilenceMode(LastestVersionInfo lastestUpdateVersion, LastestVersionInfo localLatestVersion) {
        return this.silenceMode && this.isLatestVersionIgnored(lastestUpdateVersion, localLatestVersion);
    }

    private boolean isLatestVersionIgnored(LastestVersionInfo lastestUpdateVersion, LastestVersionInfo localLatestVersion) {
        return lastestUpdateVersion.getLatestVersion().equals(localLatestVersion.getLatestVersion()) && localLatestVersion.isLatestVersionIgnored();
    }

    private AppInfo downloadLastestAppInfo(LastestVersionInfo lastestUpdateVersion, IProgressMonitor monitor) throws UpdateException, InterruptedException {
        UpdateManager updateManger = this.getUpdateManager();
        String latestVersionAppInfoUrl = updateManger.getAppInfoVersionUrl(lastestUpdateVersion.getLatestUpdateLocation(), PlatformUtil.getPlatform());
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                FileDownloader downloader = new FileDownloader(-1L);
                downloader.download(latestVersionAppInfoUrl, outputStream, monitor);
                return (AppInfo)JsonUtil.fromJson((String)outputStream.toString(), AppInfo.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UpdateException(e);
        }
    }

    public List<FileInfo> determineUpdateFiles(AppInfo currentAppInfo, AppInfo latestAppInfo) {
        Map<String, FileInfo> latestFileMap = latestAppInfo.getFiles().stream().collect(Collectors.toMap(FileInfo::getLocation, f -> f));
        currentAppInfo.getFiles().forEach(f -> {
            String location = f.getLocation();
            if (latestFileMap.containsKey(location) && f.getHash().equals(((FileInfo)latestFileMap.get(location)).getHash())) {
                latestFileMap.remove(location);
            }
        });
        return new ArrayList<FileInfo>(latestFileMap.values());
    }

    public class CheckForUpdateResult {
        private LastestVersionInfo latestVersionInfo;
        private AppInfo currentAppInfo;
        private AppInfo latestAppInfo;
        private UpdateResultValue updateResult;
        private List<FileInfo> updateFiles;

        public UpdateResultValue getUpdateResult() {
            return this.updateResult;
        }

        private void setUpdateResult(UpdateResultValue updateResult) {
            this.updateResult = updateResult;
        }

        public AppInfo getLatestAppInfo() {
            return this.latestAppInfo;
        }

        private void setLatestAppInfo(AppInfo appInfo) {
            this.latestAppInfo = appInfo;
        }

        public List<FileInfo> getUpdateFiles() {
            return this.updateFiles;
        }

        private void setUpdateFiles(List<FileInfo> updateFiles) {
            this.updateFiles = updateFiles;
        }

        public AppInfo getCurrentAppInfo() {
            return this.currentAppInfo;
        }

        private void setCurrentAppInfo(AppInfo currentAppInfo) {
            this.currentAppInfo = currentAppInfo;
        }

        public LastestVersionInfo getLatestVersionInfo() {
            return this.latestVersionInfo;
        }

        private void setLatestVersionInfo(LastestVersionInfo latestVersion) {
            this.latestVersionInfo = latestVersion;
        }
    }

    public static enum UpdateResultValue {
        UP_TO_DATE,
        NEW_UPDATE_FOUND,
        APPLIED_LEGACY_MECHANISM;

    }
}

