/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.update.download;

import com.kms.katalon.composer.update.UpdateException;
import com.kms.katalon.composer.update.download.DownloadProgressListener;
import com.kms.katalon.composer.update.util.NetworkUtils;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.util.internal.ProxyUtil;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileDownloader {
    public static final long UNKNOWN_SIZE = -1L;
    public static final long NOTIFICATION_DELAY = 500L;
    private final long fileSizeInBytes;
    private List<DownloadProgressListener> listeners = new LinkedList<DownloadProgressListener>();
    private Boolean notificationSending = false;

    public FileDownloader(long fileSizeInBytes) {
        this.fileSizeInBytes = fileSizeInBytes;
    }

    public void addListener(DownloadProgressListener l) {
        this.listeners.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyProgressChanges(long progress, long total, long speedInKBPs) {
        Boolean bl = this.notificationSending;
        synchronized (bl) {
            if (this.notificationSending.booleanValue()) {
                return;
            }
        }
        new Thread(() -> {
            this.notificationSending = true;
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime <= 500L) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.listeners.stream().forEach(l4 -> l4.onProgressUpdate(progress, total, speedInKBPs));
            this.notificationSending = false;
        }).start();
    }

    public void download(String url, OutputStream os, IProgressMonitor monitor) throws UpdateException, InterruptedException {
        InputStream inputStream = null;
        HttpURLConnection connection = null;
        try {
            try {
                int count;
                connection = this.createConnection(url);
                inputStream = connection.getInputStream();
                byte[] data = new byte[4096];
                long progress = 0L;
                long startDownloadTime = System.currentTimeMillis();
                while ((count = inputStream.read(data)) != -1) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    os.write(data, 0, count);
                    long speedInKBPs = (progress += (long)count) * 1000L / Math.max(System.currentTimeMillis() - startDownloadTime, 1L);
                    this.notifyProgressChanges(progress, this.fileSizeInBytes, speedInKBPs);
                }
            }
            catch (IOException | URISyntaxException | GeneralSecurityException e) {
                throw new UpdateException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            IOUtils.close((URLConnection)connection);
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        IOUtils.close((URLConnection)connection);
    }

    private HttpURLConnection createConnection(String url) throws IOException, GeneralSecurityException, URISyntaxException {
        try {
            return NetworkUtils.createURLConnection(url, ProxyUtil.getProxy((ProxyInformation)ProxyPreferences.getProxyInformation()));
        }
        catch (ConnectException connectException) {
            return NetworkUtils.createURLConnection(url, ProxyUtil.getSystemProxy());
        }
    }
}

