/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.update.dialogs;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.update.jobs.CheckForUpdatesJob;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class NewUpdateDialog
extends AbstractDialog {
    public static final int DOWNLOAD_ID = 1025;
    public static final int REMIND_LATER_ID = 1026;
    public static final int IGNORE_UPDATE_ID = 1027;
    private Label lblCurrentVersionDetails;
    private Label lblNewVersionDetails;
    private Link lnkRealeaseNotes;
    private Composite container;
    private CheckForUpdatesJob.CheckForUpdateResult result;

    public NewUpdateDialog(Shell parentShell, CheckForUpdatesJob.CheckForUpdateResult result) {
        super(parentShell);
        this.result = result;
    }

    protected void registerControlModifyListeners() {
        this.lnkRealeaseNotes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)NewUpdateDialog.this.result.getLatestVersionInfo().getReleaseNotesLink());
            }
        });
    }

    protected void setInput() {
        this.lblCurrentVersionDetails.setText(this.result.getCurrentAppInfo().getVersion());
        this.lblNewVersionDetails.setText(this.result.getLatestAppInfo().getVersion());
        this.container.layout(true);
    }

    protected Control createDialogContainer(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.marginWidth = 10;
        glContainer.horizontalSpacing = 30;
        this.container.setLayout((Layout)glContainer);
        Label lblCurrentVersion = new Label(this.container, 0);
        lblCurrentVersion.setText("Current version");
        this.lblCurrentVersionDetails = new Label(this.container, 0);
        Label lblNewVersion = new Label(this.container, 0);
        lblNewVersion.setText("New version");
        Composite newVersionComposite = new Composite(this.container, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        newVersionComposite.setLayout((Layout)gridLayout);
        this.lblNewVersionDetails = new Label(newVersionComposite, 0);
        this.lnkRealeaseNotes = new Link(newVersionComposite, 0);
        this.lnkRealeaseNotes.setText("<a>Release Notes</a>");
        return this.container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, "Download", true);
        this.createButton(parent, 1026, "Remind Me Later", false);
        this.createButton(parent, 1027, "Ignore This Update", false);
    }

    public String getDialogTitle() {
        return "Katalon Studio New Update";
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        this.setReturnCode(buttonId);
        super.close();
    }
}

