/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.preferences;

import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class GeneralPreferencePage
extends PreferencePage {
    private Button radioAutoRestorePrevSession;
    private Button radioAutoCleanPrevSession;
    private Button chkCheckNewVersion;
    private Button chkShowHelpAtStartUp;
    private Composite parentComposite;

    protected Control createContents(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 10;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.parentComposite = new Composite(parent, 0);
        this.parentComposite.setLayout((Layout)layout);
        Group prevSession = new Group(this.parentComposite, 4);
        prevSession.setText(StringConstants.PAGE_GRP_ON_NEXT_STARTING_APP);
        prevSession.setLayout((Layout)new GridLayout(1, false));
        prevSession.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.radioAutoRestorePrevSession = new Button((Composite)prevSession, 16);
        this.radioAutoRestorePrevSession.setText(StringConstants.PAGE_RADIO_AUTO_RESTORE_PREV_SESSION);
        this.radioAutoCleanPrevSession = new Button((Composite)prevSession, 16);
        this.radioAutoCleanPrevSession.setText(StringConstants.PAGE_RADIO_AUTO_CLEAN_PREV_SESSION);
        this.chkShowHelpAtStartUp = new Button(this.parentComposite, 32);
        this.chkShowHelpAtStartUp.setText(MessageConstants.PAGE_PREF_SHOW_HELP_AT_START_UP);
        this.chkCheckNewVersion = new Button(this.parentComposite, 32);
        this.chkCheckNewVersion.setText(MessageConstants.PAGE_PREF_AUTO_CHECK_NEW_VERSION_TITLE);
        this.initialize();
        return this.parentComposite;
    }

    public IPreferenceStore getPreferenceStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
    }

    private void initialize() {
        IPreferenceStore prefStore = this.getPreferenceStore();
        boolean autoRestore = prefStore.getBoolean("general.autoRestorePreviousSession");
        this.radioAutoRestorePrevSession.setSelection(autoRestore);
        this.radioAutoCleanPrevSession.setSelection(!autoRestore);
        boolean setCheckNewVersion = prefStore.contains("general.autoCheckNewVersion");
        this.chkCheckNewVersion.setSelection(setCheckNewVersion ? prefStore.getBoolean("general.autoCheckNewVersion") : true);
        if (!setCheckNewVersion) {
            prefStore.setDefault("general.autoCheckNewVersion", true);
        }
        if (!prefStore.contains("general.showHelpAtStartUp")) {
            prefStore.setDefault("general.showHelpAtStartUp", true);
        }
        this.chkShowHelpAtStartUp.setSelection(prefStore.getBoolean("general.showHelpAtStartUp"));
    }

    protected void performDefaults() {
        if (this.parentComposite == null) {
            return;
        }
        this.getPreferenceStore().setToDefault("general.autoRestorePreviousSession");
        this.getPreferenceStore().setToDefault("general.autoCheckNewVersion");
        this.getPreferenceStore().setToDefault("general.showHelpAtStartUp");
        this.initialize();
        super.performDefaults();
    }

    protected void performApply() {
        if (this.parentComposite == null) {
            return;
        }
        this.getPreferenceStore().setValue("general.autoRestorePreviousSession", this.radioAutoRestorePrevSession.getSelection());
        this.getPreferenceStore().setValue("general.autoCheckNewVersion", this.chkCheckNewVersion.getSelection());
        this.getPreferenceStore().setValue("general.showHelpAtStartUp", this.chkShowHelpAtStartUp.getSelection());
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }
}

