/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.handler.CommandCaller;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.project.dialog.NewProjectDialog;
import com.kms.katalon.composer.project.handlers.NewSampleLocalProjectHandler;
import com.kms.katalon.composer.project.menu.ProjectParameterizedCommandBuilder;
import com.kms.katalon.composer.project.sample.SampleLocalProject;
import com.kms.katalon.composer.project.sample.SampleProject;
import com.kms.katalon.composer.project.sample.SampleRemoteProject;
import com.kms.katalon.composer.project.sample.SampleRemoteProjectProvider;
import com.kms.katalon.composer.project.template.SampleProjectProvider;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class WelcomeRightPart
extends Composite
implements EventHandler {
    private static final Color BACKGROUND_COLOR = ColorUtil.getColor((String)"#FAFAFA");
    private static final Color BLUE_COLOR = ColorUtil.getColor((String)"#00A9FF");
    private static final Color TEXT_COLOR = ColorUtil.getColor((String)"#444444");
    private static final Color STEP_DESCRIPTION_COLOR = ColorUtil.getColor((String)"#212121");
    private static final Color SEPARATOR_COLOR = ColorUtil.getColor((String)"#DCE1E3");
    private static final String KEY_ID = "ID";
    private static final String KEY_CONTENT = "CONTENT";
    private static final String KEY_BG_ACTIVE = "BG-ACTIVE";
    private static final String KEY_BG_INACTIVE = "BG-INACTIVE";
    private static final String TAB_LBL_RECENTS = MessageConstants.TAB_LBL_RECENTS;
    private static final String TAB_LBL_SAMPLES = MessageConstants.TAB_LBL_SAMPLE_PROJECTS;
    private static final String TAB_LBL_GETTING_STARTED = MessageConstants.TAB_LBL_GETTING_STARTED;
    private static final Cursor CURSOR_HAND = Display.getDefault().getSystemCursor(21);
    private static final int FONT_SIZE_SMALL = 10;
    private static final int FONT_SIZE_MEDIUM = 12;
    private static final int FONT_SIZE_LARGE = 14;
    private static final int TAB_WIDTH = 153;
    private static final int TAB_HEIGHT = 30;
    private static final int TAB_GETTING_STARTED_ID = 1;
    private static final int TAB_SAMPLES_ID = 2;
    private static final int TAB_RECENTS_ID = 3;
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private StackLayout stackLayout;
    private Composite tabComposite;
    private Composite tabGroup;
    private Composite tabContentCompositeStack;
    private Composite gettingStartedContent;
    private Composite samplesContent;
    private Composite recentsContent;
    private Composite recentsProjectHolder;
    private Composite testingTypeTabGroup;
    private Composite contentHolder;
    private StackLayout testingTypeStackLayout;
    private CLabel selectedTestingTypeTab;
    private CLabel tabGettingStarted;
    private CLabel tabSamples;
    private CLabel tabRecents;
    private CommandCaller commandCaller = new CommandCaller();
    private Thread thread;
    private CLabel tabWebUi;
    private CLabel tabMobile;
    private CLabel tabApi;
    private CLabel tabScripting;
    private Composite webUiTabContent;
    private Composite mobileTabContent;
    private Composite apiTabContent;
    private Composite scriptingTabContent;
    private static final SelectionAdapter linkSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Program.launch((String)e.text);
        }
    };

    public WelcomeRightPart(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.stackLayout = new StackLayout();
        this.createControls();
        this.postConstruct();
        this.eventBroker.subscribe("PROJECT/OPENED", (EventHandler)this);
    }

    public void reloadRecentProjects() {
        if (this.recentsContent == null || this.recentsContent.isDisposed()) {
            return;
        }
        this.clearRecentProjectBlocks();
        this.populateRecentProjects();
        this.recentsContent.layout();
    }

    private void createControls() {
        this.createTabHeader();
        this.createTabContent();
        this.setExtraDataToTabs();
        this.addTabButtonSelectionListeners();
    }

    private void setExtraDataToTabs() {
        this.tabGettingStarted.setData(KEY_ID, (Object)1);
        this.tabGettingStarted.setData(KEY_CONTENT, (Object)this.gettingStartedContent);
        this.tabSamples.setData(KEY_ID, (Object)2);
        this.tabSamples.setData(KEY_CONTENT, (Object)this.samplesContent);
        this.tabRecents.setData(KEY_ID, (Object)3);
        this.tabRecents.setData(KEY_CONTENT, (Object)this.recentsContent);
    }

    private void createTabHeader() {
        this.tabComposite = new Composite((Composite)this, 0);
        this.tabComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout glTabComposite = new GridLayout(3, false);
        glTabComposite.verticalSpacing = 0;
        glTabComposite.horizontalSpacing = 0;
        this.tabComposite.setLayout((Layout)glTabComposite);
        this.addSpacer(this.tabComposite);
        this.tabGroup = new Composite(this.tabComposite, 0);
        this.tabGroup.setBackground(BACKGROUND_COLOR);
        this.tabGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        GridLayout glTabGroup = new GridLayout(3, false);
        glTabGroup.marginWidth = 0;
        glTabGroup.marginHeight = 0;
        glTabGroup.horizontalSpacing = 0;
        glTabGroup.verticalSpacing = 0;
        this.tabGroup.setLayout((Layout)glTabGroup);
        this.tabGettingStarted = this.createTabItem(this.tabGroup, TAB_LBL_GETTING_STARTED, ImageConstants.TAB_FIRST_ACTIVE, ImageConstants.TAB_FIRST_INACTIVE);
        this.tabSamples = this.createTabItem(this.tabGroup, TAB_LBL_SAMPLES, ImageConstants.TAB_MIDDLE_ACTIVE, ImageConstants.TAB_MIDDLE_INACTIVE);
        this.tabRecents = this.createTabItem(this.tabGroup, TAB_LBL_RECENTS, ImageConstants.TAB_LAST_ACTIVE, ImageConstants.TAB_LAST_INACTIVE);
        this.addSpacer(this.tabComposite);
    }

    private CLabel createTabItem(Composite parent, String textLabel, Image bgActive, Image bgInactive) {
        CLabel tab = new CLabel(parent, 0);
        tab.setAlignment(0x1000000);
        GridData gdTab = new GridData(4, 4, false, true);
        gdTab.widthHint = 153;
        gdTab.heightHint = 30;
        tab.setLayoutData((Object)gdTab);
        tab.setText(textLabel);
        tab.setBackground(bgInactive);
        tab.setData(KEY_BG_ACTIVE, (Object)bgActive);
        tab.setData(KEY_BG_INACTIVE, (Object)bgInactive);
        tab.setCursor(CURSOR_HAND);
        ControlUtils.setFontSize((Control)tab, (int)10);
        return tab;
    }

    private void addSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createTabContent() {
        this.tabContentCompositeStack = new Composite((Composite)this, 0);
        this.tabContentCompositeStack.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabContentCompositeStack.setLayout((Layout)this.stackLayout);
        this.createGettingStatedTabContent();
        this.createSamplesTabContent();
        this.createRecentsTabContent();
    }

    private void postConstruct() {
        int lastSelectedTabId = Math.max(1, PlatformUI.getPreferenceStore().getInt("general.lastHelpSelectedTab"));
        this.setActiveTab(lastSelectedTabId);
    }

    private void addTabButtonSelectionListeners() {
        MouseAdapter selectionListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                WelcomeRightPart.this.selectTab((CLabel)e.getSource());
            }
        };
        this.tabGettingStarted.addMouseListener((MouseListener)selectionListener);
        this.tabSamples.addMouseListener((MouseListener)selectionListener);
        this.tabRecents.addMouseListener((MouseListener)selectionListener);
    }

    private void selectTab(CLabel tab) {
        Arrays.stream(this.tabGroup.getChildren()).filter(tabButton -> !tab.getData(KEY_ID).equals(tabButton.getData(KEY_ID))).forEach(tabButton -> {
            tabButton.setEnabled(true);
            ((CLabel)tabButton).setBackground((Image)tabButton.getData(KEY_BG_INACTIVE));
            tabButton.setForeground(TEXT_COLOR);
            ((CLabel)tabButton).layout();
        });
        tab.setEnabled(false);
        tab.setBackground((Image)tab.getData(KEY_BG_ACTIVE));
        tab.setForeground(ColorUtil.getTextWhiteColor());
        this.stackLayout.topControl = (Composite)tab.getData(KEY_CONTENT);
        this.tabContentCompositeStack.layout();
        tab.layout();
        PlatformUI.getPreferenceStore().setValue("general.lastHelpSelectedTab", ((Integer)tab.getData(KEY_ID)).intValue());
    }

    public CLabel getActiveTab() {
        Optional<Control> activeTab = Arrays.stream(this.tabGroup.getChildren()).filter(tab -> !tab.isEnabled()).findFirst();
        if (activeTab.isPresent()) {
            return (CLabel)activeTab.get();
        }
        return this.tabGettingStarted;
    }

    public void setActiveTab(int tabId) {
        Optional<Control> targetTab = Arrays.stream(this.tabGroup.getChildren()).filter(tab -> tab.getData(KEY_ID) != null && tab.getData(KEY_ID).equals(tabId)).findFirst();
        if (targetTab.isPresent()) {
            this.selectTab((CLabel)targetTab.get());
        }
    }

    private void createGettingStatedTabContent() {
        this.gettingStartedContent = this.createContentComposite(this.tabContentCompositeStack);
        ((GridLayout)this.gettingStartedContent.getLayout()).marginHeight = 0;
        this.createTestingTypeTabHeader();
        this.createTabContentForTestingTypes();
        this.setExtraDataToTestingTypeTabs();
        this.registerListenersForTestingTypeTabs();
        this.setDefaultTestingTypeTabByProjectType();
    }

    private void setDefaultTestingTypeTabByProjectType() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project != null && project.getType() == ProjectType.WEBSERVICE) {
            this.handleSelectingTestingTypeTab(this.tabApi);
        } else {
            this.handleSelectingTestingTypeTab(this.tabWebUi);
        }
    }

    private void createTestingTypeTabHeader() {
        Composite wrapper = new Composite(this.gettingStartedContent, 0);
        GridLayout glWrapper = new GridLayout(1, false);
        glWrapper.marginTop = 2;
        glWrapper.marginBottom = 2;
        wrapper.setLayout((Layout)glWrapper);
        wrapper.setLayoutData((Object)new GridData(4, 4, true, false));
        this.testingTypeTabGroup = new Composite(wrapper, 0);
        GridLayout glTabGroup = new GridLayout();
        glTabGroup.marginHeight = 0;
        this.testingTypeTabGroup.setLayout((Layout)glTabGroup);
        this.testingTypeTabGroup.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        this.testingTypeTabGroup.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Point size = WelcomeRightPart.this.testingTypeTabGroup.getSize();
                gc.setForeground(SEPARATOR_COLOR);
                gc.setLineWidth(3);
                gc.drawLine(0, size.y, size.x, size.y);
            }
        });
        this.tabWebUi = this.createTestingTypeTab(MessageConstants.TAB_LBL_WEB_UI);
        this.tabApi = this.createTestingTypeTab(MessageConstants.TAB_LBL_API);
        this.tabMobile = this.createTestingTypeTab(MessageConstants.TAB_LBL_MOBILE);
        this.tabScripting = this.createTestingTypeTab(MessageConstants.TAB_LBL_SCRIPTING);
    }

    private CLabel createTestingTypeTab(String text) {
        ++((GridLayout)this.testingTypeTabGroup.getLayout()).numColumns;
        CLabel tabButton = new CLabel(this.testingTypeTabGroup, 0);
        tabButton.setText(text);
        tabButton.setLeftMargin(15);
        tabButton.setRightMargin(15);
        tabButton.setBottomMargin(8);
        tabButton.setCursor(Display.getCurrent().getSystemCursor(21));
        ControlUtils.setFontSize((Control)tabButton, (int)10);
        return tabButton;
    }

    private void createTabContentForTestingTypes() {
        this.testingTypeStackLayout = new StackLayout();
        Composite contentHolder = new Composite(this.gettingStartedContent, 0);
        contentHolder.setLayout((Layout)this.testingTypeStackLayout);
        contentHolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.webUiTabContent = this.createWebUiTabContent(contentHolder);
        this.mobileTabContent = this.createMobileTabContent(contentHolder);
        this.apiTabContent = this.createApiTabContent(contentHolder);
        this.scriptingTabContent = this.createScriptingTabContent(contentHolder);
    }

    private void setExtraDataToTestingTypeTabs() {
        this.tabWebUi.setData(KEY_CONTENT, (Object)this.webUiTabContent);
        this.tabMobile.setData(KEY_CONTENT, (Object)this.mobileTabContent);
        this.tabApi.setData(KEY_CONTENT, (Object)this.apiTabContent);
        this.tabScripting.setData(KEY_CONTENT, (Object)this.scriptingTabContent);
    }

    private void registerListenersForTestingTypeTabs() {
        this.registerListenersForTestingTypeTab(this.tabWebUi);
        this.registerListenersForTestingTypeTab(this.tabMobile);
        this.registerListenersForTestingTypeTab(this.tabApi);
        this.registerListenersForTestingTypeTab(this.tabScripting);
    }

    private void registerListenersForTestingTypeTab(final CLabel tab) {
        tab.addListener(3, e -> this.handleSelectingTestingTypeTab(tab));
        tab.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                if (tab == WelcomeRightPart.this.selectedTestingTypeTab) {
                    Point size = tab.getSize();
                    gc.setForeground(BLUE_COLOR);
                    gc.setLineWidth(3);
                    gc.drawLine(0, size.y, size.x, size.y);
                } else {
                    Point size = tab.getSize();
                    gc.setForeground(SEPARATOR_COLOR);
                    gc.setLineWidth(3);
                    gc.drawLine(0, size.y, size.x, size.y);
                }
            }
        });
    }

    private void handleSelectingTestingTypeTab(CLabel tab) {
        this.selectedTestingTypeTab = tab;
        Control[] controlArray = this.testingTypeTabGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control testingTypeTab = controlArray[n2];
            testingTypeTab.setForeground(TEXT_COLOR);
            ControlUtils.setFontStyle((Control)testingTypeTab, (int)0, (int)-1);
            testingTypeTab.redraw();
            ++n2;
        }
        tab.setForeground(BLUE_COLOR);
        ControlUtils.setFontToBeBold((Control)tab);
        this.testingTypeStackLayout.topControl = (Composite)tab.getData(KEY_CONTENT);
        this.gettingStartedContent.layout(true, true);
        tab.layout();
    }

    private Composite createWebUiTabContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.createIntroLink(content, StringConstants.PA_URL_GETTING_STARTED);
        Composite main = new Composite(content, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        main.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_1, MessageConstants.URL_COMMON_STEP_RECORD, ImageConstants.IMG_SCREENSHOT_SCREEN_SHOT_RECORD);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_2, MessageConstants.URL_COMMON_STEP_RUN, ImageConstants.IMG_SCREENSHOT_SCREEN_SHOT_RUN);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_3, MessageConstants.URL_COMMON_STEP_VIEW_LOGGER, ImageConstants.IMG_SCREENSHOT_SCREEN_SHOT_LOG_VIEWER);
        return content;
    }

    private Composite createMobileTabContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.createIntroLink(content, StringConstants.PA_URL_GETTING_STARTED);
        Composite main = new Composite(content, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        main.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_1, MessageConstants.URL_MOBILE_RECORD, ImageConstants.IMG_SCREEN_SHOT_MOBILE_RECORD);
        if (Platform.getOS().equals("macosx")) {
            this.addGettingStartedStep(main, ImageConstants.IMG_STEP_2, MessageConstants.URL_MOBILE_CONFIG_AND_RECORD_STEP_MAC, ImageConstants.IMG_SCREEN_SHOT_MOBILE_CONFIG_AND_RECORD_STEP);
        } else {
            this.addGettingStartedStep(main, ImageConstants.IMG_STEP_2, MessageConstants.URL_MOBILE_CONFIG_AND_RECORD_STEP_WINDOWS, ImageConstants.IMG_SCREEN_SHOT_MOBILE_CONFIG_AND_RECORD_STEP);
        }
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_3, MessageConstants.URL_COMMON_STEP_RUN, ImageConstants.IMG_SCREENSHOT_SCREEN_SHOT_RUN);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_4, MessageConstants.URL_COMMON_STEP_VIEW_LOGGER, ImageConstants.IMG_SCREEN_SHOT_MOBILE_LOG_VIEWER);
        return content;
    }

    private Composite createApiTabContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.createIntroLink(content, StringConstants.PA_URL_GETTING_STARTED);
        Composite main = new Composite(content, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        main.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_1, MessageConstants.URL_USE_DRAFT_REQUEST, ImageConstants.IMG_SCREEN_SHOT_USE_DRAFT_REQUEST);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_2, MessageConstants.URL_SAVE_DRAFT_REQUEST, ImageConstants.IMG_SCREEN_SHOT_SAVE_DRAFT_REQUEST);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_3, MessageConstants.URL_USE_WEB_SERVICE_IN_TEST_CASE, ImageConstants.IMG_SCREEN_SHOT_ADD_REQUEST_TO_TEST_CASE);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_4, MessageConstants.URL_API_EXECUTE_TEST_CASE, ImageConstants.IMG_SCREENSHOT_SCREEN_SHOT_RUN);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_5, MessageConstants.URL_COMMON_STEP_VIEW_LOGGER, ImageConstants.IMG_SCREEN_SHOT_API_LOG_VIEWER);
        return content;
    }

    private Composite createScriptingTabContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.createIntroLink(content, StringConstants.PA_URL_GETTING_STARTED);
        Composite main = new Composite(content, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        main.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.addGettingStartedStep(main, ImageConstants.IMG_SCRIPT_BULLET, MessageConstants.URL_SCRIPT_NEW_TEST_CASE, ImageConstants.IMG_SCREEN_SHOT_SCRIPT_NEW_TEST_CASE);
        this.addGettingStartedStep(main, ImageConstants.IMG_SCRIPT_BULLET, MessageConstants.URL_ADD_OR_IMPORT_KEYWORDS, ImageConstants.IMG_SCREEN_SHOT_ADD_OR_IMPORT_KEYWORDS);
        this.addGettingStartedStep(main, ImageConstants.IMG_SCRIPT_BULLET, MessageConstants.URL_CREATE_TEST_LISTENER, ImageConstants.IMG_SCREEN_SHOT_CREATE_TEST_LISTENER);
        this.addGettingStartedStep(main, ImageConstants.IMG_SCRIPT_BULLET, MessageConstants.URL_BUILD_CMD, ImageConstants.IMG_SCREEN_SHOT_BUILD_CMD);
        return content;
    }

    private void createIntroLink(Composite parent, String link) {
        Link introText = new Link(parent, 0);
        introText.setText(link);
        introText.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        introText.setForeground(TEXT_COLOR);
        introText.setLinkForeground(TEXT_COLOR);
        ControlUtils.setFontStyle((Control)introText, (int)2, (int)10);
        introText.addSelectionListener((SelectionListener)linkSelectionAdapter);
    }

    private void createSamplesTabContent() {
        this.samplesContent = this.createContentComposite(this.tabContentCompositeStack);
        Composite holder = new Composite(this.samplesContent, 0);
        GridLayout glHolder = new GridLayout(3, true);
        glHolder.horizontalSpacing = 30;
        glHolder.verticalSpacing = 30;
        holder.setLayout((Layout)glHolder);
        holder.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        this.thread = new Thread(() -> {
            SampleRemoteProjectProvider sampleRemoteProjectProvider = new SampleRemoteProjectProvider();
            List sampleProjects = sampleRemoteProjectProvider.getSampleProjects();
            ArrayList composites = new ArrayList();
            UISynchronizeService.syncExec(() -> {
                if (this.samplesContent == null || this.samplesContent.isDisposed()) {
                    return;
                }
                this.samplesContent.setRedraw(false);
                if (sampleProjects.size() <= 0) {
                    this.addDefaultSampleProjects(holder);
                }
                Composite latestComposite = null;
                for (final SampleRemoteProject sample : sampleProjects) {
                    latestComposite = this.addProjectBlock(holder, this.getDefaultImage((SampleProject)sample), ImageConstants.IMG_GITHUB_LOGO, sample.getName(), sample.getName(), new MouseAdapter(){

                        public void mouseUp(MouseEvent e) {
                            NewProjectDialog dialog = new NewProjectDialog(WelcomeRightPart.this.getShell(), (SampleProject)sample);
                            dialog.open();
                        }
                    });
                    composites.add(latestComposite);
                }
                this.addProjectBlock(holder, ImageConstants.IMG_SAMPLE_MORE, MessageConstants.LBL_MORE_PROJECT, MessageConstants.LBL_MORE_PROJECT_TOOLTIP, new MouseAdapter(){

                    public void mouseUp(MouseEvent e) {
                        Program.launch((String)MessageConstants.LBL_MORE_PROJECT_URL);
                    }
                });
                this.samplesContent.layout(true, true);
                this.samplesContent.setRedraw(true);
            });
            sampleProjects.parallelStream().forEach(sample -> {
                final Map imageFiles = sampleRemoteProjectProvider.getThumbnailFiles(sample);
                int index = sampleProjects.indexOf(sample);
                Composite composite = (Composite)composites.get(index);
                UISynchronizeService.asyncExec(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    Label lblIcon = (Label)composite.getData("icon");
                    if (imageFiles != null && imageFiles.size() > 0) {
                        composite.setRedraw(false);
                        lblIcon.setImage(this.createImage(this.getDisplay(), imageFiles));
                        composite.setRedraw(true);
                        lblIcon.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                imageFiles.entrySet().forEach(entry -> {
                                    boolean bl = FileUtils.deleteQuietly((File)((File)entry.getValue()));
                                });
                            }
                        });
                    }
                });
            });
        });
        this.thread.start();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (WelcomeRightPart.this.thread != null && !WelcomeRightPart.this.thread.isInterrupted()) {
                    WelcomeRightPart.this.thread.interrupt();
                }
            }
        });
    }

    private Image getDefaultImage(SampleProject sampleProject) {
        switch (sampleProject.getType()) {
            case MOBILE: {
                return ImageConstants.IMG_SAMPLE_MOBILE_PROJECT;
            }
            case WEBUI: {
                return ImageConstants.IMG_SAMPLE_WEB_UI_PROJECT;
            }
            case WS: {
                return ImageConstants.IMG_SAMPLE_WEB_SERVICE_PROJECT;
            }
        }
        return ImageConstants.IMG_SAMPLE_REMOTE;
    }

    private void addDefaultSampleProjects(Composite holder) {
        List localProjects = SampleProjectProvider.getInstance().getSampleProjects();
        localProjects.stream().forEach(project -> this.addProjectBlock(holder, this.getDefaultImage((SampleProject)project), project.getName(), this.getTooltipForSampleLocalProject((SampleLocalProject)project), new MouseAdapter((SampleLocalProject)project){
            private final /* synthetic */ SampleLocalProject val$project;
            {
                this.val$project = sampleLocalProject;
            }

            public void mouseUp(MouseEvent e) {
                try {
                    NewSampleLocalProjectHandler.doCreateNewSampleProject((Shell)Display.getCurrent().getActiveShell(), (SampleLocalProject)this.val$project, (IEventBroker)EventBrokerSingleton.getInstance().getEventBroker());
                }
                catch (Exception ex) {
                    MessageDialog.openError(null, (String)StringConstants.ERROR, (String)ex.getMessage());
                }
            }
        }));
    }

    private String getTooltipForSampleLocalProject(SampleLocalProject sampleLocalProject) {
        switch (sampleLocalProject.getType()) {
            case MOBILE: {
                return MessageConstants.PA_TOOLTIP_SAMPLE_MOBILE_PROJECT;
            }
            case WEBUI: {
                return MessageConstants.PA_TOOLTIP_SAMPLE_WEB_UI_PROJECT;
            }
            case WS: {
                return MessageConstants.PA_TOOLTIP_SAMPLE_WEB_SERVICE_PROJECT;
            }
        }
        return null;
    }

    public Image createImage(Display display, Map<Integer, File> allImageFiles) {
        final Map<Integer, Image> allImages = allImageFiles.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            try {
                return new Image((Device)display, (InputStream)new FileInputStream((File)e.getValue()));
            }
            catch (IOException iOException) {
                return ImageConstants.IMG_SAMPLE_REMOTE;
            }
        }));
        ImageDataProvider dateProvider = new ImageDataProvider(){

            public ImageData getImageData(int zoom) {
                return ((Image)allImages.get(zoom)).getImageData();
            }
        };
        return new Image((Device)display, dateProvider);
    }

    private void createRecentsTabContent() {
        this.recentsContent = this.createContentComposite(this.tabContentCompositeStack);
        this.recentsProjectHolder = new Composite(this.recentsContent, 0);
        GridLayout glHolder = new GridLayout(3, true);
        glHolder.horizontalSpacing = 30;
        glHolder.verticalSpacing = 30;
        this.recentsProjectHolder.setLayout((Layout)glHolder);
        this.recentsProjectHolder.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        this.populateRecentProjects();
    }

    private Composite createContentComposite(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 30;
        c.setLayout((Layout)gl);
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        return c;
    }

    private void populateRecentProjects() {
        List<ProjectEntity> recentProjects = this.getRecentProjects();
        if (recentProjects.isEmpty()) {
            Label lblNoProject = new Label(this.recentsProjectHolder, 0);
            lblNoProject.setAlignment(0x1000000);
            lblNoProject.setText(MessageConstants.MSG_NO_RECENT_PROJECT);
            lblNoProject.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 3, 1));
            lblNoProject.setForeground(TEXT_COLOR);
            ControlUtils.setFontStyle((Control)lblNoProject, (int)0, (int)12);
            return;
        }
        if (recentProjects.size() < 4) {
            GridLayout gl = (GridLayout)this.recentsProjectHolder.getLayout();
            gl.numColumns = recentProjects.size();
        }
        final ProjectParameterizedCommandBuilder commandBuilder = new ProjectParameterizedCommandBuilder();
        for (final ProjectEntity project : recentProjects) {
            this.addProjectBlock(this.recentsProjectHolder, ImageConstants.IMG_RECENT_PROJECT_FILE, StringUtils.abbreviate((String)project.getName(), (int)36), MessageFormat.format(StringConstants.PA_TOOLTIP_OPEN_RECENT_PROJECT, project.getName()), new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    try {
                        WelcomeRightPart.this.commandCaller.call(commandBuilder.createRecentProjectParameterizedCommand(project));
                    }
                    catch (CommandException ex) {
                        LoggerSingleton.logError((Throwable)ex);
                    }
                }
            });
        }
        this.recentsProjectHolder.layout();
    }

    private void addGettingStartedStep(Composite parent, Image stepNumberImage, String text, Image stepDetailsImage) {
        Composite c = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginTop = 25;
        c.setLayout((Layout)gl);
        c.setLayoutData((Object)new GridData(4, 128, true, false));
        CLabel stepNumber = new CLabel(c, 0);
        stepNumber.setImage(stepNumberImage);
        stepNumber.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        Link stepText = new Link(c, 0);
        stepText.setText(text);
        stepText.setForeground(STEP_DESCRIPTION_COLOR);
        stepText.setLinkForeground(BLUE_COLOR);
        stepText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        ControlUtils.setFontStyle((Control)stepText, (int)0, (int)12);
        stepText.addSelectionListener((SelectionListener)linkSelectionAdapter);
        CLabel stepDetails = new CLabel(parent, 0);
        stepDetails.setImage(stepDetailsImage);
        stepDetails.setLeftMargin(40);
        stepDetails.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private Composite addProjectBlock(Composite parent, Image icon, String label, String tooltip, MouseAdapter action) {
        return this.addProjectBlock(parent, icon, null, label, tooltip, action);
    }

    private Composite addProjectBlock(Composite parent, Image icon, Image subIcon, String label, String tooltip, MouseAdapter action) {
        if (parent == null || parent.isDisposed()) {
            return null;
        }
        Composite c = new Composite(parent, 2048);
        GridLayout gl = new GridLayout();
        c.setLayout((Layout)gl);
        GridData ld = new GridData(4, 128, true, true);
        ld.widthHint = 210;
        ld.heightHint = 190;
        c.setLayoutData((Object)ld);
        c.setCursor(CURSOR_HAND);
        c.addMouseListener((MouseListener)action);
        c.setToolTipText(tooltip);
        Composite imageComposite = new Composite(c, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 120;
        imageComposite.setLayoutData((Object)layoutData);
        imageComposite.setLayout((Layout)new GridLayout());
        imageComposite.addMouseListener((MouseListener)action);
        if (subIcon != null) {
            Label lblSubIcon = new Label(imageComposite, 0);
            lblSubIcon.setAlignment(131072);
            lblSubIcon.setImage(subIcon);
            lblSubIcon.setToolTipText(tooltip);
            lblSubIcon.setLayoutData((Object)new GridData(131072, 128, true, false));
            lblSubIcon.addMouseListener((MouseListener)action);
        }
        Label lblIcon = new Label(imageComposite, 0);
        lblIcon.setAlignment(0x1000000);
        lblIcon.setImage(icon);
        lblIcon.setToolTipText(tooltip);
        lblIcon.setLayoutData((Object)new GridData(0x1000000, 1024, true, true));
        lblIcon.addMouseListener((MouseListener)action);
        c.setData("icon", (Object)lblIcon);
        Composite textComposite = new Composite(c, 0);
        GridData gdTextComposite = new GridData(4, 1024, true, true);
        gdTextComposite.heightHint = 60;
        textComposite.setLayoutData((Object)gdTextComposite);
        textComposite.addMouseListener((MouseListener)action);
        GridLayout glTextComposite = new GridLayout();
        glTextComposite.marginWidth = 30;
        glTextComposite.marginBottom = 5;
        textComposite.setLayout((Layout)glTextComposite);
        Text lblText = new Text(textComposite, 16777288);
        lblText.setText(label);
        lblText.setToolTipText(tooltip);
        lblText.setForeground(TEXT_COLOR);
        lblText.setBackground(textComposite.getBackground());
        lblText.setCursor(CURSOR_HAND);
        ControlUtils.setFontStyle((Control)lblText, (int)0, (int)12);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = 2 * lblText.getLineHeight();
        lblText.setLayoutData((Object)gridData);
        lblText.addMouseListener((MouseListener)action);
        lblText.getLineCount();
        return c;
    }

    private void clearRecentProjectBlocks() {
        if (this.recentsProjectHolder == null || this.recentsProjectHolder.isDisposed()) {
            return;
        }
        Control[] controlArray = this.recentsProjectHolder.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!control.isDisposed()) {
                control.dispose();
            }
            ++n2;
        }
    }

    private List<ProjectEntity> getRecentProjects() {
        try {
            return ProjectController.getInstance().getRecentProjects();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    protected void checkSubclass() {
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "PROJECT/OPENED": {
                this.setDefaultTestingTypeTabByProjectType();
                break;
            }
        }
    }

    public void onPartClosed() {
        this.eventBroker.unsubscribe((EventHandler)this);
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }
}

