/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import java.text.MessageFormat;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class WelcomeLeftPart
extends Composite {
    private static final String RELEASE_NOTES_URL = MessageConstants.RELEASE_NOTE_URL;
    private static final Color BACKGROUND_COLOR = ColorUtil.getColor((String)"#70746F");
    private static final Color VERSION_TEXT_COLOR = ColorUtil.getColor((String)"#BDBDBD");
    private static final Color PLUGIN_STORE_ITEM_BACKGROUND_COLOR = ColorUtil.getColor((String)"#FFD966");
    private static final Cursor CURSOR_HAND = Display.getDefault().getSystemCursor(21);
    private static final int MIN_WIDTH = 300;

    public WelcomeLeftPart(Composite parent, int style) {
        super(parent, style);
        this.setBackground(BACKGROUND_COLOR);
        this.setBackgroundMode(2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.createBrandingControls();
        this.createQuickHelpMenu();
    }

    private void createBrandingControls() {
        Composite upperComposite = new Composite((Composite)this, 0);
        upperComposite.setBackground(BACKGROUND_COLOR);
        upperComposite.setLayout((Layout)new GridLayout());
        GridData gd_upperComposite = new GridData(4, 0x1000000, true, false);
        gd_upperComposite.minimumWidth = 300;
        upperComposite.setLayoutData((Object)gd_upperComposite);
        Composite headerComposite = new Composite(upperComposite, 0);
        headerComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        RowLayout rlHeaderComposite = new RowLayout(512);
        rlHeaderComposite.spacing = 20;
        rlHeaderComposite.marginHeight = 40;
        rlHeaderComposite.center = true;
        headerComposite.setLayout((Layout)rlHeaderComposite);
        CLabel lblLogo = new CLabel(headerComposite, 0);
        lblLogo.setAlignment(0x1000000);
        lblLogo.setImage(ImageConstants.IMG_BRANDING);
        CLabel lblVersion = new CLabel(headerComposite, 0);
        ControlUtils.setFontSize((Control)lblVersion, (int)14);
        lblVersion.setText(MessageFormat.format(MessageConstants.PA_LBL_KATALON_VERSION, ApplicationInfo.versionNo()));
        lblVersion.setForeground(VERSION_TEXT_COLOR);
        Link lblReleaseNote = new Link(headerComposite, 0);
        ControlUtils.setFontStyle((Control)lblReleaseNote, (int)2, (int)12);
        lblReleaseNote.setText(RELEASE_NOTES_URL);
        lblReleaseNote.setLinkForeground(VERSION_TEXT_COLOR);
        lblReleaseNote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)e.text);
            }
        });
    }

    private void createQuickHelpMenu() {
        Composite lowerComposite = new Composite((Composite)this, 0);
        lowerComposite.setBackground(BACKGROUND_COLOR);
        GridLayout glLowerComposite = new GridLayout();
        glLowerComposite.marginHeight = 0;
        glLowerComposite.marginWidth = 0;
        lowerComposite.setLayout((Layout)glLowerComposite);
        GridData gdLowerComposite = new GridData(4, 4, true, true);
        gdLowerComposite.minimumWidth = 300;
        lowerComposite.setLayoutData((Object)gdLowerComposite);
        this.addMenuItem(lowerComposite, ImageConstants.IMG_TUTORIAL, MessageConstants.PA_LBL_TUTORIALS, MessageConstants.PA_LBL_TUTORIALS_URL);
        this.addMenuSeparator(lowerComposite);
        this.addMenuItem(lowerComposite, ImageConstants.IMG_FAQ, StringConstants.PA_LBL_FAQ, StringConstants.PA_LBL_FAQ_URL);
        this.addPluginStoreMenuItem(lowerComposite);
        this.addMenuItem(lowerComposite, ImageConstants.IMG_BUSSINESS_SUPPORT, StringConstants.PA_LBL_BUSINESS_SUPPORT, StringConstants.URL_KATALON_SUPPORT_SERVICE);
    }

    private void addPluginStoreMenuItem(Composite parent) {
        Composite marginTop = new Composite(parent, 0);
        GridData gdMarginTop = new GridData(4, 128, true, false);
        gdMarginTop.minimumWidth = 300;
        gdMarginTop.heightHint = 5;
        marginTop.setLayoutData((Object)gdMarginTop);
        marginTop.setBackground(BACKGROUND_COLOR);
        Composite holder = new Composite(parent, 0);
        GridData gdHolder = new GridData(4, 4, true, false);
        gdHolder.minimumWidth = 300;
        holder.setLayoutData((Object)gdHolder);
        holder.setBackground(PLUGIN_STORE_ITEM_BACKGROUND_COLOR);
        GridLayout glHolder = new GridLayout(1, false);
        glHolder.marginTop = 15;
        glHolder.marginBottom = 10;
        holder.setLayout((Layout)glHolder);
        holder.setCursor(CURSOR_HAND);
        Composite inner = new Composite(holder, 0);
        GridData gdInner = new GridData(0x1000000, 4, true, true);
        gdInner.minimumWidth = 170;
        inner.setLayoutData((Object)gdInner);
        inner.setBackground(PLUGIN_STORE_ITEM_BACKGROUND_COLOR);
        GridLayout glInner = new GridLayout(1, false);
        inner.setLayout((Layout)glInner);
        inner.setCursor(CURSOR_HAND);
        CLabel menuItem = new CLabel(inner, 0);
        menuItem.setAlignment(0x1000000);
        menuItem.setImage(ImageConstants.IMG_KATALON_STORE);
        menuItem.setText(StringConstants.PA_LBL_PLUGIN_STORE);
        menuItem.setForeground(ColorUtil.getDefaultTextColor());
        menuItem.setCursor(CURSOR_HAND);
        ControlUtils.setFontSize((Control)menuItem, (int)12);
        Composite marginBottom = new Composite(parent, 0);
        GridData gdMarginBottom = new GridData(4, 128, true, false);
        gdMarginBottom.minimumWidth = 300;
        gdMarginBottom.heightHint = 5;
        marginBottom.setLayoutData((Object)gdMarginBottom);
        marginBottom.setBackground(BACKGROUND_COLOR);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                WelcomeLeftPart.this.openURL(StringConstants.PA_LBL_PLUGIN_STORE_URL);
            }
        };
        menuItem.addMouseListener((MouseListener)mouseAdapter);
        holder.addMouseListener((MouseListener)mouseAdapter);
        inner.addMouseListener((MouseListener)mouseAdapter);
    }

    private void addMenuItem(Composite parent, Image icon, String label, final String url) {
        Composite holder = new Composite(parent, 0);
        GridData gdHolder = new GridData(0x1000000, 4, true, false);
        gdHolder.minimumWidth = 170;
        holder.setLayoutData((Object)gdHolder);
        holder.setBackground(BACKGROUND_COLOR);
        RowLayout rlMenuComposite = new RowLayout(512);
        rlMenuComposite.marginHeight = 10;
        rlMenuComposite.spacing = 20;
        holder.setLayout((Layout)rlMenuComposite);
        holder.setCursor(CURSOR_HAND);
        CLabel menuItem = new CLabel(holder, 0);
        menuItem.setAlignment(0x1000000);
        menuItem.setImage(icon);
        menuItem.setText(label);
        menuItem.setForeground(ColorUtil.getTextWhiteColor());
        menuItem.setCursor(CURSOR_HAND);
        ControlUtils.setFontSize((Control)menuItem, (int)12);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                WelcomeLeftPart.this.openURL(url);
            }
        };
        menuItem.addMouseListener((MouseListener)mouseAdapter);
        holder.addMouseListener((MouseListener)mouseAdapter);
    }

    private void addMenuSeparator(Composite parent) {
        CLabel separator = new CLabel(parent, 0);
        separator.setMargins(0, 0, 0, 0);
        separator.setAlignment(131072);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        separator.setImage(ImageConstants.IMG_GRADIENT_LINE_SEPARATOR);
    }

    private void openURL(String url) {
        Program.launch((String)url);
    }

    protected void checkSubclass() {
    }
}

