/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.intro;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class StarRating
extends Composite {
    private Image image;
    private int hoverSelected = 0;
    private int selected = 0;
    private int nrOfImages = 5;
    private int alpha = 150;
    private int width;
    private int height;
    private boolean vertical = false;

    public StarRating(Composite parent, int style) {
        super(parent, style);
        this.addListener(12, new Listener(){

            public void handleEvent(Event arg0) {
                if (StarRating.this.image != null) {
                    StarRating.this.image.dispose();
                }
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                StarRating.this.paintControl(e);
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event arg0) {
                int x = arg0.x;
                int y = arg0.y;
                int step = (StarRating.this.vertical ? StarRating.this.height : StarRating.this.width) + 1;
                int location = StarRating.this.vertical ? y : x;
                int current = location / step;
                if (current != StarRating.this.hoverSelected) {
                    StarRating.this.hoverSelected = current;
                    StarRating.this.redraw();
                }
            }
        });
        this.addListener(7, new Listener(){

            public void handleEvent(Event arg0) {
                StarRating.this.hoverSelected = StarRating.this.selected;
                StarRating.this.redraw();
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                StarRating.this.selected = StarRating.this.hoverSelected;
            }
        });
    }

    private void paintControl(Event event) {
        GC gc = event.gc;
        if (this.image != null) {
            int stepX = this.vertical ? 0 : this.width + 1;
            int stepY = this.vertical ? this.height + 1 : 0;
            int i = 0;
            while (i < this.nrOfImages) {
                if (i == this.hoverSelected + 1) {
                    gc.setAlpha(this.alpha);
                }
                gc.drawImage(this.image, 1 + stepX * i, 1 + stepY * i);
                ++i;
            }
            gc.setAlpha(255);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.width = image.getBounds().width;
        this.height = image.getBounds().height;
        this.redraw();
    }

    public void setNrOfStars(int nrOfStars) {
        if (nrOfStars < 1) {
            throw new IllegalArgumentException("Invalid value for number of stars. Minimum: 1, Selection: " + nrOfStars);
        }
        this.nrOfImages = nrOfStars;
    }

    public int getNrOfStars() {
        return this.nrOfImages;
    }

    public int getSelection() {
        return this.selected + 1;
    }

    public void setSelection(int selection) {
        if (selection < 0 || selection > this.nrOfImages) {
            throw new IllegalArgumentException("Invalid value for star selection. Minimum: 0, Maximum: " + this.nrOfImages + ", Selection: " + selection);
        }
        this.hoverSelected = this.selected = selection - 1;
    }

    public void setAlpha(int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Invalid alpha value. Minimum: 0, Maximum: 255, Selection: " + alpha);
        }
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public boolean getVertical() {
        return this.vertical;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int overallWidth = 0;
        int overallHeight = 0;
        if (this.image != null) {
            overallWidth = this.vertical ? this.width : this.width * this.nrOfImages + this.nrOfImages - 1;
            int n = overallHeight = this.vertical ? this.height * this.nrOfImages + this.nrOfImages - 1 : this.height;
        }
        if (wHint != -1 && wHint < overallWidth) {
            overallWidth = wHint;
        }
        if (hHint != -1 && hHint < overallHeight) {
            overallHeight = hHint;
        }
        return new Point(overallWidth + 2, overallHeight + 2);
    }
}

