/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.initializer;

import com.kms.katalon.composer.components.impl.handler.WorkbenchUtilizer;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.initializer.ApplicationInitializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.keys.IBindingService;

public class CommandBindingInitializer
extends WorkbenchUtilizer
implements ApplicationInitializer {
    private static final String TEXT_EDITOR_CONTEXT_ID = "org.eclipse.ui.textEditorScope";

    public void resetDeleteKeyBinding() {
        BindingService bindingService = (BindingService)CommandBindingInitializer.getService(IBindingService.class);
        BindingTableManager tableManager = (BindingTableManager)CommandBindingInitializer.getService(BindingTableManager.class);
        BindingTable table = tableManager.getTable(TEXT_EDITOR_CONTEXT_ID);
        if (table == null) {
            return;
        }
        Command command = ((ICommandService)CommandBindingInitializer.getService(ICommandService.class)).getCommand(TextEditorCommand.DELETE.editorCommandId);
        if (command == null) {
            return;
        }
        Binding binding = table.getBestSequenceFor(ParameterizedCommand.generateCommand((Command)command, null));
        if (binding == null) {
            this.addBindingAndSave(bindingService);
        } else if (binding.getTriggerSequence() == null) {
            bindingService.removeBinding(binding);
            this.addBindingAndSave(bindingService);
        }
    }

    private void addBindingAndSave(BindingService bindingService) {
        try {
            bindingService.addBinding((Binding)TextEditorCommand.DELETE.newKeyBinding((IBindingService)bindingService, this.getCommandService()));
            this.saveActiveBinding(bindingService);
        }
        catch (ParseException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void saveActiveBinding(BindingService bindingService) {
        try {
            bindingService.savePreferences(bindingService.getActiveScheme(), bindingService.getActiveBindings().toArray(new Binding[0]));
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    public void setup() {
        BindingService bindingService = (BindingService)CommandBindingInitializer.getService(IBindingService.class);
        this.activeExplorerCommands(bindingService);
        this.saveActiveBinding(bindingService);
    }

    private ICommandService getCommandService() {
        ICommandService commandService = (ICommandService)CommandBindingInitializer.getService(ICommandService.class);
        return commandService;
    }

    private void activeExplorerCommands(BindingService bindingService) {
        ArrayList bindingsTobeSaved = new ArrayList(bindingService.getActiveBindings());
        Arrays.stream(bindingService.getBindings()).filter(a -> a.getParameterizedCommand() != null && a.getType() == 1).forEach(a -> {
            boolean bl = bindingsTobeSaved.add(a);
        });
        try {
            bindingService.savePreferences(bindingService.getActiveScheme(), bindingsTobeSaved.toArray(new Binding[0]));
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        TextEditorCommand[] textEditorCommandArray = TextEditorCommand.values();
        int n = textEditorCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditorCommand command = textEditorCommandArray[n2];
            try {
                this.activeKeyBindingForExplorerCommand(bindingService, command);
            }
            catch (ParseException e) {
                LoggerSingleton.logError((Throwable)e);
            }
            ++n2;
        }
    }

    private void activeKeyBindingForExplorerCommand(BindingService bindingService, TextEditorCommand command) throws ParseException {
        String explorerCommandId = command.getExplorerCommandId();
        TriggerSequence triggerSequence = bindingService.getBestActiveBindingFor(explorerCommandId);
        for (Binding activeBinding : bindingService.getActiveBindings()) {
            String overlappedCommandId;
            if (!(activeBinding instanceof KeyBinding) || !triggerSequence.equals((Object)activeBinding.getTriggerSequence()) || (overlappedCommandId = activeBinding.getParameterizedCommand().getId()).equals(explorerCommandId)) continue;
            bindingService.removeBinding(activeBinding);
            if (!overlappedCommandId.equals(command.getEditorCommandId())) continue;
            bindingService.addBinding((Binding)command.newKeyBinding((IBindingService)bindingService, this.getCommandService()));
        }
    }

    private static enum TextEditorCommand {
        OPEN("com.kms.katalon.composer.explorer.command.open", "org.eclipse.jdt.ui.edit.text.java.open.editor", "F3"),
        RENAME("com.kms.katalon.composer.explorer.command.rename", "", "F2"),
        COPY("com.kms.katalon.composer.explorer.command.copy", "org.eclipse.ui.edit.copy", "M1+C"),
        CUT("com.kms.katalon.composer.explorer.command.cut", "org.eclipse.ui.edit.cut", "M1+X"),
        PASTE("com.kms.katalon.composer.explorer.command.paste", "org.eclipse.ui.edit.paste", "M1+V"),
        DELETE("com.kms.katalon.composer.explorer.command.delete", "org.eclipse.ui.edit.delete", "Delete"),
        GO_TO_MATCHING_BRACKET("org.eclipse.ui.window.preferences", "org.eclipse.jdt.ui.edit.text.java.goto.matching.bracket", "M1+M2+P");

        private String editorCommandId;
        private String explorerCommandId;
        private String keySequence;

        private TextEditorCommand(String explorerCommandId, String commandId, String keySequence) {
            this.explorerCommandId = explorerCommandId;
            this.editorCommandId = commandId;
            this.keySequence = keySequence;
        }

        public String getExplorerCommandId() {
            return this.explorerCommandId;
        }

        public String getEditorCommandId() {
            return this.editorCommandId;
        }

        public KeyBinding newKeyBinding(IBindingService bindingService, ICommandService commandService) throws ParseException {
            ParameterizedCommand parameterizedCommand = new ParameterizedCommand(commandService.getCommand(this.editorCommandId), null);
            return new KeyBinding(KeySequence.getInstance((String)this.keySequence), parameterizedCommand, bindingService.getActiveScheme().getId(), CommandBindingInitializer.TEXT_EDITOR_CONTEXT_ID, null, null, null, 1);
        }
    }
}

