/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.YesNoCancel;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.util.groovy.editor;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.e4.ui.internal.workbench.PartServiceSaveHandler;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;

public class WorkbenchSaveHandler
extends PartServiceSaveHandler {
    public boolean save(MPart dirtyPart, boolean confirm) {
        if (dirtyPart.getObject() instanceof CompatibilityEditor) {
            if (confirm) {
                switch (this.promptToSave(dirtyPart)) {
                    case NO: {
                        this.refreshKeywordRootTreeEntity();
                        return true;
                    }
                    case CANCEL: {
                        return false;
                    }
                }
            }
            editor.saveEditor((MPart)dirtyPart);
            EventBrokerSingleton.getInstance().getEventBroker().post("EDITORS_SAVED", (Object)dirtyPart);
            return true;
        }
        return super.save(dirtyPart, confirm);
    }

    private void refreshKeywordRootTreeEntity() {
        block5: {
            FolderTreeEntity keywordRootFolder = null;
            try {
                try {
                    keywordRootFolder = new FolderTreeEntity(FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject()), null);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)keywordRootFolder);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", keywordRootFolder);
                throw throwable;
            }
            EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)keywordRootFolder);
        }
    }

    public ISaveHandler.Save promptToSave(MPart dirtyPart) {
        String message = MessageFormat.format(WorkbenchMessages.EditorManager_saveChangesQuestion, dirtyPart.getLabel());
        MessageDialog dialog = new MessageDialog(null, "Save Part", null, message, 6, YesNoCancel.valuesString(), 0);
        YesNoCancel selection = YesNoCancel.getOption((int)dialog.open());
        switch (selection) {
            case CANCEL: {
                return ISaveHandler.Save.CANCEL;
            }
            case NO: {
                dirtyPart.setDirty(false);
                return ISaveHandler.Save.NO;
            }
            case YES: {
                return ISaveHandler.Save.YES;
            }
        }
        return ISaveHandler.Save.NO;
    }

    public ISaveHandler.Save[] promptToSave(Collection<MPart> dirtyParts) {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ((MPart)element).getLocalizedLabel();
            }
        };
        ArrayList<MPart> parts = new ArrayList<MPart>(dirtyParts);
        ListSelectionDialog dialog = new ListSelectionDialog(null, parts, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)labelProvider, WorkbenchMessages.EditorManager_saveResourcesMessage);
        dialog.setInitialSelections(parts.toArray());
        dialog.setTitle(WorkbenchMessages.EditorManager_saveResourcesTitle);
        if (dialog.open() == 1) {
            return new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL};
        }
        Object[] toSave = dialog.getResult();
        Object[] retSaves = new ISaveHandler.Save[parts.size()];
        Arrays.fill(retSaves, ISaveHandler.Save.NO);
        int i = 0;
        while (i < parts.size()) {
            MPart part = (MPart)parts.get(i);
            Object[] objectArray = toSave;
            int n = toSave.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o == part) {
                    retSaves[i] = ISaveHandler.Save.YES;
                    break;
                }
                ++n2;
            }
            part.setDirty(false);
            ++i;
        }
        return retSaves;
    }
}

