/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.katalon.platform.internal.api.PluginInstaller;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.handlers.InstallPluginHandler;
import com.kms.katalon.constants.GlobalStringConstants;
import java.io.File;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class UninstallPluginHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private PluginInstaller pluginInstaller;

    @CanExecute
    public boolean canExecute() {
        return StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{InstallPluginHandler.getPluginPath()});
    }

    @Execute
    public void installPlugin() {
        Shell activeShell = Display.getCurrent().getActiveShell();
        try {
            Bundle bundle = this.pluginInstaller.uninstallPlugin(InternalPlatform.getDefault().getBundleContext(), new File(InstallPluginHandler.getPluginPath()).toURI().toString());
            if (bundle != null && "com.katalon.katalon-studio-jira-plugin".equals(bundle.getSymbolicName())) {
                this.eventBroker.post("PLUGIN/JIRA_UNINSTALLED", null);
            }
            MessageDialog.openInformation((Shell)activeShell, (String)GlobalStringConstants.INFO, (String)"Plugin successfully uninstalled");
            InstallPluginHandler.resetPluginPath();
        }
        catch (BundleException e) {
            MessageDialog.openError((Shell)activeShell, (String)GlobalStringConstants.ERROR, (String)"Unable to uninstall plugin");
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

