/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.handlers.RequireAuthorizationHandler;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.plugin.dialog.KStorePluginsDialog;
import com.kms.katalon.plugin.models.KStoreClientAuthException;
import com.kms.katalon.plugin.models.KStoreUsernamePasswordCredentials;
import com.kms.katalon.plugin.models.ResultItem;
import com.kms.katalon.plugin.service.PluginService;
import com.kms.katalon.plugin.store.PluginPreferenceStore;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ReloadPluginsHandler
extends RequireAuthorizationHandler {
    @Inject
    private IEventBroker eventBroker;
    private static final long DIALOG_CLOSED_DELAY_MILLIS = 500L;
    private PluginPreferenceStore store;
    private Job reloadPluginsJob;

    @PostConstruct
    public void registerEventListener() {
        this.store = new PluginPreferenceStore();
        this.eventBroker.subscribe("ACTIVATION/CHECKED", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                if (ReloadPluginsHandler.this.store.hasReloadedPluginsBefore()) {
                    ReloadPluginsHandler.this.reloadPlugins(true);
                }
            }
        });
    }

    @CanExecute
    public boolean canExecute() {
        return true;
    }

    @Execute
    public void execute() {
        this.reloadPlugins(false);
    }

    private void reloadPlugins(final boolean silenceMode) {
        final List[] resultHolder = new List[1];
        this.reloadPluginsJob = new Job("Reloading plugins..."){

            protected IStatus run(IProgressMonitor monitor) {
                block5: {
                    try {
                        KStoreUsernamePasswordCredentials[] credentials = new KStoreUsernamePasswordCredentials[1];
                        UISynchronizeService.syncExec(() -> {
                            try {
                                kStoreUsernamePasswordCredentialsArray[0] = ReloadPluginsHandler.this.getUsernamePasswordCredentials();
                            }
                            catch (KStoreClientAuthException e) {
                                LoggerSingleton.logError((Throwable)e);
                            }
                        });
                        if (credentials[0] != null) {
                            resultHolder[0] = PluginService.getInstance().reloadPlugins(credentials[0], monitor);
                            if (!ReloadPluginsHandler.this.store.hasReloadedPluginsBefore()) {
                                ReloadPluginsHandler.this.store.markFirstTimeReloadPlugins();
                            }
                            break block5;
                        }
                        return Status.CANCEL_STATUS;
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                        return new Status(4, "com.kms.katalon", "Error reloading plugins", (Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.reloadPluginsJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!ReloadPluginsHandler.this.reloadPluginsJob.getResult().isOK()) {
                    return;
                }
                if (silenceMode) {
                    return;
                }
                Executors.newSingleThreadExecutor().submit(() -> {
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    UISynchronizeService.syncExec(() -> ReloadPluginsHandler.this.openResultDialog(resultHolder[0]));
                });
            }
        });
        if (silenceMode) {
            this.reloadPluginsJob.setUser(false);
        } else {
            this.reloadPluginsJob.setUser(true);
        }
        this.reloadPluginsJob.schedule();
    }

    private void openResultDialog(List<ResultItem> result) {
        if (result.size() > 0) {
            KStorePluginsDialog dialog = new KStorePluginsDialog(Display.getCurrent().getActiveShell(), result);
            dialog.open();
        } else {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.INFO, (String)StringConstants.HAND_INFO_NO_PLUGINS_FOUND);
        }
    }
}

