/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.composer.components.impl.handler.AbstractHandler;
import com.kms.katalon.composer.handlers.PreferenceDialog;
import com.kms.katalon.composer.handlers.PreferencePageViewerComparator;
import com.kms.katalon.preferences.internal.PreferencesRegistry;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class PreferenceHandler
extends AbstractHandler {
    public static final String DEFAULT_PREFERENCE_PAGE_ID = "com.kms.katalon.composer.preferences.GeneralPreferencePage";
    private static final String[] UNNECESSARY_PREF_NODES = new String[0];

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        PreferenceHandler.doExecute();
    }

    public static void doExecute() {
        PreferenceHandler.doExecute(null);
    }

    public static int doExecute(String initPreferencePageId) {
        PreferenceManager applicationPref = ((PreferencesRegistry)ContextInjectionFactory.make(PreferencesRegistry.class, (IEclipseContext)PreferenceHandler.getWorkbenchContext())).getPreferenceManager("com.kms.katalon.preferences.PreferencePages");
        IPreferenceNode[] applicationNodes = applicationPref.getRootSubNodes();
        PreferenceManager workbenchPref = PreferenceHandler.getActiveWorkbench().getPreferenceManager();
        PreferenceHandler.removeUnnecessaryNodes(workbenchPref);
        PreferenceHandler.addApplicationNodesToWorkbenchPreferenceManger(workbenchPref, applicationNodes);
        int result = PreferenceHandler.openPreferenceDialog(workbenchPref, initPreferencePageId);
        PreferenceHandler.removeApplicationNodesFromWorkbenchPreferenceManager(workbenchPref, applicationNodes);
        return result;
    }

    @Inject
    @Optional
    public void execute(@UIEventTopic(value="KATALON/PREFERENCES") Object eventData) {
        if (eventData instanceof String) {
            PreferenceHandler.doExecute((String)eventData);
        } else {
            PreferenceHandler.doExecute();
        }
    }

    private static void removeUnnecessaryNodes(PreferenceManager workbenchPref) {
        String[] stringArray = UNNECESSARY_PREF_NODES;
        int n = UNNECESSARY_PREF_NODES.length;
        int n2 = 0;
        while (n2 < n) {
            String unnecessaryPreferenceId = stringArray[n2];
            workbenchPref.remove(unnecessaryPreferenceId);
            ++n2;
        }
    }

    private static void addApplicationNodesToWorkbenchPreferenceManger(PreferenceManager workbenchPref, IPreferenceNode[] applicationNodes) {
        IPreferenceNode[] iPreferenceNodeArray = applicationNodes;
        int n = applicationNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode subRoot = iPreferenceNodeArray[n2];
            if (workbenchPref.find(subRoot.getId()) == null) {
                workbenchPref.addToRoot(subRoot);
            }
            ++n2;
        }
    }

    private static void removeApplicationNodesFromWorkbenchPreferenceManager(PreferenceManager workbenchPref, IPreferenceNode[] applicationNodes) {
        IPreferenceNode[] iPreferenceNodeArray = applicationNodes;
        int n = applicationNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode subRoot = iPreferenceNodeArray[n2];
            workbenchPref.remove(subRoot);
            ++n2;
        }
    }

    private static int openPreferenceDialog(PreferenceManager workbenchPref, String initPreferencePagePath) {
        IPreferenceNode preference;
        PreferenceDialog dialog = new PreferenceDialog(PreferenceHandler.getActiveWorkbenchWindow().getShell(), workbenchPref);
        dialog.create();
        TreeViewer dialogTreeViewer = dialog.getTreeViewer();
        dialogTreeViewer.setComparator((ViewerComparator)new PreferencePageViewerComparator());
        dialog.setMinimumPageSize(500, 500);
        if (DEFAULT_PREFERENCE_PAGE_ID.equals(dialog.getSelectedNodePreference())) {
            dialogTreeViewer.expandToLevel((Object)dialog.getPreferenceManager().find(DEFAULT_PREFERENCE_PAGE_ID), 1);
        }
        if (StringUtils.isNotEmpty((CharSequence)initPreferencePagePath) && (preference = dialog.getPreferenceManager().find(initPreferencePagePath)) != null) {
            dialogTreeViewer.setSelection((ISelection)new StructuredSelection((Object)preference));
        }
        dialogTreeViewer.getTree().forceFocus();
        return dialog.open();
    }
}

