/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.plugin.models.KStoreApiKeyCredentials;
import com.kms.katalon.plugin.models.ResultItem;
import com.kms.katalon.plugin.service.PluginService;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ConsoleModeReloadPluginsHandler {
    public void reload(String apiKey) {
        try {
            LogUtil.printOutputLine((String)"Start reloading plugins...");
            KStoreApiKeyCredentials credentials = new KStoreApiKeyCredentials();
            credentials.setApiKey(apiKey);
            List<ResultItem> reloadPluginResults = PluginService.getInstance().reloadPlugins(credentials, (IProgressMonitor)new NullProgressMonitor());
            reloadPluginResults.stream().forEach(result -> {
                String pluginName = result.getPlugin().getProduct().getName();
                if (result.isPluginInstalled()) {
                    LogUtil.printOutputLine((String)MessageFormat.format(StringConstants.MSG_PLUGIN_HAS_BEEN_INSTALLED, pluginName));
                } else {
                    LogUtil.printOutputLine((String)MessageFormat.format(StringConstants.MSG_PLUGIN_HAS_BEEN_UNINSTALLED, pluginName));
                }
            });
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e, (String)"Failed to reload plugins.");
        }
    }
}

