/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.logging.LogManager;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ActiveEventLogPartHandler {
    @Inject
    private IEventBroker eventBroker;
    private Collection<ColorString> bufferredStrings = new ConcurrentLinkedQueue<ColorString>();
    private static ActiveEventLogPartHandler instance;

    @PostConstruct
    public void registerWorkbenchCreated() {
        instance = this;
        LogManager.getOutputLogger().setWriter(new PrintStream((OutputStream)LogManager.getOutputLogger()){

            @Override
            public void write(byte[] buf, int off, int len) {
                ActiveEventLogPartHandler.this.writeLog(buf, off, len);
            }
        });
        LogManager.getErrorLogger().setWriter(new PrintStream((OutputStream)LogManager.getOutputLogger()){

            @Override
            public void write(byte[] buf, int off, int len) {
                ActiveEventLogPartHandler.this.writeErrorLog(buf, off, len);
            }
        });
        this.eventBroker.subscribe("KATALON_STUDIO/EVENT_LOG/CLEAR_LOG", new EventHandler(){

            public void handleEvent(Event event) {
                ActiveEventLogPartHandler.this.bufferredStrings.clear();
            }
        });
    }

    @PreDestroy
    public void onDestroy() {
        LogManager.getOutputLogger().setWriter(null);
        LogManager.getOutputLogger().setWriter(null);
    }

    private void writeLog(byte[] buf, int off, int len) {
        String string = new String(ArrayUtils.subarray((byte[])buf, (int)off, (int)len));
        this.bufferredStrings.add(new ColorString(string, false));
        this.truncateIfReachMaxSize();
    }

    private void truncateIfReachMaxSize() {
        if (this.bufferredStrings.size() > 1000) {
            ColorString[] bufferredStringAsArray = this.bufferredStrings.toArray(new ColorString[0]);
            bufferredStringAsArray = Arrays.copyOf(bufferredStringAsArray, 1000);
            this.bufferredStrings.clear();
            this.bufferredStrings.addAll(Arrays.asList(bufferredStringAsArray));
        }
    }

    private void writeErrorLog(byte[] buf, int off, int len) {
        String string = new String(ArrayUtils.subarray((byte[])buf, (int)off, (int)len));
        this.bufferredStrings.add(new ColorString(string, true));
        this.truncateIfReachMaxSize();
    }

    public static ActiveEventLogPartHandler getInstance() {
        return instance;
    }

    public List<ColorString> getBufferredStrings() {
        return new ArrayList<ColorString>(this.bufferredStrings);
    }

    public void clearBufferredStrings() {
        this.bufferredStrings.clear();
    }

    public static class ColorString {
        private final boolean isError;
        private final String string;

        public ColorString(String string, boolean isError) {
            this.string = string;
            this.isError = isError;
        }

        public boolean isError() {
            return this.isError;
        }

        public String getString() {
            return this.string;
        }
    }
}

