/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components;

import com.kms.katalon.composer.components.CHandledContributionItem;
import com.kms.katalon.processors.ToolbarProcessor;
import java.util.Arrays;
import java.util.List;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.CSSRenderingUtils;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;

public class CToolBarManagerRenderer
extends ToolBarManagerRenderer {
    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MToolBar) || !(parent instanceof Composite)) {
            return null;
        }
        MToolBar toolbarModel = (MToolBar)element;
        ToolBar newTB = this.createToolbar((MUIElement)toolbarModel, (Composite)parent);
        this.bindWidget(element, newTB);
        this.processContribution(toolbarModel, toolbarModel.getElementId());
        ToolBar renderedCtrl = newTB;
        MElementContainer parentElement = element.getParent();
        if (parentElement instanceof MTrimBar) {
            if (!element.getTags().contains("NoMove")) {
                element.getTags().add("Draggable");
            }
            this.setCSSInfo(element, newTB);
            boolean vertical = false;
            MTrimBar bar = (MTrimBar)parentElement;
            vertical = bar.getSide() == SideValue.LEFT || bar.getSide() == SideValue.RIGHT;
            IEclipseContext parentContext = this.getContextForParent(element);
            CSSRenderingUtils cssUtils = (CSSRenderingUtils)parentContext.get(CSSRenderingUtils.class);
            if (cssUtils != null) {
                MUIElement modelElement = (MUIElement)newTB.getData("modelElement");
                boolean draggable = modelElement != null && modelElement.getTags().contains("Draggable");
                renderedCtrl = cssUtils.frameMeIfPossible((Control)newTB, null, vertical, draggable);
            }
        }
        return renderedCtrl;
    }

    private ToolBar createToolbar(MUIElement element, Composite parent) {
        ToolBarManager manager;
        int orientation = this.getOrientation(element);
        int style = orientation | 0x40 | 0x800000;
        String elementId = element.getElementId();
        if (!Arrays.asList(ToolbarProcessor.TOOLBAR_IDS).contains(elementId)) {
            style |= 0x20000;
        }
        if ((manager = this.getManager((MToolBar)element)) == null) {
            manager = new ToolBarManager(style);
            IContributionManagerOverrides overrides = null;
            MElementContainer parentElement = element.getParent();
            if (parentElement == null) {
                parentElement = (MApplicationElement)((EObject)element).eContainer();
            }
            if (parentElement != null) {
                overrides = (IContributionManagerOverrides)parentElement.getTransientData().get(IContributionManagerOverrides.class.getName());
            }
            manager.setOverrides(overrides);
            this.linkModelToManager((MToolBar)element, manager);
        } else {
            ToolBar toolBar = manager.getControl();
            if (toolBar != null && !toolBar.isDisposed() && (toolBar.getStyle() & orientation) == 0) {
                toolBar.dispose();
            }
            manager.setStyle(style);
        }
        ToolBar btoolbar = manager.createControl(parent);
        btoolbar.setData((Object)manager);
        btoolbar.setData("modelElement", (Object)element);
        btoolbar.requestLayout();
        return btoolbar;
    }

    private int getOrientation(MUIElement element) {
        MTrimBar trimContainer;
        SideValue side;
        MElementContainer theParent = element.getParent();
        if (theParent instanceof MTrimBar && ((side = (trimContainer = (MTrimBar)theParent).getSide()).getValue() == 2 || side.getValue() == 3)) {
            return 512;
        }
        return 256;
    }

    public void processContents(MElementContainer<MUIElement> container) {
        if (container == null) {
            return;
        }
        String elementId = container.getElementId();
        if (!Arrays.asList(ToolbarProcessor.TOOLBAR_IDS).contains(elementId)) {
            super.processContents(container);
            return;
        }
        ToolBarManager toolbarManager = this.getManager((MToolBar)container);
        if (toolbarManager == null) {
            return;
        }
        List parts = container.getChildren();
        if (parts != null) {
            MUIElement[] plist = parts.toArray(new MUIElement[parts.size()]);
            int i = 0;
            while (i < plist.length) {
                this.modelProcessSwitch(toolbarManager, (MToolBarElement)plist[i]);
                ++i;
            }
        }
        toolbarManager.update(true);
        ToolBar toolbar = this.getToolbarFrom(container.getWidget());
        if (toolbar != null) {
            toolbar.pack(true);
            toolbar.getShell().layout(new Control[]{toolbar}, 4);
        }
    }

    private ToolBar getToolbarFrom(Object widget) {
        if (widget instanceof ToolBar) {
            return (ToolBar)widget;
        }
        if (widget instanceof Composite) {
            Composite intermediate = (Composite)widget;
            if (intermediate.isDisposed()) {
                return null;
            }
            Control[] controlArray = intermediate.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control.getData() instanceof ToolBarManager) {
                    return (ToolBar)control;
                }
                ++n2;
            }
        }
        return null;
    }

    private void modelProcessSwitch(ToolBarManager toolbarManager, MToolBarElement toolbarElement) {
        if (toolbarElement instanceof MHandledToolItem) {
            this.processHandledItem(toolbarManager, (MHandledToolItem)toolbarElement);
            return;
        }
        if (toolbarElement instanceof MToolBarSeparator) {
            this.processSeparator(toolbarManager, (MToolBarSeparator)toolbarElement);
        }
    }

    private void processSeparator(ToolBarManager toolbarManager, MToolBarSeparator toolbarSeparator) {
        IContributionItem contributionItem = this.getContribution((MToolBarElement)toolbarSeparator);
        if (contributionItem != null) {
            return;
        }
        toolbarSeparator.setRenderer((Object)this);
        AbstractGroupMarker marker = this.getGroupMaker(toolbarSeparator);
        if (marker != null) {
            this.addToManager(toolbarManager, (MToolBarElement)toolbarSeparator, (IContributionItem)marker);
            this.linkModelToContribution((MToolBarElement)toolbarSeparator, (IContributionItem)marker);
        }
    }

    private AbstractGroupMarker getGroupMaker(MToolBarSeparator toolbarSeparator) {
        if (toolbarSeparator.isVisible() && !toolbarSeparator.getTags().contains("org.eclipse.jface.action.GroupMarker.GroupMarker(String)")) {
            Separator marker = new Separator();
            marker.setId(toolbarSeparator.getElementId());
            return marker;
        }
        if (toolbarSeparator.getElementId() != null) {
            return new GroupMarker(toolbarSeparator.getElementId());
        }
        return null;
    }

    private void processHandledItem(ToolBarManager parentManager, MHandledToolItem handledToolItem) {
        IContributionItem contributionItem = this.getContribution((MToolBarElement)handledToolItem);
        if (contributionItem != null) {
            return;
        }
        handledToolItem.setRenderer((Object)this);
        IEclipseContext itemContext = this.getContext((MUIElement)handledToolItem);
        CHandledContributionItem cHandledContributionItem = (CHandledContributionItem)((Object)ContextInjectionFactory.make(CHandledContributionItem.class, (IEclipseContext)itemContext));
        cHandledContributionItem.setModel((MHandledItem)handledToolItem);
        cHandledContributionItem.setVisible(handledToolItem.isVisible());
        this.addToManager(parentManager, (MToolBarElement)handledToolItem, (IContributionItem)cHandledContributionItem);
        this.linkModelToContribution((MToolBarElement)handledToolItem, (IContributionItem)cHandledContributionItem);
    }

    private void addToManager(ToolBarManager toolbarManager, MToolBarElement toolbarElement, IContributionItem ccontributionItem) {
        MElementContainer parent = toolbarElement.getParent();
        if (parent == null) {
            toolbarManager.add(ccontributionItem);
            return;
        }
        int index = parent.getChildren().indexOf(toolbarElement);
        if (index > toolbarManager.getSize() || index == -1) {
            toolbarManager.add(ccontributionItem);
            return;
        }
        toolbarManager.insert(index, ccontributionItem);
    }
}

