/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.ServerAPICommunicationUtil;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.util.collections.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SignupSurveyDialog
extends AbstractDialog {
    private static final String[] USER_ROLE_OPTIONS = new String[]{"Project manager", "Automation test expert", "Automation tester", "Manual tester", "Software engineer", "Other"};
    private static final String[] DOWNLOAD_PURPOSE_OPTIONS = new String[]{"Tool research for my project", "Learn automation test", "Tool trial", "Other"};
    private List<String> signupAnwsers = new ArrayList<String>(2);
    private CCombo cbxFirstQuestion;
    private CCombo cbxSecondQuestion;

    public SignupSurveyDialog(Shell parentShell) {
        super(parentShell, false);
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout();
        glContainer.verticalSpacing = 15;
        container.setLayout((Layout)glContainer);
        Label lblQuestionMsg = new Label(container, 0);
        lblQuestionMsg.setText(MessageConstants.SignupSurveyDialog_LBL_SURVEY_HEADLINE);
        lblQuestionMsg.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        Composite questionComposite = new Composite(container, 0);
        questionComposite.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        questionComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblFirstQuestion = new Label(questionComposite, 0);
        lblFirstQuestion.setText(MessageConstants.SignupSurveyDialog_LBL_QUESTION_FOR_USER_ROLE);
        lblFirstQuestion.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cbxFirstQuestion = new CCombo(questionComposite, 2060);
        GridData gdCombo = new GridData(4, 0x1000000, true, false);
        gdCombo.heightHint = 22;
        this.cbxFirstQuestion.setLayoutData((Object)gdCombo);
        this.cbxFirstQuestion.setItems(USER_ROLE_OPTIONS);
        this.cbxFirstQuestion.setText(MessageConstants.SignupSurveyDialog_CBX_DEFAULT_OPTION);
        Label lblSecondQuestion = new Label(questionComposite, 0);
        lblSecondQuestion.setText(MessageConstants.SignupSurveyDialog_LBL_QUESTION_FOR_DOWNLOAD_PURPOSE);
        lblSecondQuestion.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cbxSecondQuestion = new CCombo(questionComposite, 2060);
        this.cbxSecondQuestion.setLayoutData((Object)gdCombo);
        this.cbxSecondQuestion.setItems(DOWNLOAD_PURPOSE_OPTIONS);
        this.cbxSecondQuestion.setText(MessageConstants.SignupSurveyDialog_CBX_DEFAULT_OPTION);
        return container;
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        buttonBar.setLayout((Layout)new GridLayout());
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, MessageConstants.SignupSurveyDialog_BTN_EXPLORE_KATALON, true);
    }

    public String getDialogTitle() {
        return MessageConstants.SignupSurveyDialog_DIA_TITLE;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point(Math.max(500, initialSize.x), initialSize.y);
    }

    public List<String> getSignupAnwser() {
        return this.signupAnwsers;
    }

    protected void okPressed() {
        this.sendSignupAnwsers();
        super.okPressed();
    }

    public String getUrlEncodedSignupAnwser(String title, String role) throws UnsupportedEncodingException {
        List<Pair> formDataInfo = Arrays.asList(Pair.of((Object)"email", (Object)ApplicationInfo.getAppProperty((String)"email")), Pair.of((Object)"event", (Object)"Katalon Studio Download Survey Submitted"), Pair.of((Object)"properties[title]", (Object)title), Pair.of((Object)"properties[downloadPurpose]", (Object)role));
        StringBuilder urlEncodedBuilder = new StringBuilder();
        String charset = "utf-8";
        for (Pair p : formDataInfo) {
            if (urlEncodedBuilder.length() > 0) {
                urlEncodedBuilder.append("&");
            }
            urlEncodedBuilder.append(String.format("%s=%s", URLEncoder.encode((String)p.getLeft(), charset), URLEncoder.encode((String)p.getRight(), charset)));
        }
        return urlEncodedBuilder.toString();
    }

    private void sendSignupAnwsers() {
        String role;
        String title = this.cbxFirstQuestion.getSelectionIndex() >= 0 ? this.cbxFirstQuestion.getText() : "";
        String string = role = this.cbxSecondQuestion.getSelectionIndex() >= 0 ? this.cbxSecondQuestion.getText() : "";
        if (StringUtils.isEmpty((CharSequence)title) && StringUtils.isEmpty((CharSequence)role)) {
            return;
        }
        try {
            String data = this.getUrlEncodedSignupAnwser(title, role);
            Executors.newSingleThreadExecutor().submit(() -> {
                ServerAPICommunicationUtil.invokeFormEncoded((String)(String.valueOf(ServerAPICommunicationUtil.getAPIUrl()) + "/user/event"), (String)"POST", (String)data);
                return null;
            });
        }
        catch (UnsupportedEncodingException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

