/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.kms.katalon.activation.dialog.ProxyConfigurationDialog;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.RequestException;
import com.kms.katalon.application.utils.ServerAPICommunicationUtil;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SignupDialog
extends AbstractDialog {
    public static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);
    public static final int REQUEST_ACTIVATION_CODE = 1000;
    public static final int REQUEST_OFFLINE_CODE = 1002;
    private Text txtUsername;
    private Text txtEmail;
    private Text txtPassword;
    private Label lblProgressMessage;
    private AuthenticationInfo authenticationInfo;
    private Link lnkSwitchToActiveDialog;
    private Link lnkConfigProxy;
    private Link lnkOfflineActivation;

    public SignupDialog(Shell parentShell) {
        super(parentShell, false);
    }

    public boolean validateInput() {
        return this.validateUsername() && this.validateEmail() && this.validatePassword();
    }

    private boolean validateUsername() {
        return !this.txtUsername.getText().isEmpty();
    }

    private boolean validateEmail() {
        return VALID_EMAIL_ADDRESS_REGEX.matcher(this.txtEmail.getText()).find();
    }

    private boolean validatePassword() {
        return this.txtPassword.getText().length() >= 8;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void registerControlModifyListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SignupDialog.this.getButton(0).setEnabled(SignupDialog.this.validateInput());
            }
        };
        this.txtUsername.addModifyListener(modifyListener);
        this.txtEmail.addModifyListener(modifyListener);
        this.txtPassword.addModifyListener(modifyListener);
        this.lnkSwitchToActiveDialog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SignupDialog.this.setReturnCode(1000);
                SignupDialog.this.close();
            }
        });
        this.lnkConfigProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new ProxyConfigurationDialog(SignupDialog.this.getShell()).open();
            }
        });
        this.lnkOfflineActivation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SignupDialog.this.setReturnCode(1002);
                SignupDialog.this.close();
            }
        });
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        Composite contentComposite = new Composite(container, 0);
        GridLayout glContent = new GridLayout(2, false);
        glContent.verticalSpacing = 10;
        contentComposite.setLayout((Layout)glContent);
        Label lblUsername = new Label(contentComposite, 0);
        lblUsername.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblUsername.setText(MessageConstants.SignupDialog_LBL_FULL_NAME);
        this.txtUsername = new Text(contentComposite, 2048);
        GridData gdText = new GridData(4, 0x1000000, true, false);
        gdText.heightHint = 22;
        this.txtUsername.setLayoutData((Object)gdText);
        Label lblEmail = new Label(contentComposite, 0);
        GridData gdEmail = new GridData(16384, 128, false, false);
        gdEmail.verticalIndent = 5;
        lblEmail.setLayoutData((Object)gdEmail);
        lblEmail.setText(StringConstants.EMAIL);
        Composite txtEmailComposite = new Composite(contentComposite, 0);
        txtEmailComposite.setLayoutData((Object)new GridData(768));
        GridLayout glTxtComposite = new GridLayout();
        glTxtComposite.marginHeight = 0;
        glTxtComposite.marginWidth = 0;
        txtEmailComposite.setLayout((Layout)glTxtComposite);
        this.txtEmail = new Text(txtEmailComposite, 2048);
        this.txtEmail.setLayoutData((Object)gdText);
        Label lblEmailNotification = new Label(txtEmailComposite, 0);
        lblEmailNotification.setText(MessageConstants.SignupDialog_LBL_EMAIL_HINT);
        lblEmailNotification.setLayoutData((Object)new GridData(4, 128, false, false));
        lblEmailNotification.setForeground(ColorUtil.getHintForegroundColor());
        Label lblPassword = new Label(contentComposite, 0);
        GridData gdPassword = new GridData(16384, 128, false, false);
        gdPassword.verticalIndent = 5;
        lblPassword.setLayoutData((Object)gdPassword);
        lblPassword.setText(StringConstants.PASSSWORD_TITLE);
        Composite txtPasswordComposite = new Composite(contentComposite, 0);
        txtPasswordComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        GridLayout glPasswordComposite = new GridLayout();
        glPasswordComposite.marginHeight = 0;
        glPasswordComposite.marginWidth = 0;
        txtPasswordComposite.setLayout((Layout)glPasswordComposite);
        this.txtPassword = new Text(txtPasswordComposite, 0x400800);
        this.txtPassword.setLayoutData((Object)gdText);
        Label lblPasswordNotification = new Label(txtPasswordComposite, 0);
        lblPasswordNotification.setText(MessageConstants.SignupDialog_LBL_PASSWORD_HINT);
        lblPasswordNotification.setForeground(ColorUtil.getHintForegroundColor());
        lblPasswordNotification.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.lblProgressMessage = new Label(contentComposite, 0);
        this.lblProgressMessage.setLayoutData((Object)new GridData(131072, 128, true, false, 2, 1));
        return container;
    }

    protected Control createButtonBar(Composite parent) {
        Composite bottomBar = new Composite(parent, 0);
        bottomBar.setLayoutData((Object)new GridData(768));
        GridLayout gdBottomBar = new GridLayout(2, false);
        gdBottomBar.marginWidth = 0;
        bottomBar.setLayout((Layout)gdBottomBar);
        Composite bottomLeftComposite = new Composite(bottomBar, 0);
        bottomLeftComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        bottomLeftComposite.setLayout((Layout)new GridLayout(6, false));
        Label lblAskForAccount = new Label(bottomLeftComposite, 0);
        lblAskForAccount.setText(MessageConstants.SignupDialog_LBL_ASK_FOR_ACCOUNT);
        this.lnkSwitchToActiveDialog = new Link(bottomLeftComposite, 0);
        this.lnkSwitchToActiveDialog.setText(String.format("<a>%s</a>", MessageConstants.SignupDialog_LNK_SIGN_IN));
        Label lblSeparator = new Label(bottomLeftComposite, 2);
        GridData gdSeparator = new GridData(0x1000000, 0x1000000, false, false);
        gdSeparator.heightHint = 22;
        lblSeparator.setLayoutData((Object)gdSeparator);
        this.lnkConfigProxy = new Link(bottomLeftComposite, 0);
        this.lnkConfigProxy.setText(MessageConstants.CONFIG_PROXY);
        this.lnkConfigProxy.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label label = new Label(bottomLeftComposite, 2);
        label.setLayoutData((Object)gdSeparator);
        this.lnkOfflineActivation = new Link(bottomLeftComposite, 0);
        this.lnkOfflineActivation.setText(String.format("<a>%s</a>", MessageConstants.SignupDialog_LNK_OFFLINE_ACTIVATION));
        this.lnkOfflineActivation.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        Composite bottomRightComposite = new Composite(bottomBar, 0);
        bottomRightComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        bottomRightComposite.setLayout((Layout)gridLayout);
        this.createButtonsForButtonBar(bottomRightComposite);
        return bottomBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, MessageConstants.SignupDialog_BTN_SIGN_UP, true);
    }

    protected void setInput() {
        this.getButton(0).setEnabled(this.validateInput());
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point(Math.max(500, initialSize.x), initialSize.y);
    }

    public String getDialogTitle() {
        return MessageConstants.SignupDialog_DIA_TITLE;
    }

    protected void okPressed() {
        this.getButton(0).setEnabled(false);
        this.authenticationInfo = new AuthenticationInfo(this.txtUsername.getText(), this.txtEmail.getText(), this.txtPassword.getText());
        Thread thread = new Thread(() -> {
            try {
                this.createAccount(this.authenticationInfo);
                UISynchronizeService.syncExec(() -> SignupDialog.super.okPressed());
            }
            catch (UnknownHostException unknownHostException) {
                UISynchronizeService.syncExec(() -> {
                    this.setProgressMessage(MessageConstants.SignupDialog_MSG_NETWORK_ERROR, true);
                    this.getButton(0).setEnabled(true);
                });
            }
            catch (ActivationErrorException | IOException | GeneralSecurityException e) {
                UISynchronizeService.syncExec(() -> {
                    this.setProgressMessage(e.getMessage(), true);
                    this.getButton(0).setEnabled(true);
                });
            }
            catch (RequestException requestException) {
                UISynchronizeService.syncExec(() -> {
                    this.setProgressMessage(MessageConstants.SignupDialog_MSG_SIGNUP_REQUEST_FAILED, true);
                    this.getButton(0).setEnabled(true);
                });
                try {
                    Program.launch((String)ServerAPICommunicationUtil.getSignupUrlWithActivationRedirectLink());
                }
                catch (UnsupportedEncodingException uee) {
                    LogUtil.logError((Throwable)uee);
                }
            }
        });
        thread.start();
    }

    private void setProgressMessage(String message, boolean isError) {
        this.lblProgressMessage.setText(message);
        if (isError) {
            this.lblProgressMessage.setForeground(ColorUtil.getTextErrorColor());
        } else {
            this.lblProgressMessage.setForeground(ColorUtil.getDefaultTextColor());
        }
        this.lblProgressMessage.getParent().layout();
    }

    private void setSyncMessage(String message, boolean isError) {
        UISynchronizeService.syncExec(() -> this.setProgressMessage(message, isError));
    }

    private void createAccount(AuthenticationInfo authenticationInfo) throws IOException, GeneralSecurityException, ActivationErrorException, RequestException {
        this.setSyncMessage(MessageConstants.SignupDialog_MSG_CREATING_NEW_ACCOUNT, false);
        String token = ServerAPICommunicationUtil.invokeFormEncoded((String)ServerAPICommunicationUtil.getSignupAPIUrl(), (String)"GET", (String)this.getUrlEncodedRequestTokenBody());
        String signupBody = this.getUrlEncodedSignupBody(token, authenticationInfo);
        String signupResponse = ServerAPICommunicationUtil.invokeFormEncoded((String)ServerAPICommunicationUtil.getSignupAPIUrl(), (String)"POST", (String)signupBody);
        Gson gson = new GsonBuilder().registerTypeAdapter(SignupResponseBody.class, (Object)new SignupResponseBodyJsonDeserializer()).create();
        SignupResponseBody signupResponseBody = (SignupResponseBody)gson.fromJson(signupResponse, SignupResponseBody.class);
        if (signupResponseBody.getError()) {
            throw new ActivationErrorException(signupResponseBody.getMessage());
        }
        this.setSyncMessage(MessageConstants.SignupDialog_MSG_ACTIVATING_NEW_ACCOUNT, false);
        StringBuilder errorMessageBuilder = new StringBuilder();
        ActivationInfoCollector.activate((String)authenticationInfo.getEmail(), (String)authenticationInfo.getPassword(), (StringBuilder)errorMessageBuilder);
        if (errorMessageBuilder.length() > 0) {
            throw new ActivationErrorException(errorMessageBuilder.toString());
        }
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public String getUrlEncodedRequestTokenBody() throws UnsupportedEncodingException {
        StringBuilder urlEncodedBuilder = new StringBuilder();
        urlEncodedBuilder.append("action=" + URLEncoder.encode("katalon_token_register", "utf-8"));
        return urlEncodedBuilder.toString();
    }

    public String getUrlEncodedSignupBody(String token, AuthenticationInfo authenticationInfo) throws UnsupportedEncodingException {
        StringBuilder urlEncodedBuilder = new StringBuilder();
        urlEncodedBuilder.append("user_email=" + URLEncoder.encode(authenticationInfo.getEmail(), "utf-8"));
        urlEncodedBuilder.append("&user_pass=" + URLEncoder.encode(authenticationInfo.getPassword(), "utf-8"));
        urlEncodedBuilder.append("&user_login=" + URLEncoder.encode(authenticationInfo.getFullName(), "utf-8"));
        urlEncodedBuilder.append("&action=" + URLEncoder.encode("katalon_register", "utf-8"));
        urlEncodedBuilder.append("&register-security=" + URLEncoder.encode(token, "utf-8"));
        urlEncodedBuilder.append("&_wp_http_referrer=" + URLEncoder.encode("/sign-up/", "utf-8"));
        urlEncodedBuilder.append("&user_agreement=" + URLEncoder.encode("on", "utf-8"));
        return urlEncodedBuilder.toString();
    }

    private static class ActivationErrorException
    extends Exception {
        private static final long serialVersionUID = -3281802999345073175L;

        public ActivationErrorException(String message) {
            super(message);
        }
    }

    public static class AuthenticationInfo {
        private final String fullName;
        private final String email;
        private final String password;

        public AuthenticationInfo(String fullName, String email, String password) {
            this.fullName = fullName;
            this.email = email;
            this.password = password;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getEmail() {
            return this.email;
        }

        public String getPassword() {
            return this.password;
        }
    }

    public static class DataOptions {
        private String link;

        public String getLink() {
            return this.link;
        }
    }

    public static class SignupResponseBody {
        private boolean error;
        private String message;
        @SerializedName(value="data_options")
        private DataOptions dataOptions;

        public void setError(boolean error) {
            this.error = error;
        }

        public boolean getError() {
            return this.error;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public DataOptions getDataOptions() {
            return this.dataOptions;
        }

        public void setDataOptions(DataOptions dataOptions) {
            this.dataOptions = dataOptions;
        }
    }

    public static class SignupResponseBodyJsonDeserializer
    implements JsonDeserializer<SignupResponseBody> {
        public SignupResponseBody deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonElement jsDataOptions;
            if (!(jsonElement instanceof JsonObject)) {
                return null;
            }
            SignupResponseBody signupResponse = new SignupResponseBody();
            JsonObject jsObject = (JsonObject)jsonElement;
            if (jsObject.has("error")) {
                signupResponse.setError(jsObject.get("error").getAsBoolean());
            }
            if (jsObject.has("message")) {
                signupResponse.setMessage(jsObject.get("message").getAsString());
            }
            if (jsObject.has("data_options") && (jsDataOptions = jsObject.get("data_options")).isJsonObject()) {
                signupResponse.setDataOptions((DataOptions)JsonUtil.fromJson((String)jsDataOptions.toString(), DataOptions.class));
            }
            return signupResponse;
        }
    }
}

