/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.utils.ApplicationProxyUtil;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.core.network.ProxyInformation;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProxyConfigurationDialog
extends TitleAreaDialog {
    private Text txtAddress;
    private Text txtPort;
    private Text txtUsername;
    private Text txtPass;
    private CCombo cboProxyOption;
    private CCombo cboProxyServerType;
    private Button chkRequireAuthentication;
    private static final int MAX_PORT_VALUE = 65535;

    public ProxyConfigurationDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite innerComposite = new Composite(area, 0);
        innerComposite.setLayoutData((Object)new GridData(1808));
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.verticalSpacing = 10;
        glContainer.marginTop = 20;
        glContainer.marginLeft = 10;
        glContainer.marginRight = 10;
        glContainer.marginBottom = 30;
        innerComposite.setLayout((Layout)glContainer);
        Label lblProxyOption = new Label(innerComposite, 0);
        lblProxyOption.setText(MessageConstants.LBL_PROXY_OPTION);
        this.cboProxyOption = new CCombo(innerComposite, 0x800808);
        GridData gdComboProxyOption = new GridData(4, 4, true, false, 1, 1);
        this.cboProxyOption.setBackground(Display.getCurrent().getSystemColor(1));
        gdComboProxyOption.widthHint = 320;
        gdComboProxyOption.heightHint = 18;
        this.cboProxyOption.setLayoutData((Object)gdComboProxyOption);
        this.cboProxyOption.setItems(new String[]{ApplicationMessageConstants.NO_PROXY, ApplicationMessageConstants.USE_SYSTEM_PROXY, ApplicationMessageConstants.MANUAL_CONFIG_PROXY});
        this.cboProxyOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == ProxyConfigurationDialog.this.cboProxyOption) {
                    String selectText = ProxyConfigurationDialog.this.cboProxyOption.getText();
                    if (ApplicationMessageConstants.NO_PROXY.equals(selectText)) {
                        ProxyConfigurationDialog.this.selectNoProxyOption();
                    } else if (ApplicationMessageConstants.USE_SYSTEM_PROXY.equals(selectText)) {
                        ProxyConfigurationDialog.this.selectSystemProxyOption();
                    } else {
                        ProxyConfigurationDialog.this.selectManualConfigProxyOption();
                    }
                }
            }
        });
        Label lblNewLabel = new Label(innerComposite, 0);
        lblNewLabel.setText(MessageConstants.LBL_PROXY_SERVER_TYPE);
        this.cboProxyServerType = new CCombo(innerComposite, 2056);
        GridData gdComboProxyServerType = new GridData(4, 4, true, false, 1, 1);
        gdComboProxyServerType.widthHint = 319;
        gdComboProxyServerType.heightHint = 18;
        this.cboProxyServerType.setLayoutData((Object)gdComboProxyServerType);
        this.cboProxyServerType.setBackground(Display.getCurrent().getSystemColor(1));
        this.cboProxyServerType.setItems(new String[]{"HTTP", "HTTPS", "SOCKS"});
        Label lblAddress = new Label(innerComposite, 0);
        lblAddress.setText(MessageConstants.LBL_ADDRESS);
        Composite composite = new Composite(innerComposite, 0);
        GridLayout glComposite = new GridLayout(3, false);
        glComposite.marginWidth = 0;
        glComposite.marginHeight = 0;
        glComposite.horizontalSpacing = 0;
        glComposite.verticalSpacing = 0;
        composite.setLayout((Layout)glComposite);
        GridData gdComposite = new GridData(4, 4, false, false, 1, 1);
        gdComposite.widthHint = 314;
        gdComposite.heightHint = 22;
        composite.setLayoutData((Object)gdComposite);
        this.txtAddress = new Text(composite, 2048);
        GridData gdAddress = new GridData(16384, 4, true, false, 1, 1);
        gdAddress.widthHint = 206;
        this.txtAddress.setLayoutData((Object)gdAddress);
        Label lblPort = new Label(composite, 0);
        GridData gdLblPort = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblPort.widthHint = 32;
        lblPort.setLayoutData((Object)gdLblPort);
        lblPort.setText(MessageConstants.LBL_PORT);
        this.txtPort = new Text(composite, 2048);
        GridData gd_txtPort = new GridData(4, 4, true, false, 1, 1);
        gd_txtPort.widthHint = 68;
        this.txtPort.setLayoutData((Object)gd_txtPort);
        this.txtPort.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String text = ProxyConfigurationDialog.this.txtPort.getText();
                String newText = String.valueOf(text.substring(0, e.start)) + e.text + text.substring(e.end);
                if (StringUtils.isEmpty((CharSequence)newText)) {
                    e.doit = true;
                    return;
                }
                try {
                    int val = Integer.parseInt(newText);
                    e.doit = val >= 0 && val <= 65535;
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        });
        this.chkRequireAuthentication = new Button(innerComposite, 32);
        this.chkRequireAuthentication.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.chkRequireAuthentication.setText(MessageConstants.CHK_TEXT_PROXY_SERVER_TYPE_REQUIRE_AUTHENTICATION);
        this.chkRequireAuthentication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = ProxyConfigurationDialog.this.chkRequireAuthentication.getSelection();
                ProxyConfigurationDialog.this.txtUsername.setEnabled(selection);
                ProxyConfigurationDialog.this.txtUsername.setText(selection ? ProxyConfigurationDialog.this.txtUsername.getText() : "");
                ProxyConfigurationDialog.this.txtPass.setEnabled(selection);
                ProxyConfigurationDialog.this.txtPass.setText(selection ? ProxyConfigurationDialog.this.txtPass.getText() : "");
            }
        });
        Label lblUsername = new Label(innerComposite, 0);
        lblUsername.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUsername.setText(MessageConstants.LBL_USERNAME);
        this.txtUsername = new Text(innerComposite, 2048);
        GridData gdUsername = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdUsername.widthHint = 207;
        this.txtUsername.setLayoutData((Object)gdUsername);
        Label lblPassword = new Label(innerComposite, 0);
        lblPassword.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPassword.setText(MessageConstants.LBL_PASSWORD);
        this.txtPass = new Text(innerComposite, 0x400800);
        GridData gdPass = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdPass.widthHint = 207;
        this.txtPass.setLayoutData((Object)gdPass);
        this.setTitle(MessageConstants.TITLE_DLG_PROXY_SETTING);
        this.setMessage(MessageConstants.MSG_DLG_PROXY_SETTING, 1);
        this.initialize();
        return area;
    }

    private void selectNoProxyOption() {
        this.cboProxyServerType.deselectAll();
        this.cboProxyServerType.setEnabled(false);
        this.txtPort.setText("");
        this.txtPort.setEnabled(false);
        this.txtAddress.setText("");
        this.txtAddress.setEnabled(false);
        this.chkRequireAuthentication.setEnabled(false);
        this.chkRequireAuthentication.setSelection(false);
        this.txtUsername.setEnabled(false);
        this.txtUsername.setText("");
        this.txtPass.setEnabled(false);
        this.txtPass.setText("");
    }

    private void selectSystemProxyOption() {
        this.selectNoProxyOption();
    }

    private void selectManualConfigProxyOption() {
        this.cboProxyServerType.setEnabled(true);
        this.txtPort.setEnabled(true);
        this.txtAddress.setEnabled(true);
        this.chkRequireAuthentication.setEnabled(true);
        this.cboProxyServerType.setText("HTTP");
        if (!this.chkRequireAuthentication.getSelection()) {
            this.txtUsername.setEnabled(false);
            this.txtUsername.setText("");
            this.txtPass.setEnabled(false);
            this.txtPass.setText("");
        }
    }

    private void initialize() {
        ProxyInformation proxyInfo = ApplicationProxyUtil.getProxyInformation();
        this.cboProxyOption.setText(proxyInfo.getProxyOption());
        this.cboProxyServerType.setText(proxyInfo.getProxyServerType());
        this.txtAddress.setText(proxyInfo.getProxyServerAddress());
        this.txtPort.setText(proxyInfo.getProxyServerPort() >= 0 ? String.valueOf(proxyInfo.getProxyServerPort()) : "");
        this.txtUsername.setText(proxyInfo.getUsername());
        this.txtPass.setText(proxyInfo.getPassword());
        String proxyOption = this.cboProxyOption.getText();
        if (ApplicationMessageConstants.NO_PROXY.equals(proxyOption)) {
            this.selectNoProxyOption();
        } else if (ApplicationMessageConstants.USE_SYSTEM_PROXY.equals(proxyOption)) {
            this.selectSystemProxyOption();
        } else {
            this.chkRequireAuthentication.setEnabled(true);
            if (StringUtils.isNotEmpty((CharSequence)this.txtUsername.getText()) && StringUtils.isNotEmpty((CharSequence)this.txtPass.getText())) {
                this.chkRequireAuthentication.setSelection(true);
            }
            boolean requiredAuthentication = this.chkRequireAuthentication.getSelection();
            this.txtUsername.setEnabled(requiredAuthentication);
            this.txtPass.setEnabled(requiredAuthentication);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MessageConstants.TITLE_WINDOW_DLG_PROXY_SETTING);
    }

    protected void okPressed() {
        ProxyInformation proxyInfo = new ProxyInformation();
        proxyInfo.setProxyOption(this.cboProxyOption.getText());
        proxyInfo.setProxyServerType(this.cboProxyServerType.getText());
        proxyInfo.setProxyServerAddress(this.txtAddress.getText());
        proxyInfo.setProxyServerPort(this.txtPort.getText());
        proxyInfo.setUsername(this.txtUsername.getText());
        proxyInfo.setPassword(this.txtPass.getText());
        ApplicationProxyUtil.saveProxyInformation((ProxyInformation)proxyInfo);
        super.okPressed();
    }
}

