/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.util.ComposerActivationInfoCollector;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActivationOfflineDialogV2
extends AbstractDialog {
    public static final int REQUEST_ONLINE_CODE = 1001;
    public static final int REQUEST_SIGNUP_CODE = 1002;
    private Label lblRequestCodeDetail;
    private Button btnCopyToClipboard;
    private Text txtActivationCode;
    private Label lblProgressMessage;
    private Link lnkOnlineRequest;
    private Link lnkActivationCode;
    private Button btnActivate;
    private boolean navigateFromSignUp;

    public ActivationOfflineDialogV2(Shell parentShell, boolean navigateFromSignUp) {
        super(parentShell, false);
        this.navigateFromSignUp = navigateFromSignUp;
    }

    protected void registerControlModifyListeners() {
        this.txtActivationCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ActivationOfflineDialogV2.this.btnActivate.setEnabled(ActivationOfflineDialogV2.this.validateInput());
            }
        });
        this.btnCopyToClipboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Clipboard cb = new Clipboard(ActivationOfflineDialogV2.this.getShell().getDisplay());
                cb.setContents(new Object[]{ActivationOfflineDialogV2.this.lblRequestCodeDetail.getText()}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
        this.lnkOnlineRequest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ActivationOfflineDialogV2.this.navigateFromSignUp) {
                    ActivationOfflineDialogV2.this.setReturnCode(1002);
                } else {
                    ActivationOfflineDialogV2.this.setReturnCode(1001);
                }
                ActivationOfflineDialogV2.this.close();
            }
        });
        this.lnkActivationCode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)MessageConstants.ActivationOfflineDialogV2_ACTIVATION_URL);
            }
        });
        this.btnActivate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivationOfflineDialogV2.this.btnActivate.setEnabled(false);
                ActivationOfflineDialogV2.this.setProgressMessage(MessageConstants.ActivationDialogV2_MSG_ACTIVATING, false);
                StringBuilder errorMessage = new StringBuilder();
                boolean result = ActivationInfoCollector.activate((String)ActivationOfflineDialogV2.this.txtActivationCode.getText().trim(), (StringBuilder)errorMessage);
                if (result) {
                    ActivationOfflineDialogV2.this.setReturnCode(0);
                    ActivationOfflineDialogV2.this.close();
                } else {
                    ActivationOfflineDialogV2.this.setProgressMessage(errorMessage.toString(), true);
                    ActivationOfflineDialogV2.this.btnActivate.setEnabled(true);
                }
            }
        });
    }

    protected void setInput() {
        this.btnActivate.setEnabled(this.validateInput());
        this.lblRequestCodeDetail.setText(ComposerActivationInfoCollector.genRequestActivationInfo());
        this.lblRequestCodeDetail.getParent().layout();
    }

    private boolean validateInput() {
        return this.txtActivationCode.getText().length() > 0;
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout();
        glContainer.verticalSpacing = 15;
        container.setLayout((Layout)glContainer);
        Composite requestCodeComposite = new Composite(container, 0);
        requestCodeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        requestCodeComposite.setLayout((Layout)new GridLayout(3, false));
        Label lblRequestCode = new Label(requestCodeComposite, 0);
        lblRequestCode.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblRequestCode.setText(MessageConstants.ACTIVATION_REQUEST_CODE);
        this.lblRequestCodeDetail = new Label(requestCodeComposite, 0);
        this.lblRequestCodeDetail.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.lblRequestCodeDetail.setForeground(ColorUtil.getTextLinkColor());
        this.increateFontSize(this.lblRequestCodeDetail, 2);
        this.btnCopyToClipboard = new Button(requestCodeComposite, 8);
        this.btnCopyToClipboard.setText(MessageConstants.BTN_COPY_TITLE);
        Composite messageComposite = new Composite(container, 0);
        GridLayout glMessageComposite = new GridLayout();
        glMessageComposite.verticalSpacing = 10;
        messageComposite.setLayout((Layout)glMessageComposite);
        messageComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.lnkActivationCode = new Link(messageComposite, 64);
        this.lnkActivationCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.lnkActivationCode.setText(MessageConstants.ActivationOfflineDialogV2_LBL_ACTIVATION_URL);
        Composite activationCodeComposite = new Composite(messageComposite, 0);
        activationCodeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout glActivationCode = new GridLayout(2, false);
        glActivationCode.marginHeight = 0;
        glActivationCode.marginWidth = 0;
        activationCodeComposite.setLayout((Layout)glActivationCode);
        Label lblActivationCode = new Label(activationCodeComposite, 0);
        lblActivationCode.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblActivationCode.setText(MessageConstants.ActivationOfflineDialogV2_LBL_ACTIVATION_CODE);
        this.txtActivationCode = new Text(activationCodeComposite, 2048);
        GridData gdActivationCode = new GridData(4, 0x1000000, true, false);
        gdActivationCode.heightHint = 22;
        this.txtActivationCode.setLayoutData((Object)gdActivationCode);
        this.lblProgressMessage = new Label(messageComposite, 0);
        this.lblProgressMessage.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        return container;
    }

    protected Control createButtonBar(Composite parent) {
        Composite bottomBar = new Composite(parent, 0);
        bottomBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        bottomBar.setLayout((Layout)new GridLayout(2, false));
        Composite bottomLeftComposite = new Composite(bottomBar, 0);
        bottomLeftComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        bottomLeftComposite.setLayout((Layout)new GridLayout());
        this.lnkOnlineRequest = new Link(bottomLeftComposite, 0);
        this.lnkOnlineRequest.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.lnkOnlineRequest.setText(String.format("<a>%s</a>", MessageConstants.ActivationOfflineDialogV2_LNK_BACK));
        Composite bottomRightComposite = new Composite(bottomBar, 0);
        bottomRightComposite.setLayout((Layout)new GridLayout());
        bottomRightComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.btnActivate = new Button(bottomRightComposite, 8);
        this.btnActivate.setText(MessageConstants.BTN_ACTIVATE_TITLE);
        this.getShell().setDefaultButton(this.btnActivate);
        return bottomBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    private void setProgressMessage(String message, boolean isError) {
        this.lblProgressMessage.setText(message);
        if (isError) {
            this.lblProgressMessage.setForeground(ColorUtil.getTextErrorColor());
        } else {
            this.lblProgressMessage.setForeground(ColorUtil.getDefaultTextColor());
        }
        this.lblProgressMessage.getParent().layout();
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point(Math.max(500, initialSize.x), initialSize.y);
    }

    public String getDialogTitle() {
        return MessageConstants.DIALOG_OFFLINE_TITLE;
    }

    private void increateFontSize(Label label, int sizeIncreased) {
        FontData fontData = label.getFont().getFontData()[0];
        fontData.setHeight(fontData.getHeight() + sizeIncreased);
        label.setFont(new Font((Device)label.getDisplay(), fontData));
    }
}

