/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.ComposerActivationInfoCollector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActivationOfflineDialog
extends Dialog {
    private Button btnActivate;
    private Text txtActivationRequest;
    private Button btnCopyToClipboard;
    private Text txtActivationCode;
    private Label lblError;

    public ActivationOfflineDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout glContainer = new GridLayout();
        glContainer.marginWidth = 0;
        glContainer.marginHeight = 0;
        container.setLayout((Layout)glContainer);
        Composite body = new Composite(container, 0);
        GridLayout glBody = new GridLayout(2, false);
        glBody.marginWidth = 10;
        glBody.marginHeight = 10;
        body.setLayout((Layout)glBody);
        Link lblMessage = new Link(body, 64);
        lblMessage.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        lblMessage.setText(StringConstants.LBL_ACTIVATE_OFFLINE_HELP);
        lblMessage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Program.launch((String)StringConstants.LINK_ACTIVATION_LINK);
                }
                catch (Exception ex) {
                    LogUtil.logError((Throwable)ex);
                }
            }
        });
        Label lblRequestCode = new Label(body, 0);
        lblRequestCode.setText(StringConstants.ACTIVATION_REQUEST_CODE);
        lblRequestCode.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.txtActivationRequest = new Text(body, 2056);
        GridData gdActivationRequest = new GridData(4, 0x1000000, true, false, 1, 1);
        gdActivationRequest.heightHint = 18;
        this.txtActivationRequest.setLayoutData((Object)gdActivationRequest);
        this.txtActivationRequest.setText(ComposerActivationInfoCollector.genRequestActivationInfo());
        this.txtActivationRequest.setBackground(ColorUtil.getDisabledItemBackgroundColor());
        new Label(body, 0);
        this.btnCopyToClipboard = new Button(body, 8);
        this.btnCopyToClipboard.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.btnCopyToClipboard.setText(StringConstants.BTN_COPY_TITLE);
        this.btnCopyToClipboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Clipboard cb = new Clipboard(Display.getCurrent());
                cb.setContents(new Object[]{ActivationOfflineDialog.this.txtActivationRequest.getText()}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
        Label lblNewLabelOne = new Label(body, 0);
        lblNewLabelOne.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblNewLabelOne.setText(StringConstants.LBL_ACTIVATE_CODE);
        this.txtActivationCode = new Text(body, 2048);
        GridData gdActivationCode = new GridData(4, 0x1000000, true, false, 1, 1);
        gdActivationCode.heightHint = 18;
        this.txtActivationCode.setLayoutData((Object)gdActivationCode);
        this.txtActivationCode.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ActivationOfflineDialog.this.enableActivateButton();
            }
        });
        new Label(body, 0);
        this.lblError = new Label(body, 0);
        this.lblError.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblError.setForeground(Display.getCurrent().getSystemColor(3));
        Label spacer = new Label(container, 258);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return container;
    }

    private boolean isFullFillActivateInfo() {
        return this.txtActivationCode.getText().trim().length() > 0;
    }

    protected void processActivate() {
        if (this.isFullFillActivateInfo()) {
            this.lblError.setForeground(Display.getCurrent().getSystemColor(2));
            this.lblError.setText(StringConstants.WAITTING_MESSAGE);
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    StringBuilder errorMessage = new StringBuilder();
                    boolean result = ActivationInfoCollector.activate((String)ActivationOfflineDialog.this.txtActivationCode.getText().trim(), (StringBuilder)errorMessage);
                    ActivationOfflineDialog.this.lblError.setForeground(Display.getCurrent().getSystemColor(3));
                    if (result) {
                        ActivationOfflineDialog.this.setReturnCode(0);
                        ActivationOfflineDialog.this.close();
                    } else {
                        ActivationOfflineDialog.this.lblError.setText(errorMessage.toString());
                    }
                }
            });
        }
    }

    private void enableActivateButton() {
        boolean enable = this.isFullFillActivateInfo();
        this.lblError.setText(this.isFullFillActivateInfo() ? "" : StringConstants.PROMT_ENTER_ACTIVATE_CODE);
        this.btnActivate.setEnabled(enable);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StringConstants.DIALOG_OFFLINE_TITLE);
        newShell.setImage(ImageConstants.KATALON_IMAGE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        this.btnActivate = this.createButton(parent, 0, StringConstants.BTN_ACTIVATE_TITLE, true);
        this.enableActivateButton();
    }

    protected void okPressed() {
        this.processActivate();
    }
}

