/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.activation.dialog.ProxyConfigurationDialog;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActivationDialogV2
extends AbstractDialog {
    public static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);
    public static final int REQUEST_SIGNUP_CODE = 1001;
    public static final int REQUEST_OFFLINE_CODE = 1002;
    private Text txtEmail;
    private Text txtPassword;
    private Label lblProgressMessage;
    private Link lnkSwitchToSignupDialog;
    private Button btnActivate;
    private Link lnkConfigProxy;
    private Link lnkOfflineActivation;
    private Link lnkForgotPassword;

    public ActivationDialogV2(Shell parentShell) {
        super(parentShell, false);
    }

    private boolean validateInput() {
        return this.validateEmail() && this.validatePassword();
    }

    protected void registerControlModifyListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ActivationDialogV2.this.btnActivate.setEnabled(ActivationDialogV2.this.validateInput());
            }
        };
        this.txtEmail.addModifyListener(modifyListener);
        this.txtPassword.addModifyListener(modifyListener);
        this.lnkSwitchToSignupDialog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivationDialogV2.this.setReturnCode(1001);
                ActivationDialogV2.this.close();
            }
        });
        this.lnkConfigProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new ProxyConfigurationDialog(ActivationDialogV2.this.getShell()).open();
            }
        });
        this.lnkForgotPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)StringConstants.FORGOT_PASS_LINK);
            }
        });
        this.lnkOfflineActivation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivationDialogV2.this.setReturnCode(1002);
                ActivationDialogV2.this.close();
            }
        });
        this.btnActivate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String username = ActivationDialogV2.this.txtEmail.getText();
                String password = ActivationDialogV2.this.txtPassword.getText();
                ActivationDialogV2.this.btnActivate.setEnabled(false);
                Executors.newFixedThreadPool(1).submit(() -> {
                    UISynchronizeService.syncExec(() -> ActivationDialogV2.this.setProgressMessage(MessageConstants.ActivationDialogV2_MSG_ACTIVATING, false));
                    StringBuilder errorMessage = new StringBuilder();
                    boolean result = ActivationInfoCollector.activate((String)username, (String)password, (StringBuilder)errorMessage);
                    UISynchronizeService.syncExec(() -> {
                        ActivationDialogV2.this.btnActivate.setEnabled(true);
                        if (result) {
                            ActivationDialogV2.this.setReturnCode(0);
                            ActivationDialogV2.this.close();
                        } else {
                            ActivationDialogV2.this.setProgressMessage(errorMessage.toString(), true);
                        }
                    });
                });
            }
        });
    }

    private void setProgressMessage(String message, boolean isError) {
        this.lblProgressMessage.setText(message);
        if (isError) {
            this.lblProgressMessage.setForeground(ColorUtil.getTextErrorColor());
        } else {
            this.lblProgressMessage.setForeground(ColorUtil.getDefaultTextColor());
        }
        this.lblProgressMessage.getParent().layout();
    }

    protected void setInput() {
        this.btnActivate.setEnabled(this.validateInput());
    }

    private boolean validateEmail() {
        return VALID_EMAIL_ADDRESS_REGEX.matcher(this.txtEmail.getText()).find();
    }

    private boolean validatePassword() {
        return this.txtPassword.getText().length() >= 8;
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        Composite contentComposite = new Composite(container, 0);
        GridLayout glContent = new GridLayout(2, false);
        glContent.verticalSpacing = 10;
        contentComposite.setLayout((Layout)glContent);
        GridData gdText = new GridData(4, 0x1000000, true, false);
        gdText.heightHint = 22;
        Label lblEmail = new Label(contentComposite, 0);
        GridData gdEmail = new GridData(16384, 0x1000000, false, false);
        lblEmail.setLayoutData((Object)gdEmail);
        lblEmail.setText(StringConstants.EMAIL);
        this.txtEmail = new Text(contentComposite, 2048);
        this.txtEmail.setLayoutData((Object)gdText);
        Label lblPassword = new Label(contentComposite, 0);
        GridData gdPassword = new GridData(16384, 0x1000000, false, false);
        lblPassword.setLayoutData((Object)gdPassword);
        lblPassword.setText(StringConstants.PASSSWORD_TITLE);
        this.txtPassword = new Text(contentComposite, 0x400800);
        this.txtPassword.setLayoutData((Object)gdText);
        this.lblProgressMessage = new Label(contentComposite, 0);
        this.lblProgressMessage.setLayoutData((Object)new GridData(131072, 128, true, false, 2, 1));
        return container;
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        GridLayout glButtonBar = new GridLayout(1, false);
        glButtonBar.marginWidth = 0;
        glButtonBar.verticalSpacing = 10;
        buttonBar.setLayout((Layout)glButtonBar);
        buttonBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite bottomBar = new Composite(buttonBar, 0);
        bottomBar.setLayoutData((Object)new GridData(768));
        GridLayout gdBottomBar = new GridLayout(2, false);
        gdBottomBar.marginWidth = 5;
        gdBottomBar.marginHeight = 0;
        bottomBar.setLayout((Layout)gdBottomBar);
        Composite bottomLeftComposite = new Composite(bottomBar, 0);
        bottomLeftComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        bottomLeftComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblAskForAccount = new Label(bottomLeftComposite, 0);
        lblAskForAccount.setText(MessageConstants.ActivationDialogV2_LBL_ASK_FOR_REGISTER);
        this.lnkSwitchToSignupDialog = new Link(bottomLeftComposite, 0);
        this.lnkSwitchToSignupDialog.setText(String.format("<a>%s</a>", MessageConstants.ActivationDialogV2_LNK_REGISTER));
        Composite bottomRightComposite = new Composite(bottomBar, 0);
        bottomRightComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        GridLayout gridLayout = glButtonBar;
        gridLayout.marginWidth = 0;
        bottomRightComposite.setLayout((Layout)gridLayout);
        this.btnActivate = new Button(bottomRightComposite, 8);
        this.btnActivate.setText(StringConstants.BTN_ACTIVATE_TITLE);
        this.getShell().setDefaultButton(this.btnActivate);
        Composite linkBar = new Composite(buttonBar, 0);
        linkBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        linkBar.setLayout((Layout)new GridLayout(5, false));
        this.lnkForgotPassword = new Link(linkBar, 0);
        this.lnkForgotPassword.setText(String.format("<a>%s</a>", MessageConstants.ActivationDialogV2_LNK_RESET_PASSWORD));
        this.lnkForgotPassword.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        Label label = new Label(linkBar, 2);
        GridData gdSeparator = new GridData(0x1000000, 0x1000000, false, false);
        gdSeparator.heightHint = 22;
        label.setLayoutData((Object)gdSeparator);
        this.lnkOfflineActivation = new Link(linkBar, 0);
        this.lnkOfflineActivation.setText(String.format("<a>%s</a>", MessageConstants.ActivationDialogV2_LNK_OFFLINE_ACTIVATION));
        this.lnkOfflineActivation.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        Label label2 = new Label(linkBar, 2);
        label2.setLayoutData((Object)gdSeparator);
        this.lnkConfigProxy = new Link(linkBar, 0);
        this.lnkConfigProxy.setText(MessageConstants.CONFIG_PROXY);
        this.lnkConfigProxy.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    public String getDialogTitle() {
        return MessageConstants.DIA_TITLE_KS_ACTIVATION;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point(Math.max(500, initialSize.x), initialSize.y);
    }
}

