/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.activation.dialog.ActivationOfflineDialog;
import com.kms.katalon.activation.dialog.ProxyConfigurationDialog;
import com.kms.katalon.activation.dialog.SignupDialog;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActivationDialog
extends Dialog {
    private Button btnActivate;
    private Button btnClear;
    private Text txtUserName;
    private Text txtPassword;
    private Label lblError;
    private boolean allowOfflineActivation = true;

    public ActivationDialog(Shell parentShell) {
        super(parentShell);
    }

    public boolean isAllowOfflineActivation() {
        return this.allowOfflineActivation;
    }

    public void setAllowOfflineActivation(boolean allowOfflineActivation) {
        this.allowOfflineActivation = allowOfflineActivation;
    }

    protected Control createDialogArea(Composite parent) {
        Label lblNewLabel;
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.marginRight = 10;
        glContainer.marginTop = 10;
        glContainer.marginLeft = 10;
        glContainer.marginWidth = 0;
        glContainer.marginHeight = 0;
        glContainer.horizontalSpacing = 0;
        glContainer.verticalSpacing = 0;
        container.setLayout((Layout)glContainer);
        Label lblUsername = new Label(container, 0);
        GridData gdLblUsername = new GridData(131072, 0x1000000, false, false, 1, 1);
        gdLblUsername.widthHint = 73;
        lblUsername.setLayoutData((Object)gdLblUsername);
        lblUsername.setText(StringConstants.USERNAME_TITLE);
        this.txtUserName = new Text(container, 2048);
        GridData gdTxtUserName = new GridData(4, 0x1000000, true, false, 1, 1);
        gdTxtUserName.heightHint = 22;
        this.txtUserName.setLayoutData((Object)gdTxtUserName);
        Composite compSeparate = new Composite(container, 0);
        GridData gdCompSeparate = new GridData(16384, 0x1000000, false, false, 2, 1);
        gdCompSeparate.heightHint = 5;
        compSeparate.setLayoutData((Object)gdCompSeparate);
        Label lblPassword = new Label(container, 0);
        lblPassword.setText(StringConstants.PASSSWORD_TITLE);
        this.txtPassword = new Text(container, 0x400800);
        GridData gdTxtPassword = new GridData(4, 1024, true, false, 1, 1);
        gdTxtPassword.heightHint = 22;
        this.txtPassword.setLayoutData((Object)gdTxtPassword);
        this.lblError = new Label(container, 0);
        this.lblError.setAlignment(0x1000000);
        GridData gdLblError = new GridData(4, 0x1000000, false, false, 2, 1);
        gdLblError.verticalIndent = 5;
        gdLblError.heightHint = 22;
        this.lblError.setLayoutData((Object)gdLblError);
        this.lblError.setForeground(Display.getCurrent().getSystemColor(3));
        Composite composite = new Composite(container, 0);
        GridData gdComposite = new GridData(4, 0x1000000, false, false, 2, 1);
        composite.setLayoutData((Object)gdComposite);
        composite.setLayout((Layout)new GridLayout(9, false));
        this.btnClear = new Button(composite, 0);
        GridData gdBtnClear = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdBtnClear.heightHint = 26;
        gdBtnClear.widthHint = 62;
        this.btnClear.setLayoutData((Object)gdBtnClear);
        this.btnClear.setText(StringConstants.BTN_CLEAR_TILE);
        this.btnActivate = new Button(composite, 0);
        GridData gdBtnActivate = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdBtnActivate.heightHint = 26;
        gdBtnActivate.widthHint = 72;
        this.btnActivate.setLayoutData((Object)gdBtnActivate);
        this.btnActivate.setText(StringConstants.BTN_ACTIVATE_TITLE);
        Link linkForgotPass = new Link(composite, 0);
        linkForgotPass.setText(StringConstants.LINK_LABEL_FORGOT_PASS_TEXT);
        Label lblVertialSeparate = new Label(composite, 0);
        lblVertialSeparate.setText(StringConstants.SEPARATE_LINK);
        Link linkRegister = new Link(composite, 0);
        linkRegister.setText(StringConstants.LINK_LABEL_REGISTER_TEXT);
        if (this.isAllowOfflineActivation()) {
            lblNewLabel = new Label(composite, 0);
            lblNewLabel.setText(StringConstants.SEPARATE_LINK);
            this.addOfflineActivationLink(composite);
        }
        lblNewLabel = new Label(composite, 0);
        lblNewLabel.setText(StringConstants.SEPARATE_LINK);
        Link linkConfigProxy = new Link(composite, 0);
        linkConfigProxy.setText(MessageConstants.CONFIG_PROXY);
        linkConfigProxy.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                new ProxyConfigurationDialog(ActivationDialog.this.getShell()).open();
            }
        });
        ActivateDialogKeyAdapter keyAdapter = new ActivateDialogKeyAdapter();
        this.txtUserName.addKeyListener((KeyListener)keyAdapter);
        this.txtPassword.addKeyListener((KeyListener)keyAdapter);
        ActivateDialogTextChanged textChangedListener = new ActivateDialogTextChanged();
        this.txtUserName.addModifyListener((ModifyListener)textChangedListener);
        this.txtPassword.addModifyListener((ModifyListener)textChangedListener);
        this.btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivationDialog.this.txtPassword.setText("");
                ActivationDialog.this.txtUserName.setText("");
            }
        });
        this.btnActivate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivationDialog.this.processActivate();
            }
        });
        linkForgotPass.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Program.launch((String)StringConstants.FORGOT_PASS_LINK);
            }
        });
        linkRegister.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                try {
                    SignupDialog signupDialog = new SignupDialog(ActivationDialog.this.getShell());
                    if (signupDialog.open() == 0) {
                        SignupDialog.AuthenticationInfo authenticationInfo = signupDialog.getAuthenticationInfo();
                        ActivationDialog.this.setInitialKASettings(authenticationInfo.getEmail(), authenticationInfo.getPassword());
                        ActivationDialog.this.setReturnCode(0);
                        ActivationDialog.this.close();
                    }
                }
                catch (Exception ex) {
                    LogUtil.logError((Throwable)ex);
                }
            }
        });
        this.enableActivateButton();
        return container;
    }

    private void addOfflineActivationLink(Composite composite) {
        Link linkOfflineActivation = new Link(composite, 0);
        linkOfflineActivation.setText(StringConstants.LINK_OPEN_ACTIVATE_FORM_OFFLINE);
        linkOfflineActivation.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                try {
                    int result = new ActivationOfflineDialog(ActivationDialog.this.getShell()).open();
                    if (result == 0) {
                        ActivationDialog.this.setReturnCode(0);
                        ActivationDialog.this.close();
                    }
                }
                catch (Exception ex) {
                    LogUtil.logError((Throwable)ex);
                }
            }
        });
    }

    private boolean isFullFillActivateInfo() {
        return this.txtUserName.getText().trim().length() > 0 && this.txtPassword.getText().trim().length() > 0;
    }

    protected void processActivate() {
        if (!this.isFullFillActivateInfo()) {
            return;
        }
        this.lblError.setForeground(Display.getCurrent().getSystemColor(2));
        this.lblError.setText(StringConstants.WAITTING_MESSAGE);
        final String username = this.txtUserName.getText();
        final String password = this.txtPassword.getText();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                StringBuilder errorMessage = new StringBuilder();
                boolean result = ActivationInfoCollector.activate((String)username, (String)password, (StringBuilder)errorMessage);
                ActivationDialog.this.lblError.setForeground(Display.getCurrent().getSystemColor(3));
                if (result) {
                    ActivationDialog.this.setReturnCode(0);
                    ActivationDialog.this.close();
                } else {
                    ActivationDialog.this.lblError.setText(errorMessage.toString());
                }
            }
        });
        this.setInitialKASettings(username, password);
    }

    private ScopedPreferenceStore getPreferenceStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.activation.dialog");
    }

    public void setInitialKASettings(String txtUsername, String txtPassword) {
        ScopedPreferenceStore preferenceStore = this.getPreferenceStore();
        try {
            String email = CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)txtUsername));
            String password = CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)txtPassword));
            preferenceStore.setValue("email", email);
            preferenceStore.setValue("password", password);
        }
        catch (UnsupportedEncodingException | GeneralSecurityException e1) {
            LoggerSingleton.logError((Throwable)e1);
        }
        try {
            preferenceStore.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void enableActivateButton() {
        boolean enable = this.isFullFillActivateInfo();
        this.lblError.setText(this.isFullFillActivateInfo() ? "" : StringConstants.PROMT_ENTER_USERNAME_PASSWORD);
        this.btnActivate.setEnabled(enable);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MessageConstants.DIA_TITLE_KS_ACTIVATION);
        newShell.setImage(ImageConstants.KATALON_IMAGE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
        parent.getShell().setDefaultButton(this.btnActivate);
    }

    private class ActivateDialogKeyAdapter
    extends KeyAdapter {
        private ActivateDialogKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.character == '\r' || e.character == '\u1000050') {
                ActivationDialog.this.processActivate();
            }
        }
    }

    private class ActivateDialogTextChanged
    implements ModifyListener {
        private ActivateDialogTextChanged() {
        }

        public void modifyText(ModifyEvent e) {
            ActivationDialog.this.enableActivateButton();
        }
    }
}

