/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.viewer;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileObjectSpyDialog;
import com.kms.katalon.composer.mobile.objectspy.element.CapturedMobileElementConverter;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.entity.repository.WebElementEntity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class CapturedObjectTableViewer
extends CTableViewer {
    private List<CapturedMobileElement> capturedElements;
    private MobileObjectSpyDialog dialog;

    public CapturedObjectTableViewer(Composite parent, int style, MobileObjectSpyDialog dialog) {
        super(parent, style);
        this.dialog = dialog;
    }

    public List<CapturedMobileElement> getCapturedElements() {
        return this.capturedElements;
    }

    public void setCapturedElements(List<CapturedMobileElement> capturedElements) {
        this.capturedElements = capturedElements;
        this.setInput(capturedElements);
    }

    public CapturedMobileElement getSelectedElement() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (CapturedMobileElement)selection.getFirstElement();
    }

    public IStructuredSelection getStructuredSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        return selection;
    }

    public CapturedMobileElement[] getSelectedElements() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.isEmpty()) {
            return new CapturedMobileElement[0];
        }
        Object[] rawElements = selection.toArray();
        CapturedMobileElement[] capturedElements = new CapturedMobileElement[rawElements.length];
        int i = 0;
        while (i < rawElements.length) {
            capturedElements[i] = (CapturedMobileElement)rawElements[i];
            ++i;
        }
        return capturedElements;
    }

    public void addElements(List<WebElementEntity> webElements) {
        CapturedMobileElementConverter converter = new CapturedMobileElementConverter();
        ArrayList<CapturedMobileElement> newMobileElements = new ArrayList<CapturedMobileElement>();
        for (WebElementEntity webElement : webElements) {
            newMobileElements.add(converter.revert(webElement));
        }
        this.addMobileElements(newMobileElements);
    }

    public void addMobileElements(List<CapturedMobileElement> mobileElements) {
        ArrayList<CapturedMobileElement> added = new ArrayList<CapturedMobileElement>();
        for (CapturedMobileElement eachElement : mobileElements) {
            int elementIdx = this.capturedElements.indexOf(eachElement);
            if (elementIdx < 0) {
                this.capturedElements.add(eachElement);
                added.add(eachElement);
                continue;
            }
            added.add(this.capturedElements.get(elementIdx));
        }
        this.refresh();
        this.setSelection((ISelection)new StructuredSelection(added));
        this.showLastItem();
        this.notifyStateChanged();
    }

    public void removeCapturedElements(List<CapturedMobileElement> elements) {
        this.capturedElements.removeAll(elements);
        this.refresh();
        this.notifyStateChanged();
    }

    public void removeCapturedElement(CapturedMobileElement element) {
        this.removeCapturedElement(element, true);
    }

    public void removeCapturedElement(CapturedMobileElement element, boolean needRefresh) {
        if (!this.contains(element)) {
            return;
        }
        this.capturedElements.remove(element);
        if (needRefresh) {
            this.refresh();
        }
        this.notifyStateChanged();
    }

    public void checkAllElements(boolean checked) {
        if (this.capturedElements.isEmpty()) {
            return;
        }
        for (CapturedMobileElement mobileElement : this.capturedElements) {
            mobileElement.setChecked(checked);
        }
        this.refresh();
        this.notifyStateChanged();
    }

    public boolean contains(CapturedMobileElement element) {
        if (element == null) {
            return false;
        }
        return this.capturedElements.contains(element);
    }

    public boolean isAllElementChecked() {
        for (CapturedMobileElement mobileElement : this.capturedElements) {
            if (mobileElement.isChecked()) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyElementChecked() {
        for (CapturedMobileElement mobileElement : this.capturedElements) {
            if (!mobileElement.isChecked()) continue;
            return true;
        }
        return false;
    }

    public List<CapturedMobileElement> getAllCheckedElements() {
        ArrayList<CapturedMobileElement> checkedElements = new ArrayList<CapturedMobileElement>();
        for (CapturedMobileElement mobileElement : this.capturedElements) {
            if (!mobileElement.isChecked()) continue;
            checkedElements.add(mobileElement);
        }
        return checkedElements;
    }

    public void notifyStateChanged() {
        this.dialog.updateCapturedElementSelectingColumnHeader();
    }
}

