/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.util;

import com.kms.katalon.core.helper.KeywordHelper;
import com.kms.katalon.core.keyword.internal.KeywordMain;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.keyword.internal.MobileSearchEngine;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testobject.TestObject;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.TouchAction;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Date;
import java.util.Iterator;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.touch.TouchActions;

public class MobileActionHelper {
    private static final int timeout = 10;
    private static final FailureHandling flowControl = FailureHandling.STOP_ON_FAILURE;
    private AppiumDriver<?> driver;

    public MobileActionHelper(AppiumDriver<?> driver) {
        this.driver = driver;
    }

    private WebElement findElement(TestObject to, int timeOut) throws Exception {
        Date startTime = new Date();
        long span = 0L;
        WebElement webElement = null;
        Point elementLocation = null;
        MobileSearchEngine searchEngine = new MobileSearchEngine(this.driver, to);
        Dimension screenSize = this.driver.manage().window().getSize();
        while (span < (long)timeOut) {
            webElement = searchEngine.findWebElement(false);
            if (webElement != null) {
                elementLocation = webElement.getLocation();
                if (elementLocation.y < screenSize.height) break;
                try {
                    if (this.driver instanceof AndroidDriver) {
                        TouchActions ta = new TouchActions((WebDriver)((AndroidDriver)this.driver));
                        ta.down(screenSize.width / 2, screenSize.height / 2).perform();
                        ta.move(screenSize.width / 2, (int)((double)(screenSize.height / 2) * 0.5)).perform();
                        ta.release().perform();
                    } else {
                        TouchAction swipe = new TouchAction(this.driver).press(screenSize.width / 2, screenSize.height / 2).waitAction(Duration.ofMillis(500L)).moveTo(screenSize.width / 2, (int)((double)(screenSize.height / 2) * 0.5)).release();
                        swipe.perform();
                    }
                }
                catch (Exception exception) {}
            }
            Date endTime = new Date();
            span = endTime.getTime() - startTime.getTime();
        }
        return webElement;
    }

    public void tap(TestObject to) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        WebElement element = this.findElement(to, 10000);
        if (element == null) {
            KeywordMain.stepFailed((String)MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), (FailureHandling)flowControl, null);
            return;
        }
        TouchAction tap = new TouchAction(this.driver).tap(element, 1, 1);
        tap.perform();
    }

    public void tapAndHold(TestObject to) throws Exception {
        WebElement element = this.findElement(to, 10);
        TouchAction longPressAction = new TouchAction(this.driver);
        longPressAction = longPressAction.longPress(element);
        longPressAction.release().perform();
    }

    public void setText(TestObject to, String text) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        WebElement element = this.findElement(to, 10000);
        if (element == null) {
            KeywordMain.stepFailed((String)MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), (FailureHandling)flowControl, null);
            return;
        }
        element.clear();
        element.sendKeys(new CharSequence[]{text});
    }

    public void hideKeyboard() {
        String context = this.driver.getContext();
        try {
            this.internalSwitchToNativeContext(this.driver);
            try {
                this.driver.hideKeyboard();
            }
            catch (WebDriverException e) {
                if (!e.getMessage().startsWith(StringConstants.APPIUM_DRIVER_ERROR_JS_FAILED) || !(this.driver instanceof IOSDriver)) {
                    throw e;
                }
                IOSDriver iosDriver = (IOSDriver)this.driver;
                iosDriver.hideKeyboard("pressKey", "Done");
            }
        }
        finally {
            this.driver.context(context);
        }
    }

    public void clearText(TestObject to) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        WebElement element = this.findElement(to, 10000);
        if (element == null) {
            KeywordMain.stepFailed((String)MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), (FailureHandling)flowControl, null);
            return;
        }
        element.clear();
    }

    private boolean internalSwitchToNativeContext(AppiumDriver<?> driver) {
        return this.internalSwitchToContext(driver, "NATIVE");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean internalSwitchToContext(AppiumDriver<?> driver, String contextName) {
        try {
            String context;
            Iterator iterator = driver.getContextHandles().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(context = (String)iterator.next()).contains(contextName));
            driver.context(context);
            return true;
        }
        catch (WebDriverException webDriverException) {}
        return false;
    }

    public void pressBack() throws Exception {
        block4: {
            String context = this.driver.getContext();
            try {
                this.internalSwitchToNativeContext(this.driver);
                if (this.driver instanceof AndroidDriver) {
                    ((AndroidDriver)this.driver).pressKeyCode(4);
                    break block4;
                }
                KeywordMain.stepFailed((String)StringConstants.KW_MSG_UNSUPPORT_ACT_FOR_THIS_DEVICE, (FailureHandling)flowControl, null);
                return;
            }
            finally {
                this.driver.context(context);
            }
        }
    }

    public void switchToLandscape() throws Exception {
        String context = this.driver.getContext();
        try {
            this.internalSwitchToNativeContext(this.driver);
            this.driver.rotate(ScreenOrientation.LANDSCAPE);
        }
        finally {
            this.driver.context(context);
        }
    }

    public void switchToPortrait() throws Exception {
        String context = this.driver.getContext();
        try {
            this.internalSwitchToNativeContext(this.driver);
            this.driver.rotate(ScreenOrientation.PORTRAIT);
        }
        finally {
            this.driver.context(context);
        }
    }
}

