/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.handler;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.mobile.objectspy.constant.StringConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileObjectSpyDialog;
import com.kms.katalon.composer.mobile.util.MobileUtil;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class MobileSpyMobileHandler {
    private MobileObjectSpyDialog objectSpyDialog;
    private Shell activeShell;
    @Inject
    private IEventBroker eventBroker;
    private static MobileSpyMobileHandler instance;

    public MobileSpyMobileHandler() {
        instance = this;
    }

    public static MobileSpyMobileHandler getInstance() {
        return instance;
    }

    @PostConstruct
    public void registerEvent() {
        this.eventBroker.subscribe("OBJECT_SPY/MOBILE", new EventHandler(){

            public void handleEvent(Event event) {
                if (!MobileSpyMobileHandler.this.canExecute()) {
                    return;
                }
                MobileSpyMobileHandler.this.execute(Display.getCurrent().getActiveShell());
            }
        });
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell activeShell) {
        MobileUtil.detectAppiumAndNodeJs((Shell)activeShell);
        this.openAndAddElements(activeShell, new ArrayList<WebElementEntity>());
    }

    public void openAndAddElements(Shell activeShell, List<WebElementEntity> webElements) {
        if (!this.openObjectSpyDialog(activeShell)) {
            return;
        }
        this.objectSpyDialog.addElements(webElements);
    }

    private boolean openObjectSpyDialog(Shell activeShell) {
        try {
            if (this.activeShell == null) {
                this.activeShell = activeShell;
            }
            boolean newDialog = false;
            if (!this.isObjectSpyDialogRunning()) {
                this.objectSpyDialog = new MobileObjectSpyDialog(activeShell);
                this.objectSpyDialog.open();
                newDialog = true;
            }
            if (!this.objectSpyDialog.isCanceledBeforeOpening()) {
                this.objectSpyDialog.getShell().forceActive();
                if (newDialog) {
                    Trackings.trackOpenSpy((String)"mobile");
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (this.isObjectSpyDialogRunning()) {
                this.objectSpyDialog.dispose();
                this.objectSpyDialog.close();
            }
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)activeShell, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
            return false;
        }
    }

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    public boolean isObjectSpyDialogRunning() {
        return this.objectSpyDialog != null && !this.objectSpyDialog.isDisposed();
    }
}

