/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.element.impl;

import com.kms.katalon.composer.mobile.objectspy.element.impl.RenderedTreeSnapshotMobileElement;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IosXCUISnapshotMobileElement
extends RenderedTreeSnapshotMobileElement<Element> {
    private static final long serialVersionUID = 1L;

    public IosXCUISnapshotMobileElement() {
    }

    public IosXCUISnapshotMobileElement(IosXCUISnapshotMobileElement parent) {
        super(parent);
    }

    @Override
    public void render(Element xmlElement) {
        if (xmlElement == null) {
            return;
        }
        this.convertXMLElementToWebElementForXCUITestElement(xmlElement);
        if (!xmlElement.hasChildNodes()) {
            return;
        }
        NodeList childElementNodes = xmlElement.getChildNodes();
        int count = childElementNodes.getLength();
        int i = 0;
        while (i < count) {
            Node node = childElementNodes.item(i);
            if (node instanceof Element) {
                IosXCUISnapshotMobileElement childNode = new IosXCUISnapshotMobileElement(this);
                this.getChildrenElement().add(childNode);
                childNode.render((Element)node);
            }
            ++i;
        }
    }

    public void convertXMLElementToWebElementForXCUITestElement(Element xmlElement) {
        Map<String, String> htmlMobileElementProps = this.getAttributes();
        NamedNodeMap attributesNodeMap = xmlElement.getAttributes();
        htmlMobileElementProps.put("type", xmlElement.getTagName());
        int index = 0;
        while (index < attributesNodeMap.getLength()) {
            String nodeValue;
            Node atrributeNode = attributesNodeMap.item(index);
            if (atrributeNode.getNodeType() == 2 && !StringUtils.isEmpty((String)(nodeValue = atrributeNode.getNodeValue()))) {
                htmlMobileElementProps.put(atrributeNode.getNodeName(), nodeValue);
            }
            ++index;
        }
        this.getAttributes().put("xpath", this.makeXpath());
        this.setName(this.getNameForElement(htmlMobileElementProps));
        this.doubleDimensionValues(htmlMobileElementProps);
    }

    private String getNameForElement(Map<String, String> htmlMobileElementProps) {
        String guiName = htmlMobileElementProps.get("type");
        String propName = htmlMobileElementProps.get("name");
        if (propName != null) {
            return String.valueOf(guiName) + " - " + propName;
        }
        String propLabel = htmlMobileElementProps.get("label");
        if (propLabel != null) {
            return String.valueOf(guiName) + " - " + propLabel;
        }
        String propValue = htmlMobileElementProps.get("value");
        if (propValue != null) {
            return String.valueOf(guiName) + " - " + propValue;
        }
        return guiName;
    }

    private void doubleDimensionValues(Map<String, String> htmlMobileElementProps) {
        this.doubleValue(htmlMobileElementProps, "x");
        this.doubleValue(htmlMobileElementProps, "y");
        this.doubleValue(htmlMobileElementProps, "height");
        this.doubleValue(htmlMobileElementProps, "width");
    }

    private void doubleValue(Map<String, String> htmlMobileElementProps, String propertyName) {
        String elementProperty = htmlMobileElementProps.get(propertyName);
        if (elementProperty == null) {
            return;
        }
        Double propertyDoubleValue = Double.parseDouble(elementProperty);
        htmlMobileElementProps.put(propertyName, String.valueOf(propertyDoubleValue * 2.0));
    }

    @Override
    public MobileDriverType getMobileDriverType() {
        return MobileDriverType.IOS_DRIVER;
    }

    @Override
    public String getTagName() {
        return this.getAttributes().get("type");
    }
}

