/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.dialog;

import com.kms.katalon.composer.components.controls.HelpCompositeForDialog;
import com.kms.katalon.composer.components.dialogs.MessageDialogWithLink;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.mobile.objectspy.components.KobitonAppComposite;
import com.kms.katalon.composer.mobile.objectspy.components.LocalAppComposite;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.constant.ImageConstants;
import com.kms.katalon.composer.mobile.objectspy.constant.StringConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.AddElementToObjectRepositoryDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumMonitorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileAppDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileDeviceDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileElementInspectorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileElementPropertiesComposite;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileInspectorController;
import com.kms.katalon.composer.mobile.objectspy.element.CapturedMobileElementConverter;
import com.kms.katalon.composer.mobile.objectspy.element.MobileDeviceType;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.TreeMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.provider.CapturedElementLabelProvider;
import com.kms.katalon.composer.mobile.objectspy.element.provider.SelectableElementEditingSupport;
import com.kms.katalon.composer.mobile.objectspy.element.tree.MobileElementLabelProvider;
import com.kms.katalon.composer.mobile.objectspy.element.tree.MobileElementTreeContentProvider;
import com.kms.katalon.composer.mobile.objectspy.preferences.MobileObjectSpyPreferencesHelper;
import com.kms.katalon.composer.mobile.objectspy.util.KobitonValidator;
import com.kms.katalon.composer.mobile.objectspy.viewer.CapturedObjectTableViewer;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class MobileObjectSpyDialog
extends Dialog
implements MobileElementInspectorDialog,
MobileAppDialog {
    public static final Point DIALOG_SIZE = new Point(800, 800);
    private static final String DIALOG_TITLE = StringConstants.DIA_DIALOG_TITLE_MOBILE_OBJ_SPY;
    private static final int DIALOG_MARGIN_OFFSET = 5;
    private Combo cbbAppType;
    private CheckboxTreeViewer allElementTreeViewer;
    private ToolItem btnStart;
    private ToolItem btnCapture;
    private ToolItem btnAdd;
    private ToolItem btnStop;
    private TreeMobileElement appRootElement;
    private boolean disposed;
    private MobileInspectorController inspectorController;
    private MobileDeviceDialog deviceView;
    private Composite container;
    private boolean canceledBeforeOpening;
    private CapturedObjectTableViewer capturedObjectsTableViewer;
    private TableColumn tblclmnCapturedObjectsSelection;
    private MobileElementPropertiesComposite propertiesComposite;
    private MobileObjectSpyPreferencesHelper preferencesHelper;
    private LocalAppComposite localAppComposite;
    private KobitonAppComposite kobitonAppComposite;
    private StackLayout stackLayout;
    private Composite appsComposite;

    public boolean isCanceledBeforeOpening() {
        return this.canceledBeforeOpening;
    }

    public MobileObjectSpyDialog(Shell parentShell) throws Exception {
        super(parentShell);
        this.setShellStyle(1264);
        this.disposed = false;
        this.inspectorController = new MobileInspectorController();
        this.preferencesHelper = new MobileObjectSpyPreferencesHelper();
    }

    protected Control createDialogArea(Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.container.setLayout((Layout)layout);
        SashForm sashForm = new SashForm(this.container, 0);
        sashForm.setSashWidth(3);
        sashForm.setLayout((Layout)new FillLayout());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite leftSashForm = new ScrolledComposite((Composite)sashForm, 768);
        leftSashForm.setExpandHorizontal(true);
        leftSashForm.setExpandVertical(true);
        leftSashForm.setMinSize(180, 400);
        Composite explorerComposite = new Composite((Composite)leftSashForm, 2048);
        explorerComposite.setLayout((Layout)layout);
        this.addElementTreeToolbar(explorerComposite);
        SashForm hSashForm = new SashForm(explorerComposite, 512);
        hSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createCapturedObjectsComposite(hSashForm);
        this.propertiesComposite = new MobileElementPropertiesComposite(this);
        this.propertiesComposite.createObjectPropertiesComposite((Composite)hSashForm);
        hSashForm.setWeights(new int[]{1, 1});
        leftSashForm.setContent((Control)explorerComposite);
        ScrolledComposite rightSashForm = new ScrolledComposite((Composite)sashForm, 768);
        rightSashForm.setExpandHorizontal(true);
        rightSashForm.setExpandVertical(true);
        rightSashForm.setMinSize(280, 400);
        Composite contentComposite = new Composite((Composite)rightSashForm, 2048);
        contentComposite.setLayout((Layout)layout);
        this.addStartStopToolbar(contentComposite);
        this.createSettingComposite(contentComposite);
        this.createAllObjectsComposite(contentComposite);
        rightSashForm.setContent((Control)contentComposite);
        sashForm.setWeights(new int[]{4, 6});
        new HelpCompositeForDialog(this.container, DocumentationMessageConstants.DIALOG_OBJECT_SPY_MOBILE);
        return this.container;
    }

    private void createCapturedObjectsComposite(SashForm hSashForm) {
        Composite capturedObjectsComposite = new Composite((Composite)hSashForm, 0);
        capturedObjectsComposite.setLayout((Layout)new GridLayout());
        Label lblCapturedObjects = new Label(capturedObjectsComposite, 0);
        lblCapturedObjects.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblCapturedObjects.setText(StringConstants.DIA_LBL_CAPTURED_OBJECTS);
        ControlUtils.setFontToBeBold((Control)lblCapturedObjects);
        Composite capturedObjectTableComposite = new Composite(capturedObjectsComposite, 0);
        capturedObjectTableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tbclCapturedObjects = new TableColumnLayout();
        capturedObjectTableComposite.setLayout((Layout)tbclCapturedObjects);
        this.capturedObjectsTableViewer = new CapturedObjectTableViewer(capturedObjectTableComposite, 68354, this);
        Table capturedObjectsTable = this.capturedObjectsTableViewer.getTable();
        capturedObjectsTable.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        capturedObjectsTable.setHeaderVisible(true);
        capturedObjectsTable.setLinesVisible(true);
        TableViewerColumn tbvclCapturedObjectsSelection = new TableViewerColumn((TableViewer)this.capturedObjectsTableViewer, 0);
        this.tblclmnCapturedObjectsSelection = tbvclCapturedObjectsSelection.getColumn();
        tbvclCapturedObjectsSelection.setLabelProvider((CellLabelProvider)new CapturedElementLabelProvider(0));
        tbvclCapturedObjectsSelection.setEditingSupport((EditingSupport)new SelectableElementEditingSupport((ColumnViewer)this.capturedObjectsTableViewer));
        TableViewerColumn tableViewerColumnCapturedObjects = new TableViewerColumn((TableViewer)this.capturedObjectsTableViewer, 0);
        TableColumn tblclmnCapturedObjects = tableViewerColumnCapturedObjects.getColumn();
        tblclmnCapturedObjects.setText(StringConstants.NAME);
        tableViewerColumnCapturedObjects.setLabelProvider((CellLabelProvider)new CapturedElementLabelProvider(1));
        this.capturedObjectsTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        int selectionColMinWidth = "macosx".equals(Platform.getOS()) ? 21 : 30;
        tbclCapturedObjects.setColumnData((Widget)this.tblclmnCapturedObjectsSelection, (ColumnLayoutData)new ColumnWeightData(0, selectionColMinWidth, false));
        tbclCapturedObjects.setColumnData((Widget)tblclmnCapturedObjects, (ColumnLayoutData)new ColumnWeightData(60, 250 - selectionColMinWidth));
        capturedObjectsTable.setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.capturedObjectsTableViewer);
        this.capturedObjectsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CapturedMobileElement firstElement = (CapturedMobileElement)selection.getFirstElement();
                MobileObjectSpyDialog.this.propertiesComposite.setEditingElement(firstElement);
            }
        });
        this.capturedObjectsTableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                Point pt = new Point(e.x, e.y);
                TableItem item = MobileObjectSpyDialog.this.capturedObjectsTableViewer.getTable().getItem(pt);
                if (item != null) {
                    MobileObjectSpyDialog.this.highlightObject((CapturedMobileElement)item.getData());
                }
            }
        });
        capturedObjectsTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CapturedMobileElement[] elements = MobileObjectSpyDialog.this.capturedObjectsTableViewer.getSelectedElements();
                if (elements == null || elements.length == 0) {
                    return;
                }
                switch (e.keyCode) {
                    case 127: {
                        MobileObjectSpyDialog.this.removeSelectedCapturedElements(elements);
                        break;
                    }
                    case 0x100000E: {
                        MobileObjectSpyDialog.this.verifyCapturedElementsStates(elements);
                        break;
                    }
                    case 0x100000B: {
                        if (elements.length != 1) break;
                        MobileObjectSpyDialog.this.propertiesComposite.focusAndEditCapturedElementName();
                    }
                }
            }
        });
        this.capturedObjectsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CapturedMobileElement mobileElement = MobileObjectSpyDialog.this.capturedObjectsTableViewer.getSelectedElement();
                TreeMobileElement link = mobileElement.getLink();
                if (link != null) {
                    MobileObjectSpyDialog.this.allElementTreeViewer.setSelection((ISelection)new StructuredSelection((Object)link));
                    MobileObjectSpyDialog.this.allElementTreeViewer.getTree().setFocus();
                }
            }
        });
        this.tblclmnCapturedObjectsSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileObjectSpyDialog.this.capturedObjectsTableViewer.checkAllElements(!MobileObjectSpyDialog.this.capturedObjectsTableViewer.isAllElementChecked());
            }
        });
    }

    public void updateCapturedElementSelectingColumnHeader() {
        this.tblclmnCapturedObjectsSelection.setImage(this.capturedObjectsTableViewer.isAllElementChecked() ? ImageConstants.IMG_16_CHECKED : ImageConstants.IMG_16_UNCHECKED);
        this.btnAdd.setEnabled(this.capturedObjectsTableViewer.isAnyElementChecked());
    }

    private void verifyCapturedElementsStates(CapturedMobileElement[] elements) {
        this.clearAllObjectState(elements);
        if (this.appRootElement != null) {
            CapturedMobileElement[] capturedMobileElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                CapturedMobileElement needToVerify = capturedMobileElementArray[n2];
                TreeMobileElement foundElement = this.appRootElement.findBestMatch(needToVerify);
                if (foundElement != null) {
                    needToVerify.setLink(foundElement);
                    foundElement.setCapturedElement(needToVerify);
                    this.allElementTreeViewer.setChecked((Object)foundElement, true);
                }
                ++n2;
            }
        }
        this.allElementTreeViewer.refresh();
        this.capturedObjectsTableViewer.refresh();
    }

    private void removeSelectedCapturedElements(CapturedMobileElement[] elements) {
        this.clearAllObjectState(elements);
        this.allElementTreeViewer.refresh();
        this.capturedObjectsTableViewer.removeCapturedElements(Arrays.asList(elements));
        this.propertiesComposite.setEditingElement(null);
    }

    private void clearAllObjectState(CapturedMobileElement[] elements) {
        CapturedMobileElement[] capturedMobileElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            CapturedMobileElement captured = capturedMobileElementArray[n2];
            TreeMobileElement treeElementLink = captured.getLink();
            if (treeElementLink != null) {
                treeElementLink.setCapturedElement(null);
                captured.setLink(null);
                Tree elementTree = this.allElementTreeViewer.getTree();
                if (elementTree != null && !elementTree.isDisposed() && this.allElementTreeViewer.getChecked((Object)treeElementLink)) {
                    this.allElementTreeViewer.setChecked((Object)treeElementLink, false);
                }
            }
            ++n2;
        }
    }

    private void createAllObjectsComposite(Composite parentComposite) {
        Composite allObjectsComposite = new Composite(parentComposite, 0);
        allObjectsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        allObjectsComposite.setLayout((Layout)new GridLayout());
        Label lblAllObjects = new Label(allObjectsComposite, 0);
        lblAllObjects.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblAllObjects.setFont(this.getFontBold(lblAllObjects));
        lblAllObjects.setText(StringConstants.DIA_LBL_ALL_OBJECTS);
        this.allElementTreeViewer = new CheckboxTreeViewer(allObjectsComposite, 68354){

            public boolean setSubtreeChecked(Object element, boolean state) {
                Widget widget = this.internalExpand(element, false);
                if (widget instanceof TreeItem) {
                    TreeItem item = (TreeItem)widget;
                    item.setChecked(state);
                    return true;
                }
                return false;
            }
        };
        final Tree tree = this.allElementTreeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.allElementTreeViewer.setLabelProvider((IBaseLabelProvider)new MobileElementLabelProvider());
        this.allElementTreeViewer.setContentProvider((IContentProvider)new MobileElementTreeContentProvider());
        tree.setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.allElementTreeViewer, (int)2);
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                Point pt = new Point(e.x, e.y);
                TreeItem item = tree.getItem(pt);
                if (item != null) {
                    MobileObjectSpyDialog.this.highlightObject((MobileElement)item.getData());
                }
            }
        });
        this.allElementTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TreeMobileElement selectedElement = (TreeMobileElement)event.getElement();
                if (event.getChecked()) {
                    ArrayList<CapturedMobileElement> mobileElements = new ArrayList<CapturedMobileElement>();
                    mobileElements.add(selectedElement.newCapturedElement());
                    MobileObjectSpyDialog.this.capturedObjectsTableViewer.addMobileElements(mobileElements);
                    MobileObjectSpyDialog.this.propertiesComposite.focusAndEditCapturedElementName();
                } else {
                    CapturedMobileElement capturedElement = selectedElement.getCapturedElement();
                    if (MobileObjectSpyDialog.this.capturedObjectsTableViewer.contains(capturedElement)) {
                        MobileObjectSpyDialog.this.capturedObjectsTableViewer.removeCapturedElement(capturedElement);
                        selectedElement.setCapturedElement(null);
                        MobileObjectSpyDialog.this.propertiesComposite.setEditingElement(null);
                    }
                }
                MobileObjectSpyDialog.this.allElementTreeViewer.refresh((Object)selectedElement);
            }
        });
    }

    private void createSettingComposite(Composite parent) {
        Composite settingComposite = new Composite(parent, 0);
        settingComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glSettingComposite = new GridLayout(2, false);
        glSettingComposite.horizontalSpacing = 10;
        settingComposite.setLayout((Layout)glSettingComposite);
        Label lblConfiguration = new Label(settingComposite, 0);
        lblConfiguration.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        lblConfiguration.setFont(this.getFontBold(lblConfiguration));
        lblConfiguration.setText(StringConstants.DIA_LBL_CONFIGURATIONS);
        Label typeLabel = new Label(settingComposite, 0);
        typeLabel.setText(StringConstants.DIA_LBL_APP_TYPE);
        this.cbbAppType = new Combo(settingComposite, 8);
        this.cbbAppType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cbbAppType.setItems(this.getAllDeviceTypeStringValues());
        this.cbbAppType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileObjectSpyDialog.this.changeAppComposite();
                MobileObjectSpyDialog.this.refreshButtonsState();
            }
        });
        this.appsComposite = new Composite(settingComposite, 0);
        this.stackLayout = new StackLayout();
        this.appsComposite.setLayout((Layout)this.stackLayout);
        this.appsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.localAppComposite = new LocalAppComposite(this.appsComposite, this, this.preferencesHelper, 0);
        this.kobitonAppComposite = new KobitonAppComposite(this.appsComposite, this, 0);
        this.changeAppCompositeToLocal();
    }

    private void changeAppComposite() {
        MobileDeviceType mobileDeviceType = MobileDeviceType.fromDisplayName(this.cbbAppType.getText());
        this.changeAppComposite(mobileDeviceType);
    }

    private void changeAppComposite(MobileDeviceType mobileDeviceType) {
        if (mobileDeviceType == MobileDeviceType.Kobiton && this.stackLayout.topControl != this.kobitonAppComposite) {
            this.changeAppCompositeToKobiton();
        } else if (mobileDeviceType == MobileDeviceType.Local && this.stackLayout.topControl != this.localAppComposite) {
            this.changeAppCompositeToLocal();
        }
        this.appsComposite.layout();
    }

    private void changeAppCompositeToLocal() {
        this.stackLayout.topControl = this.localAppComposite;
    }

    private void changeAppCompositeToKobiton() {
        if (!KobitonValidator.validateKobitonIntergration()) {
            this.cbbAppType.select(MobileDeviceType.indexOf(MobileDeviceType.Local));
            return;
        }
        this.stackLayout.topControl = this.kobitonAppComposite;
        this.updateDeviceNames();
        this.updateApps();
    }

    private String[] getAllDeviceTypeStringValues() {
        return (String[])Arrays.asList(MobileDeviceType.values()).stream().filter(deviceType -> deviceType.isSupported()).map(deviceType -> deviceType.getDisplayName()).toArray(String[]::new);
    }

    void updateSelectedElement(CapturedMobileElement selectedElement) {
        this.capturedObjectsTableViewer.refresh(selectedElement, true);
        TreeMobileElement element = selectedElement.getLink();
        if (element != null) {
            this.allElementTreeViewer.refresh((Object)element);
            this.allElementTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
    }

    @Override
    public void refreshButtonsState() {
        if (this.cbbAppType.getSelectionIndex() < 0) {
            this.btnStart.setEnabled(false);
            return;
        }
        if (this.stackLayout.topControl == this.localAppComposite) {
            this.btnStart.setEnabled(this.localAppComposite.isAbleToStart());
        } else if (this.stackLayout.topControl == this.kobitonAppComposite) {
            this.btnStart.setEnabled(this.kobitonAppComposite.isAbleToStart());
        }
    }

    public void create() {
        super.create();
        this.updateDeviceNames();
        this.cbbAppType.select(0);
        this.refreshButtonsState();
        this.capturedObjectsTableViewer.setCapturedElements(new ArrayList<CapturedMobileElement>());
    }

    @Override
    public void updateDeviceNames() {
        try {
            try {
                ControlUtils.recursiveSetEnabled((Control)this.container, (boolean)false);
                if (this.stackLayout.topControl == this.localAppComposite) {
                    this.localAppComposite.updateLocalDevices();
                } else if (this.stackLayout.topControl == this.kobitonAppComposite) {
                    this.kobitonAppComposite.updateKobitonDevices();
                }
            }
            catch (InterruptedException interruptedException) {
                this.canceledBeforeOpening = true;
                ControlUtils.recursiveSetEnabled((Control)this.container, (boolean)true);
                this.refreshButtonsState();
            }
            catch (InvocationTargetException e) {
                LoggerSingleton.logError((Throwable)e);
                Throwable targetException = e.getTargetException();
                MultiStatusErrorDialog.showErrorDialog((Throwable)targetException, (String)StringConstants.DIA_ERROR_UNABLE_TO_COLLECT_DEVICES, (String)targetException.getClass().getSimpleName());
                this.canceledBeforeOpening = true;
                ControlUtils.recursiveSetEnabled((Control)this.container, (boolean)true);
                this.refreshButtonsState();
            }
        }
        finally {
            ControlUtils.recursiveSetEnabled((Control)this.container, (boolean)true);
            this.refreshButtonsState();
        }
    }

    private void updateApps() {
        try {
            ControlUtils.recursiveSetEnabled((Control)this.container, (boolean)false);
            if (this.stackLayout.topControl != this.kobitonAppComposite) {
                return;
            }
            try {
                this.kobitonAppComposite.updateKobitonApps();
            }
            catch (InterruptedException interruptedException) {
                this.canceledBeforeOpening = true;
            }
            catch (InvocationTargetException e) {
                LoggerSingleton.logError((Throwable)e);
                Throwable targetException = e.getTargetException();
                MultiStatusErrorDialog.showErrorDialog((Throwable)targetException, (String)ComposerMobileObjectspyMessageConstants.ERR_MSG_CANNOT_COLLECT_APPS, (String)targetException.getClass().getSimpleName());
                this.canceledBeforeOpening = true;
            }
        }
        finally {
            ControlUtils.recursiveSetEnabled((Control)this.container, (boolean)true);
            this.refreshButtonsState();
        }
    }

    public int open() {
        try {
            this.canceledBeforeOpening = false;
            int n = super.open();
            return n;
        }
        finally {
            if (this.canceledBeforeOpening) {
                this.close();
            }
        }
    }

    private Font getFontBold(Label label) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        return boldDescriptor.createFont((Device)label.getDisplay());
    }

    private void addElementTreeToolbar(Composite explorerComposite) {
        ToolBar elementTreeToolbar = new ToolBar(explorerComposite, 0x820000);
        GridData layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        layoutData.horizontalIndent = 2;
        layoutData.minimumWidth = 180;
        elementTreeToolbar.setLayoutData((Object)layoutData);
        this.btnAdd = new ToolItem(elementTreeToolbar, 0);
        this.btnAdd.setImage(ImageConstants.IMG_24_ADD_TO_OBJECT_REPOSITORY);
        this.btnAdd.setDisabledImage(ImageConstants.IMG_24_ADD_TO_OBJECT_REPOSITORY_DISABLED);
        this.btnAdd.setText(StringConstants.DIA_TIP_ADD);
        this.btnAdd.setToolTipText(StringConstants.DIA_TIP_ADD);
        this.btnAdd.setEnabled(false);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    AddElementToObjectRepositoryDialog dialog = new AddElementToObjectRepositoryDialog(MobileObjectSpyDialog.this.getParentShell());
                    if (dialog.open() != 0) {
                        return;
                    }
                    FolderTreeEntity folderTreeEntity = dialog.getSelectedFolderTreeEntity();
                    FolderEntity folder = folderTreeEntity.getObject();
                    List<ITreeEntity> newTreeEntities = this.addElementsToRepository(folderTreeEntity, folder);
                    Trackings.trackSaveSpy((String)"mobile", (int)newTreeEntities.size());
                    MobileObjectSpyDialog.this.removeSelectedCapturedElements(MobileObjectSpyDialog.this.capturedObjectsTableViewer.getAllCheckedElements().toArray(new CapturedMobileElement[0]));
                    this.updateExplorerState(folderTreeEntity, newTreeEntities);
                }
                catch (Exception ex) {
                    LoggerSingleton.logError((Throwable)ex);
                    MessageDialog.openError((Shell)MobileObjectSpyDialog.this.getParentShell(), (String)StringConstants.ERROR_TITLE, (String)ex.getMessage());
                }
            }

            private void updateExplorerState(FolderTreeEntity folderTreeEntity, List<ITreeEntity> newTreeEntities) {
                IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
                eventBroker.send("EXPLORER/REFRESH_SELECTED_ITEM", (Object)folderTreeEntity);
                eventBroker.send("EXPLORER/SET_SELECTED_ITEMS", (Object)newTreeEntities.toArray());
            }

            private List<ITreeEntity> addElementsToRepository(FolderTreeEntity folderTreeEntity, FolderEntity folder) throws Exception {
                CapturedMobileElementConverter converter = new CapturedMobileElementConverter();
                ArrayList<ITreeEntity> newTreeEntities = new ArrayList<ITreeEntity>();
                ObjectRepositoryController objectRepositoryController = ObjectRepositoryController.getInstance();
                MobileDriverType currentMobileType = MobileObjectSpyDialog.this.getCurrentMobileDriverType();
                for (CapturedMobileElement mobileElement : MobileObjectSpyDialog.this.capturedObjectsTableViewer.getAllCheckedElements()) {
                    WebElementEntity testObject = converter.convert(mobileElement, folder, currentMobileType);
                    objectRepositoryController.updateTestObject(testObject);
                    newTreeEntities.add((ITreeEntity)new WebElementTreeEntity(testObject, (ITreeEntity)folderTreeEntity));
                }
                return newTreeEntities;
            }
        });
    }

    private MobileDriverType getCurrentMobileDriverType() {
        if (this.stackLayout.topControl == this.localAppComposite) {
            return MobileInspectorController.getMobileDriverType(this.localAppComposite.getSelectedMobileDeviceInfo());
        }
        if (this.stackLayout.topControl == this.kobitonAppComposite) {
            return MobileInspectorController.getMobileDriverType(this.kobitonAppComposite.getSelectedKobitonDevice());
        }
        return null;
    }

    private void addStartStopToolbar(Composite contentComposite) {
        Composite toolbarComposite = new Composite(contentComposite, 0);
        toolbarComposite.setLayout((Layout)new GridLayout(2, false));
        toolbarComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar contentToolbar = new ToolBar(toolbarComposite, 0x820000);
        contentToolbar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.btnCapture = new ToolItem(contentToolbar, 0);
        this.btnCapture.setImage(ImageConstants.IMG_24_CAPTURE);
        this.btnCapture.setDisabledImage(ImageConstants.IMG_24_CAPTURE_DISABLED);
        this.btnCapture.setText(StringConstants.DIA_TIP_CAPTURE_OBJ);
        this.btnCapture.setToolTipText(StringConstants.DIA_TIP_CAPTURE_OBJ);
        this.btnCapture.setEnabled(false);
        this.btnCapture.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileObjectSpyDialog.this.captureObjectAction();
            }
        });
        this.btnStart = new ToolItem(contentToolbar, 0);
        this.btnStart.setImage(ImageConstants.IMG_24_START_DEVICE);
        this.btnStart.setDisabledImage(ImageConstants.IMG_24_START_DEVICE_DISABLED);
        this.btnStart.setText(StringConstants.DIA_TIP_START_APP);
        this.btnStart.setToolTipText(StringConstants.DIA_TIP_START_APP);
        this.btnStart.setEnabled(false);
        this.btnStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MobileObjectSpyDialog.this.validateAppSetting()) {
                    MobileObjectSpyDialog.this.startObjectInspectorAction();
                }
            }
        });
        this.btnStop = new ToolItem(contentToolbar, 0);
        this.btnStop.setImage(ImageConstants.IMG_24_STOP_DEVICE);
        this.btnStop.setDisabledImage(ImageConstants.IMG_24_STOP_DEVICE_DISABLED);
        this.btnStop.setText(StringConstants.DIA_TIP_STOP);
        this.btnStop.setToolTipText(StringConstants.DIA_TIP_STOP);
        this.btnStop.setEnabled(false);
        this.btnStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileObjectSpyDialog.this.stopObjectInspectorAction();
            }
        });
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.dispose();
    }

    public void dispose() {
        this.disposed = true;
    }

    protected Point getInitialSize() {
        return DIALOG_SIZE;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
        shell.setMinimumSize(500, 500);
    }

    private void highlightObject(MobileElement selectedElement) {
        if (selectedElement == null || this.deviceView == null || this.deviceView.isDisposed()) {
            return;
        }
        this.deviceView.highlightElement(selectedElement);
    }

    private boolean isOutOfBound(Rectangle displayBounds, Point dialogSize, int startX) {
        return startX < 0 || startX + dialogSize.x > displayBounds.width + displayBounds.x;
    }

    private int getDeviceViewStartXIfPlaceRight(Rectangle objectSpyViewBounds) {
        return objectSpyViewBounds.x + objectSpyViewBounds.width + 5;
    }

    private int getDeviceViewStartXIfPlaceLeft(Rectangle objectSpyViewBounds, Point dialogSize) {
        return objectSpyViewBounds.x - dialogSize.x - 5;
    }

    private int getDefaultDeviceViewDialogStartX(Rectangle displayBounds, Point dialogSize) {
        return displayBounds.width - dialogSize.x;
    }

    private int calculateObjectSpyDialogStartX(Rectangle displayBounds, Point dialogSize) {
        int dialogsWidth = dialogSize.x + 400;
        int startX = (displayBounds.width - dialogsWidth) / 2 + displayBounds.x;
        return Math.max(startX, 0);
    }

    private int calculateObjectSpyDialogStartY(Rectangle displayBounds, Point dialogSize) {
        int startY = displayBounds.height - dialogSize.y;
        return Math.max(startY, 0) / 2;
    }

    private Point calculateInitPositionForDeviceViewDialog() {
        Rectangle objectSpyViewBounds;
        int startX;
        Point dialogSize;
        Rectangle displayBounds = this.getShell().getMonitor().getBounds();
        if (this.isOutOfBound(displayBounds, dialogSize = new Point(400, 600), startX = this.getDeviceViewStartXIfPlaceRight(objectSpyViewBounds = this.getShell().getBounds())) && this.isOutOfBound(displayBounds, dialogSize, startX = this.getDeviceViewStartXIfPlaceLeft(objectSpyViewBounds, dialogSize))) {
            startX = this.getDefaultDeviceViewDialogStartX(displayBounds, dialogSize);
        }
        return new Point(startX, objectSpyViewBounds.y);
    }

    private void openDeviceView() {
        if (this.deviceView != null && !this.deviceView.isDisposed()) {
            return;
        }
        this.deviceView = new MobileDeviceDialog(this.getParentShell(), this, this.calculateInitPositionForDeviceViewDialog());
        this.deviceView.open();
        this.setDeviceView(this.deviceView);
    }

    @Override
    public void setSelectedElementByLocation(int x, int y) {
        if (this.appRootElement == null) {
            return;
        }
        final TreeMobileElement foundElement = this.recursivelyFindElementByLocation(this.appRootElement, x, y);
        if (foundElement == null) {
            return;
        }
        this.highlightObject(foundElement);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MobileObjectSpyDialog.this.getShell().setFocus();
                MobileObjectSpyDialog.this.allElementTreeViewer.getTree().setFocus();
                MobileObjectSpyDialog.this.allElementTreeViewer.setSelection((ISelection)new StructuredSelection((Object)foundElement));
            }
        });
    }

    private TreeMobileElement recursivelyFindElementByLocation(TreeMobileElement currentElement, int x, int y) {
        for (TreeMobileElement treeMobileElement : currentElement.getChildrenElement()) {
            Map<String, String> attributes = treeMobileElement.getAttributes();
            Double elementX = Double.parseDouble(attributes.get("x"));
            Double elementY = Double.parseDouble(attributes.get("y"));
            Double elementWidth = Double.parseDouble(attributes.get("width"));
            Double elementHeight = Double.parseDouble(attributes.get("height"));
            Rectangle rectangle = new Rectangle(MobileDeviceDialog.safeRoundDouble(elementX), MobileDeviceDialog.safeRoundDouble(elementY), MobileDeviceDialog.safeRoundDouble(elementWidth), MobileDeviceDialog.safeRoundDouble(elementHeight));
            if (!rectangle.contains(x, y)) continue;
            return this.recursivelyFindElementByLocation(treeMobileElement, x, y);
        }
        return currentElement;
    }

    private void captureObjectAction() {
        final String appName = this.getAppName();
        final ProgressMonitorDialogWithThread dialog = new ProgressMonitorDialogWithThread(this.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(StringConstants.DIA_JOB_TASK_CAPTURING_OBJECTS, -1);
                dialog.runAndWait((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        MobileObjectSpyDialog.this.appRootElement = MobileObjectSpyDialog.this.inspectorController.getMobileObjectRoot();
                        if (MobileObjectSpyDialog.this.appRootElement != null) {
                            MobileObjectSpyDialog.this.appRootElement.setName(appName);
                        }
                        return null;
                    }
                });
                MobileObjectSpyDialog.this.checkMonitorCanceled(monitor);
                this.refreshTreeElements(dialog);
                String imgPath = this.captureImage();
                MobileObjectSpyDialog.this.checkMonitorCanceled(monitor);
                this.refreshDeviceView(imgPath);
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MobileObjectSpyDialog.this.deviceView.getShell().forceActive();
                    }
                });
                monitor.done();
            }

            private void refreshTreeElements(final ProgressMonitorDialogWithThread dialog2) {
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        dialog2.setCancelable(false);
                        MobileObjectSpyDialog.this.allElementTreeViewer.setInput((Object)new Object[]{MobileObjectSpyDialog.this.appRootElement});
                        MobileObjectSpyDialog.this.allElementTreeViewer.refresh();
                        MobileObjectSpyDialog.this.allElementTreeViewer.expandAll();
                        MobileObjectSpyDialog.this.verifyCapturedElementsStates(MobileObjectSpyDialog.this.capturedObjectsTableViewer.getCapturedElements().toArray(new CapturedMobileElement[0]));
                        dialog2.setCancelable(true);
                    }
                });
            }

            private void refreshDeviceView(String imgPath) {
                File imgFile = new File(imgPath);
                if (imgFile.exists()) {
                    MobileObjectSpyDialog.this.deviceView.refreshDialog(imgFile, MobileObjectSpyDialog.this.appRootElement);
                }
            }

            private String captureImage() throws InvocationTargetException {
                try {
                    return MobileObjectSpyDialog.this.inspectorController.captureScreenshot();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            try {
                this.btnCapture.setEnabled(false);
                this.openDeviceView();
                dialog.run(true, true, runnable);
            }
            catch (InterruptedException interruptedException) {
                this.btnCapture.setEnabled(true);
            }
            catch (InvocationTargetException e) {
                LoggerSingleton.logError((Throwable)e);
                Throwable exception = e.getTargetException();
                MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)StringConstants.DIA_ERROR_UNABLE_TO_CAPTURE_OBJECTS, (String)exception.getClass().getSimpleName());
                this.btnCapture.setEnabled(true);
            }
        }
        finally {
            this.btnCapture.setEnabled(true);
        }
    }

    public String getAppName() {
        if (this.stackLayout.topControl == this.localAppComposite) {
            return this.localAppComposite.getAppName();
        }
        if (this.stackLayout.topControl == this.kobitonAppComposite) {
            return this.kobitonAppComposite.getAppName();
        }
        return "";
    }

    private void checkMonitorCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException(StringConstants.DIA_ERROR_MSG_OPERATION_CANCELED);
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private void startObjectInspectorAction() {
        this.btnStart.setEnabled(false);
        AppiumMonitorDialog progressDlg = new AppiumMonitorDialog(this.getShell()){

            public void cancelPressed() {
                super.cancelPressed();
                this.finishedRun();
                this.getProgressMonitor().done();
                MobileObjectSpyDialog.this.btnStart.setEnabled(true);
                MobileObjectSpyDialog.this.btnStop.setEnabled(false);
                MobileObjectSpyDialog.this.btnCapture.setEnabled(false);
            }
        };
        try {
            this.inspectorController.setStreamHandler(progressDlg);
            if (this.stackLayout.topControl == this.localAppComposite && !this.localAppComposite.startLocalApp(this.inspectorController, (ProgressMonitorDialogWithThread)progressDlg)) {
                this.btnStart.setEnabled(true);
                return;
            }
            if (this.stackLayout.topControl == this.kobitonAppComposite && !this.kobitonAppComposite.startKobitonApp(this.inspectorController, (ProgressMonitorDialogWithThread)progressDlg)) {
                this.btnStart.setEnabled(true);
                return;
            }
            this.captureObjectAction();
            this.btnCapture.setEnabled(true);
            this.btnStop.setEnabled(true);
            Trackings.trackSpy((String)"mobile");
        }
        catch (InterruptedException | InvocationTargetException ex) {
            if (ex instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)ex).getTargetException();
                String message = targetException instanceof ExecutionException ? targetException.getCause().getMessage() : targetException.getMessage();
                MessageDialogWithLink.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)(String.valueOf(StringConstants.DIA_ERROR_MSG_CANNOT_START_APP_ON_CURRENT_DEVICE) + ": " + message + "\n<a href=\"" + StringConstants.URL_TROUBLESHOOTING_MOBILE_TESTING + "\">" + StringConstants.APPIUM_INSTALLATION_GUIDE_MSG + "</a>"));
                LoggerSingleton.logError((Throwable)targetException);
            }
            this.btnStart.setEnabled(true);
            this.btnStop.setEnabled(false);
            this.btnCapture.setEnabled(false);
        }
    }

    private void stopObjectInspectorAction() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                MobileObjectSpyDialog.this.inspectorController.closeApp();
            }
        });
        thread.start();
        if (!this.getShell().isDisposed()) {
            this.btnStart.setEnabled(true);
            this.btnStop.setEnabled(false);
            this.btnCapture.setEnabled(false);
            if (this.allElementTreeViewer != null) {
                this.allElementTreeViewer.setInput((Object)new Object[0]);
                this.allElementTreeViewer.refresh();
            }
        }
        if (this.deviceView != null) {
            this.deviceView.closeApp();
        }
        this.dispose();
    }

    private boolean validateAppSetting() {
        if (this.cbbAppType.getSelectionIndex() < 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.DIA_ERROR_MSG_PLS_SELECT_APP_TYPE);
            return false;
        }
        if (this.stackLayout.topControl == this.localAppComposite) {
            return this.localAppComposite.validateLocalAppSetting();
        }
        if (this.stackLayout.topControl == this.kobitonAppComposite) {
            return this.kobitonAppComposite.validateKobitonAppSetting();
        }
        return false;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x40 | 0x800 | 0x20);
        this.setBlockOnOpen(false);
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    public boolean close() {
        this.stopObjectInspectorAction();
        try {
            this.preferencesHelper.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        boolean result = super.close();
        Trackings.trackCloseSpy((String)"mobile");
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle displayBounds = this.getShell().getMonitor().getBounds();
        return new Point(this.calculateObjectSpyDialogStartX(displayBounds, initialSize), this.calculateObjectSpyDialogStartY(displayBounds, initialSize));
    }

    private void setDeviceView(MobileDeviceDialog deviceView) {
        this.deviceView = deviceView;
    }

    public void addElements(List<WebElementEntity> webElements) {
        if (webElements == null) {
            return;
        }
        CapturedMobileElementConverter converter = new CapturedMobileElementConverter();
        ArrayList<CapturedMobileElement> newMobileElements = new ArrayList<CapturedMobileElement>();
        for (WebElementEntity webElement : webElements) {
            newMobileElements.add(converter.revert(webElement));
        }
        this.capturedObjectsTableViewer.addMobileElements(newMobileElements);
        this.verifyCapturedElementsStates(this.capturedObjectsTableViewer.getSelectedElements());
    }
}

