/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.dialog;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.mobile.objectspy.constant.StringConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumStreamHandler;
import com.kms.katalon.composer.mobile.objectspy.element.TreeMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.AndroidSnapshotMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.IosSnapshotMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.IosXCUISnapshotMobileElement;
import com.kms.katalon.composer.mobile.objectspy.util.Util;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.appium.driver.AppiumDriverManager;
import com.kms.katalon.core.appium.exception.AppiumStartException;
import com.kms.katalon.core.appium.exception.IOSWebkitStartException;
import com.kms.katalon.core.appium.exception.MobileDriverInitializeException;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.internal.ProcessUtil;
import com.kms.katalon.execution.configuration.IExecutionSetting;
import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.mobile.device.AndroidDeviceInfo;
import com.kms.katalon.execution.mobile.device.IosDeviceInfo;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.execution.mobile.driver.AndroidDriverConnector;
import com.kms.katalon.execution.mobile.driver.IosDriverConnector;
import com.kms.katalon.execution.mobile.driver.MobileDriverConnector;
import com.kms.katalon.execution.mobile.exception.AndroidSetupException;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.integration.kobiton.driver.KobitonDriverConnector;
import com.kms.katalon.integration.kobiton.entity.KobitonApplication;
import com.kms.katalon.integration.kobiton.entity.KobitonDevice;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.ios.IOSDriver;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrMatcher;
import org.json.JSONObject;
import org.openqa.selenium.OutputType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MobileInspectorController {
    private static final int SERVER_START_TIMEOUT = 60;
    private AppiumDriver<?> driver;
    private Process appiumServerProcess;
    private Process iosWebKitProcess;
    private AppiumStreamHandler streamHandler;
    private Thread appiumTailerThread;

    public void startMobileApp(MobileDeviceInfo mobileDeviceInfo, String appFile, boolean uninstallAfterCloseApp) throws com.kms.katalon.execution.exception.ExecutionException, InterruptedException, IOException, AppiumStartException, MobileDriverInitializeException, IOSWebkitStartException {
        if (mobileDeviceInfo == null) {
            return;
        }
        if (this.driver != null) {
            this.closeApp();
            Thread.sleep(2000L);
        }
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        MobileDriverType mobileDriverType = MobileInspectorController.getMobileDriverType(mobileDeviceInfo);
        if (mobileDriverType == null) {
            throw new com.kms.katalon.execution.exception.ExecutionException(StringConstants.DIA_ERROR_MSG_OS_NOT_SUPPORT);
        }
        MobileDriverConnector mobileDriverConnector = MobileInspectorController.getMobileDriverConnector(mobileDriverType, projectDir);
        if (mobileDriverConnector == null) {
            throw new com.kms.katalon.execution.exception.ExecutionException(StringConstants.DIA_ERROR_MSG_OS_NOT_SUPPORT);
        }
        mobileDriverConnector = (MobileDriverConnector)mobileDriverConnector.clone();
        mobileDriverConnector.setDevice(mobileDeviceInfo);
        HashMap<String, MobileDriverConnector> driverConnectors = new HashMap<String, MobileDriverConnector>(2);
        driverConnectors.put("Mobile", mobileDriverConnector);
        String logFilePath = String.valueOf(projectDir) + File.separator + "appium.log";
        RunConfiguration.setAppiumLogFilePath((String)logFilePath);
        DefaultExecutionSetting generalExecutionSetting = new DefaultExecutionSetting();
        generalExecutionSetting.setTimeout(60);
        RunConfiguration.setExecutionSetting((Map)ExecutionUtil.getExecutionProperties((IExecutionSetting)generalExecutionSetting, driverConnectors, null));
        if (!AppiumDriverManager.isAppiumServerStarted((int)1)) {
            this.createAppiumLogTailer(logFilePath);
        }
        mobileDeviceInfo.updateRuntimeEnvironmentVariables();
        AppiumDriverManager.startAppiumServerJS((int)60, this.getAdditionalEnvironmentVariables(mobileDriverType));
        this.driver = MobileDriverFactory.startMobileDriver((MobileDriverType)mobileDriverType, (String)mobileDeviceInfo.getDeviceId(), (String)mobileDeviceInfo.getDeviceName(), (String)appFile, (boolean)uninstallAfterCloseApp);
        this.appiumServerProcess = AppiumDriverManager.getAppiumSeverProcess();
        this.iosWebKitProcess = AppiumDriverManager.getIosWebKitProcess();
    }

    private void createAppiumLogTailer(String logFilePath) {
        this.appiumTailerThread = new Thread((Runnable)new Tailer(new File(logFilePath), (TailerListener)new TailerListenerAdapter(){

            public void handle(String line) {
                if (MobileInspectorController.this.streamHandler != null) {
                    MobileInspectorController.this.streamHandler.handleOutput(line);
                }
            }
        }, 100L, true));
        this.appiumTailerThread.start();
    }

    private void closeAppiumTailerThread() {
        if (this.appiumTailerThread != null && this.appiumTailerThread.isAlive()) {
            this.appiumTailerThread.interrupt();
        }
        this.appiumTailerThread = null;
    }

    public void startMobileApp(KobitonDevice kobitonDevice, KobitonApplication kobitonApplication) throws InterruptedException, IOException, AppiumStartException, MobileDriverInitializeException {
        if (kobitonDevice == null || kobitonApplication == null) {
            return;
        }
        if (this.driver != null) {
            this.closeApp();
            Thread.sleep(2000L);
        }
        KobitonDriverConnector connector = new KobitonDriverConnector(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        connector.setKobitonDevice(kobitonDevice);
        connector.setApiKey(KobitonPreferencesProvider.getKobitonApiKey());
        connector.setUserName(KobitonPreferencesProvider.getKobitonUserName());
        HashMap<String, KobitonDriverConnector> driverConnectors = new HashMap<String, KobitonDriverConnector>(2);
        driverConnectors.put("Mobile", connector);
        driverConnectors.put("WebUI", connector);
        DefaultExecutionSetting generalExecutionSetting = new DefaultExecutionSetting();
        generalExecutionSetting.setTimeout(60);
        RunConfiguration.setExecutionSetting((Map)ExecutionUtil.getExecutionProperties((IExecutionSetting)generalExecutionSetting, driverConnectors, null));
        this.driver = MobileDriverFactory.startMobileDriver((MobileDriverType)MobileInspectorController.getMobileDriverType(kobitonDevice), null, (String)kobitonDevice.getCapabilities().getDeviceName(), (String)kobitonApplication.buildAutomationKey(), (boolean)false);
    }

    public static MobileDriverType getMobileDriverType(KobitonDevice kobitonDevice) {
        if (kobitonDevice == null || kobitonDevice.getCapabilities() == null) {
            return null;
        }
        if ("iOS".equals(kobitonDevice.getCapabilities().getPlatformName())) {
            return MobileDriverType.IOS_DRIVER;
        }
        if ("Android".equals(kobitonDevice.getCapabilities().getPlatformName())) {
            return MobileDriverType.ANDROID_DRIVER;
        }
        return null;
    }

    public AppiumDriver<?> getDriver() {
        return this.driver;
    }

    private Map<String, String> getAdditionalEnvironmentVariables(MobileDriverType mobileDriverType) throws IOException, InterruptedException, AndroidSetupException {
        if (mobileDriverType == MobileDriverType.ANDROID_DRIVER) {
            return AndroidDeviceInfo.getAndroidAdditionalEnvironmentVariables();
        }
        if (mobileDriverType == MobileDriverType.IOS_DRIVER) {
            return IosDeviceInfo.getIosAdditionalEnvironmentVariables();
        }
        return new HashMap<String, String>();
    }

    public static MobileDriverType getMobileDriverType(MobileDeviceInfo mobileDeviceInfo) {
        if (mobileDeviceInfo == null) {
            return null;
        }
        if (mobileDeviceInfo instanceof AndroidDeviceInfo) {
            return MobileDriverType.ANDROID_DRIVER;
        }
        if (mobileDeviceInfo instanceof IosDeviceInfo) {
            return MobileDriverType.IOS_DRIVER;
        }
        return null;
    }

    private static MobileDriverConnector getMobileDriverConnector(MobileDriverType mobileDriverType, String projectDirectory) throws IOException {
        switch (mobileDriverType) {
            case ANDROID_DRIVER: {
                return new AndroidDriverConnector(MobileInspectorController.getInternalSettingFolder(projectDirectory));
            }
            case IOS_DRIVER: {
                return new IosDriverConnector(MobileInspectorController.getInternalSettingFolder(projectDirectory));
            }
        }
        return null;
    }

    private static String getInternalSettingFolder(String projectDirectory) {
        return String.valueOf(projectDirectory) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME;
    }

    public boolean closeApp() {
        try {
            if (this.driver != null && this.driver.getSessionId() != null) {
                this.driver.quit();
            }
            if (this.appiumServerProcess != null && this.appiumServerProcess.isAlive()) {
                ProcessUtil.terminateProcess((Process)this.appiumServerProcess);
            }
            if (this.iosWebKitProcess != null && this.iosWebKitProcess.isAlive()) {
                ProcessUtil.terminateProcess((Process)this.iosWebKitProcess);
            }
            this.closeAppiumTailerThread();
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            this.driver = null;
            this.appiumServerProcess = null;
            this.iosWebKitProcess = null;
        }
    }

    public String captureScreenshot() throws Exception {
        String screenshotFolder = Util.getDefaultMobileScreenshotPath();
        File screenshot = (File)this.driver.getScreenshotAs(OutputType.FILE);
        if (!screenshot.exists()) {
            throw new Exception(StringConstants.DIA_ERROR_MSG_UNABLE_TO_CAPTURE_SCREEN);
        }
        String fileName = new String("screenshot_" + new Date().getTime() + ".jpg");
        String path = String.valueOf(screenshotFolder) + System.getProperty("file.separator") + fileName;
        FileUtils.copyFile((File)screenshot, (File)new File(path));
        try {
            FileUtils.forceDelete((File)screenshot);
        }
        catch (Exception exception) {}
        return path;
    }

    public TreeMobileElement getMobileObjectRoot() {
        try {
            InputSource is;
            if (this.driver instanceof IOSDriver) {
                return this.getIosObjectRoot();
            }
            String pageSource = this.driver.getPageSource();
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = null;
            try {
                is = new InputSource();
                is.setCharacterStream(new StringReader(pageSource));
                doc = db.parse(is);
            }
            catch (SAXParseException sAXParseException) {
                is = new InputSource();
                is.setCharacterStream(new StringReader(MobileInspectorController.removeEscapeCharacter(pageSource)));
                doc = db.parse(is);
            }
            Element rootElement = doc.getDocumentElement();
            AndroidSnapshotMobileElement htmlMobileElementRootNode = new AndroidSnapshotMobileElement();
            htmlMobileElementRootNode.getAttributes().put("class", rootElement.getTagName());
            htmlMobileElementRootNode.render(rootElement);
            return htmlMobileElementRootNode;
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            return null;
        }
    }

    public static String removeEscapeCharacter(String contentBuilder) {
        String pattern = "(\\\"([^=])*\\\")";
        Pattern pattern2 = Pattern.compile(pattern);
        Matcher matcher = pattern2.matcher(contentBuilder);
        StrBuilder sb = new StrBuilder(contentBuilder);
        while (matcher.find()) {
            String str = matcher.group(1).substring(1, matcher.group(1).length() - 1);
            sb = sb.replaceFirst(StrMatcher.stringMatcher((String)str), StringEscapeUtils.escapeXml((String)str));
        }
        return sb.toString();
    }

    private TreeMobileElement getIosObjectRoot() throws ParserConfigurationException, SAXException, IOException {
        try {
            if (AppiumDriverManager.getXCodeVersion() >= 8) {
                return this.getXCUIObjectRoot();
            }
        }
        catch (ExecutionException executionException) {
            return this.getXCUIObjectRoot();
        }
        Map map = (Map)this.driver.executeScript("UIATarget.localTarget().frontMostApp().getTree()", new Object[0]);
        JSONObject jsonObject = new JSONObject(map);
        IosSnapshotMobileElement htmlMobileElementRootNode = new IosSnapshotMobileElement();
        htmlMobileElementRootNode.render(jsonObject);
        return htmlMobileElementRootNode;
    }

    private TreeMobileElement getXCUIObjectRoot() throws ParserConfigurationException, SAXException, IOException {
        String pageSource = this.driver.getPageSource();
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(pageSource));
        Document doc = db.parse(is);
        Element rootElement = doc.getDocumentElement();
        Element appElement = null;
        NodeList childElementNodes = rootElement.getChildNodes();
        int count = childElementNodes.getLength();
        int i = 0;
        while (i < count) {
            Node node = childElementNodes.item(i);
            if (node instanceof Element) {
                appElement = (Element)node;
            }
            ++i;
        }
        if (appElement == null) {
            return null;
        }
        IosXCUISnapshotMobileElement htmlMobileElementRootNode = new IosXCUISnapshotMobileElement();
        htmlMobileElementRootNode.getAttributes().put("type", appElement.getTagName());
        htmlMobileElementRootNode.render(appElement);
        return htmlMobileElementRootNode;
    }

    public AppiumStreamHandler getStreamHandler() {
        return this.streamHandler;
    }

    public void setStreamHandler(AppiumStreamHandler streamHandler) {
        this.streamHandler = streamHandler;
    }
}

