/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.dialog;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.mobile.objectspy.constant.StringConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileObjectSpyDialog;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MobileElementPropertiesComposite {
    private Text txtObjectName;
    private CapturedMobileElement editingElement;
    private TableViewer attributesTableViewer;
    private MobileObjectSpyDialog dialog;

    public MobileElementPropertiesComposite(MobileObjectSpyDialog dialog) {
        this.dialog = dialog;
    }

    public void setEditingElement(CapturedMobileElement editingElement) {
        this.editingElement = editingElement;
        this.refreshAttributesTable();
    }

    public void createObjectPropertiesComposite(Composite parent) {
        Composite objectPropertiesComposite = new Composite(parent, 0);
        GridLayout glObjectPropertiesComposite = new GridLayout(2, false);
        glObjectPropertiesComposite.horizontalSpacing = 10;
        objectPropertiesComposite.setLayout((Layout)glObjectPropertiesComposite);
        Label lblObjectProperties = new Label(objectPropertiesComposite, 0);
        lblObjectProperties.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ControlUtils.setFontToBeBold((Control)lblObjectProperties);
        lblObjectProperties.setText(StringConstants.DIA_LBL_OBJECT_PROPERTIES);
        Label objectNameLabel = new Label(objectPropertiesComposite, 0);
        GridData gdObjectNameLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdObjectNameLabel.widthHint = 90;
        objectNameLabel.setLayoutData((Object)gdObjectNameLabel);
        objectNameLabel.setText(StringConstants.DIA_LBL_OBJECT_NAME);
        this.txtObjectName = new Text(objectPropertiesComposite, 2048);
        this.txtObjectName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtObjectName.setToolTipText(StringConstants.DIA_TOOLTIP_OBJECT_NAME);
        Composite attributesTableComposite = new Composite(objectPropertiesComposite, 0);
        attributesTableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        attributesTableComposite.setLayout((Layout)tableColumnLayout);
        this.attributesTableViewer = new CTableViewer(attributesTableComposite, 68354);
        this.createColumns(this.attributesTableViewer, tableColumnLayout);
        Table attributesTable = this.attributesTableViewer.getTable();
        attributesTable.setHeaderVisible(true);
        attributesTable.setLinesVisible(true);
        this.attributesTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.attributesTableViewer.setInput(Collections.emptyList());
        this.registerControlModifyListeners();
    }

    private void commitEditingName() {
        if (this.editingElement == null || this.txtObjectName.isDisposed()) {
            return;
        }
        String objectName = this.txtObjectName.getText();
        if (StringUtils.isNotBlank((String)objectName) && !StringUtils.equals((String)this.editingElement.getName(), (String)objectName)) {
            this.editingElement.setName(objectName);
            this.dialog.updateSelectedElement(this.editingElement);
        }
    }

    private void registerControlModifyListeners() {
        this.txtObjectName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                MobileElementPropertiesComposite.this.commitEditingName();
            }
        });
        this.txtObjectName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (MobileElementPropertiesComposite.this.editingElement == null) {
                    return;
                }
                int keyCode = e.keyCode;
                switch (keyCode) {
                    case 13: 
                    case 0x1000050: {
                        MobileElementPropertiesComposite.this.commitEditingName();
                    }
                }
            }
        });
        this.attributesTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                StructuredSelection selection = (StructuredSelection)MobileElementPropertiesComposite.this.attributesTableViewer.getSelection();
                if (selection == null || selection.isEmpty()) {
                    return;
                }
                if (e.keyCode == 127) {
                    Map<String, String> allAttributes = MobileElementPropertiesComposite.this.editingElement.getAttributes();
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selectedEntry = objectArray[n2];
                        allAttributes.remove(((Map.Entry)selectedEntry).getKey());
                        ++n2;
                    }
                    MobileElementPropertiesComposite.this.refreshAttributesTable();
                }
            }
        });
    }

    private void createColumns(TableViewer viewer, TableColumnLayout tableColumnLayout) {
        TableViewerColumn keyColumn = new TableViewerColumn(this.attributesTableViewer, 0);
        keyColumn.getColumn().setText(StringConstants.DIA_COL_NAME);
        keyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return MobileElementPropertiesComposite.this.getTextForEntryKey(element);
            }
        });
        TableViewerColumn valueColumn = new TableViewerColumn(this.attributesTableViewer, 0);
        valueColumn.getColumn().setText(StringConstants.DIA_COL_VALUE);
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return MobileElementPropertiesComposite.this.getTextForEntryValue(element);
            }
        });
        valueColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.attributesTableViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof Map.Entry && value instanceof String) {
                    Map.Entry entry = (Map.Entry)element;
                    entry.setValue(String.valueOf(value));
                    MobileElementPropertiesComposite.this.attributesTableViewer.refresh(element);
                }
            }

            protected Object getValue(Object element) {
                return MobileElementPropertiesComposite.this.getTextForEntryValue(element);
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof Map.Entry) {
                    return new TextCellEditor((Composite)MobileElementPropertiesComposite.this.attributesTableViewer.getTable());
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof Map.Entry;
            }
        });
        tableColumnLayout.setColumnData((Widget)keyColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100, true));
        tableColumnLayout.setColumnData((Widget)valueColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(80, 150, true));
    }

    private String getTextForEntryKey(Object element) {
        if (!(element instanceof Map.Entry)) {
            return "";
        }
        Map.Entry entry = (Map.Entry)element;
        String entryKey = (String)entry.getKey();
        if (entryKey != null) {
            return entryKey.toString();
        }
        return "";
    }

    private String getTextForEntryValue(Object element) {
        if (!(element instanceof Map.Entry)) {
            return "";
        }
        Map.Entry entry = (Map.Entry)element;
        String entryValue = (String)entry.getValue();
        if (entryValue != null) {
            return entryValue.toString();
        }
        return "";
    }

    private void refreshAttributesTable() {
        if (this.attributesTableViewer == null || this.attributesTableViewer.getTable().isDisposed()) {
            return;
        }
        if (this.editingElement != null) {
            this.txtObjectName.setText(this.editingElement.getName());
            this.attributesTableViewer.setInput(new ArrayList<Map.Entry<String, String>>(this.editingElement.getAttributes().entrySet()));
        } else {
            this.txtObjectName.setText("");
            this.attributesTableViewer.setInput(Collections.emptyList());
        }
        this.attributesTableViewer.refresh();
    }

    void focusAndEditCapturedElementName() {
        this.txtObjectName.setFocus();
        this.txtObjectName.selectAll();
    }
}

