/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.dialog;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.mobile.objectspy.constant.StringConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileElementInspectorDialog;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class MobileDeviceDialog
extends Dialog {
    private static final String DIALOG_TITLE = StringConstants.DIA_DIALOG_TITLE_DEVICE_VIEW;
    private Image currentScreenShot;
    private Composite swtAwtContainter;
    public static final int DIALOG_WIDTH = 400;
    public static final int DIALOG_HEIGHT = 600;
    private double currentX = 0.0;
    private double currentY = 0.0;
    private double currentWidth = 0.0;
    private double currentHeight = 0.0;
    private double hRatio;
    private JLabel scrImage;
    private ImageIcon icon;
    private Frame frame;
    private boolean isDisposed;
    private Point initialLocation;
    private MobileElementInspectorDialog mobileInspetorDialog;
    private ScrolledComposite scrolledComposite;

    public MobileDeviceDialog(Shell parentShell, MobileElementInspectorDialog mobileInspectorDialog, Point location) {
        super(parentShell);
        this.mobileInspetorDialog = mobileInspectorDialog;
        this.initialLocation = location;
        this.setShellStyle(1268);
        this.isDisposed = false;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout dialogAreaGridLayout = (GridLayout)dialogArea.getLayout();
        dialogAreaGridLayout.marginWidth = 0;
        dialogAreaGridLayout.marginHeight = 0;
        this.scrolledComposite = new ScrolledComposite(dialogArea, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setLayout((Layout)new GridLayout());
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite container = new Composite((Composite)this.scrolledComposite, 0);
        GridLayout compositeGridLayout = new GridLayout();
        compositeGridLayout.marginHeight = 0;
        compositeGridLayout.marginWidth = 0;
        container.setLayout((Layout)compositeGridLayout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setContent((Control)container);
        this.swtAwtContainter = new Composite(container, 0x1000000);
        this.swtAwtContainter.setBackground(ColorUtil.getBlackBackgroundColor());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.swtAwtContainter.setLayout((Layout)new GridLayout());
        this.swtAwtContainter.setLayoutData((Object)new GridData(4, 4, true, true));
        this.frame = SWT_AWT.new_Frame((Composite)this.swtAwtContainter);
        this.scrImage = new JLabel();
        this.scrImage.setHorizontalAlignment(2);
        this.scrImage.setVerticalAlignment(1);
        this.scrImage.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                MobileDeviceDialog.this.inspectElementAt(e.getX(), e.getY());
            }
        });
        if (Platform.getOS().equals("macosx")) {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            this.frame.add((Component)panel, "Center");
            panel.add((Component)this.scrImage, "Center");
        } else {
            this.frame.add(this.scrImage);
        }
        this.frame.pack();
        this.swtAwtContainter.pack();
        return dialogArea;
    }

    protected boolean isResizable() {
        return true;
    }

    private void inspectElementAt(int x, int y) {
        Double realX = (double)x / this.hRatio;
        Double realY = (double)y / this.hRatio;
        this.mobileInspetorDialog.setSelectedElementByLocation(MobileDeviceDialog.safeRoundDouble(realX), MobileDeviceDialog.safeRoundDouble(realY));
    }

    private boolean isElementOnScreen(Double x, Double y, Double width, Double height) {
        Rectangle elementRect = new Rectangle(x.intValue(), y.intValue(), width.intValue(), height.intValue());
        return elementRect.intersects(this.getCurrentViewportRect());
    }

    private void scrollToElement(Double x, Double y) {
        Rectangle elementRect = new Rectangle(x.intValue(), y.intValue());
        this.scrolledComposite.setOrigin(elementRect.x, elementRect.y);
    }

    private Rectangle getCurrentViewportRect() {
        ScrollBar verticalBar = this.scrolledComposite.getVerticalBar();
        ScrollBar horizontalBar = this.scrolledComposite.getHorizontalBar();
        int viewPortY = verticalBar.isVisible() ? verticalBar.getSelection() : 0;
        int viewPortX = horizontalBar.isVisible() ? horizontalBar.getSelection() : 0;
        Point viewPortSize = this.scrolledComposite.getSize();
        Rectangle viewPortRect = new Rectangle(viewPortX, viewPortY, viewPortSize.x, viewPortSize.y);
        return viewPortRect;
    }

    public void highlight(double x, double y, double width, double height) {
        this.currentX = x * this.hRatio;
        this.currentY = y * this.hRatio;
        this.currentWidth = width * this.hRatio;
        this.currentHeight = height * this.hRatio;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!MobileDeviceDialog.this.isElementOnScreen(MobileDeviceDialog.this.currentX, MobileDeviceDialog.this.currentY, MobileDeviceDialog.this.currentWidth, MobileDeviceDialog.this.currentHeight)) {
                    MobileDeviceDialog.this.scrollToElement(MobileDeviceDialog.this.currentX, MobileDeviceDialog.this.currentY);
                }
            }
        });
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                JLabel c = MobileDeviceDialog.this.scrImage;
                JLabel label = new JLabel();
                label.setOpaque(false);
                label.setBorder(BorderFactory.createLineBorder(Color.green, 2));
                label.setBounds(MobileDeviceDialog.safeRoundDouble(MobileDeviceDialog.this.currentX), MobileDeviceDialog.safeRoundDouble(MobileDeviceDialog.this.currentY), MobileDeviceDialog.safeRoundDouble(MobileDeviceDialog.this.currentWidth), MobileDeviceDialog.safeRoundDouble(MobileDeviceDialog.this.currentHeight));
                int i = 0;
                while (i < 5) {
                    c.add(label);
                    c.revalidate();
                    c.repaint();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    c.remove(label);
                    c.revalidate();
                    c.repaint();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++i;
                }
            }
        });
        thread.start();
    }

    private Image scaleImage(Image image, double newWidth, double newHeight) {
        Image scaled = new Image((Device)Display.getDefault(), MobileDeviceDialog.safeRoundDouble(newWidth), MobileDeviceDialog.safeRoundDouble(newHeight));
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, MobileDeviceDialog.safeRoundDouble(newWidth), MobileDeviceDialog.safeRoundDouble(newHeight));
        gc.dispose();
        image.dispose();
        return scaled;
    }

    protected Point getInitialSize() {
        return new Point(400, 657);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
        if (Platform.getOS().equals("macosx")) {
            shell.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    MobileDeviceDialog.this.refreshViewForMac();
                }
            });
        }
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(2160);
        this.setBlockOnOpen(false);
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    public void closeApp() {
        this.handleShellCloseEvent();
    }

    public void highlightElement(MobileElement selectedElement) {
        Map<String, String> attributes = selectedElement.getAttributes();
        if (!(attributes != null && attributes.containsKey("x") && attributes.containsKey("y") && attributes.containsKey("width") && attributes.containsKey("height"))) {
            return;
        }
        double x = Double.parseDouble(attributes.get("x"));
        double y = Double.parseDouble(attributes.get("y"));
        double w = Double.parseDouble(attributes.get("width"));
        double h = Double.parseDouble(attributes.get("height"));
        this.highlight(x, y, w, h);
    }

    public void refreshDialog(File imageFile, MobileElement root) {
        try {
            String userTempDir = System.getProperty("java.io.tmpdir");
            ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)imageFile.toURI().toURL());
            Image img = imgDesc.createImage();
            this.hRatio = 600.0 / (double)img.getBounds().height;
            this.currentScreenShot = this.scaleImage(img, (double)img.getBounds().width * this.hRatio, 600.0);
            String scaledImageFile = String.valueOf(userTempDir) + File.separator + UUID.randomUUID() + "_scaled2.png";
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{this.currentScreenShot.getImageData()};
            loader.save(scaledImageFile, 5);
            this.icon = new ImageIcon(scaledImageFile);
            this.scrImage.setIcon(this.icon);
            this.scrImage.revalidate();
            this.scrImage.repaint();
            if (Platform.getOS().equals("macosx")) {
                this.refreshViewForMac();
                return;
            }
            this.refreshView();
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void refreshView() {
        if (this.scrolledComposite == null || this.icon == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MobileDeviceDialog.this.scrolledComposite.setMinSize(MobileDeviceDialog.this.icon.getIconWidth(), MobileDeviceDialog.this.icon.getIconHeight());
            }
        });
    }

    private void refreshViewForMac() {
        if (this.scrolledComposite == null || this.icon == null || this.frame == null) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MobileDeviceDialog.this.scrolledComposite.setMinSize(MobileDeviceDialog.this.icon.getIconWidth(), MobileDeviceDialog.this.icon.getIconHeight());
            }
        });
        this.frame.pack();
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.dispose();
    }

    public void dispose() {
        this.isDisposed = true;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    protected Point getInitialLocation(Point initialSize) {
        if ((this.getShell().getStyle() & 0x10) == 0) {
            return new Point(this.initialLocation.x, this.initialLocation.y + 5);
        }
        return this.initialLocation;
    }

    public static int safeRoundDouble(double d) {
        long rounded = Math.round(d);
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, rounded));
    }
}

