/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.components;

import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.execution.util.MobileDeviceUIProvider;
import com.kms.katalon.composer.mobile.objectspy.constant.StringConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileAppDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileInspectorController;
import com.kms.katalon.composer.mobile.objectspy.preferences.MobileObjectSpyPreferencesHelper;
import com.kms.katalon.execution.mobile.device.AndroidDeviceInfo;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LocalAppComposite
extends Composite {
    private String ANDROID_FILTER_NAMES = "Android Application (*.apk)";
    private String ANDROID_FILTER_EXTS = "*.apk";
    private String IOS_FILTER_NAMES = "iOS Application (*.app, *.ipa)";
    private String IOS_FILTER_EXTS = "*.app;*.ipa";
    private MobileAppDialog parentDialog;
    private MobileObjectSpyPreferencesHelper preferencesHelper;
    private Combo cbbDevices;
    private Button btnBrowse;
    private Button btnRefreshDevice;
    private Text txtAppFile;
    private List<MobileDeviceInfo> deviceInfos = new ArrayList<MobileDeviceInfo>();
    private MobileDeviceInfo selectedDevice = null;
    private Link linkLabel;

    public LocalAppComposite(Composite parent, MobileAppDialog parentDialog, MobileObjectSpyPreferencesHelper preferencesHelper, int style) {
        super(parent, style);
        this.parentDialog = parentDialog;
        this.preferencesHelper = preferencesHelper;
        this.initComponent();
    }

    private void initComponent() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Composite deviceNameCompposite = new Composite((Composite)this, 0);
        GridLayout deviceNameComppositeLayout = new GridLayout(3, false);
        deviceNameComppositeLayout.marginHeight = 0;
        deviceNameComppositeLayout.marginWidth = 0;
        deviceNameCompposite.setLayout((Layout)deviceNameComppositeLayout);
        deviceNameCompposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDeviceName = new Label(deviceNameCompposite, 0);
        lblDeviceName.setText(StringConstants.DIA_LBL_DEVICE_NAME);
        this.cbbDevices = new Combo(deviceNameCompposite, 8);
        this.cbbDevices.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cbbDevices.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalAppComposite.this.parentDialog.refreshButtonsState();
            }
        });
        this.btnRefreshDevice = new Button(deviceNameCompposite, 0x800000);
        this.btnRefreshDevice.setText(StringConstants.REFRESH);
        this.btnRefreshDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalAppComposite.this.parentDialog.updateDeviceNames();
            }
        });
        this.linkLabel = new Link((Composite)this, 0);
        this.linkLabel.setText(String.valueOf(StringConstants.MSG_NO_DEVICES) + " <a href=\"" + StringConstants.NO_DEVICES_TROUBLESHOOTING_GUIDE_LINK + "\">" + StringConstants.MSG_WRAPPED_NO_DEVICES_TROUBLESHOOTING_GUIDE + "</a>");
        this.linkLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)e.text);
            }
        });
        this.linkLabel.setVisible(false);
        Composite appFileChooserComposite = new Composite((Composite)this, 0);
        appFileChooserComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glAppFileChooserComposite = new GridLayout(3, false);
        glAppFileChooserComposite.marginHeight = 0;
        glAppFileChooserComposite.marginWidth = 0;
        appFileChooserComposite.setLayout((Layout)glAppFileChooserComposite);
        Label appFileLabel = new Label(appFileChooserComposite, 0);
        appFileLabel.setText(StringConstants.DIA_LBL_APP_FILE);
        this.txtAppFile = new Text(appFileChooserComposite, 2056);
        this.txtAppFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtAppFile.setText(this.preferencesHelper.getLastAppFile());
        this.txtAppFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalAppComposite.this.parentDialog.refreshButtonsState();
            }
        });
        this.btnBrowse = new Button(appFileChooserComposite, 8);
        GridData btnBrowserGridData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.btnBrowse.setLayoutData((Object)btnBrowserGridData);
        this.btnBrowse.setText(StringConstants.DIA_BTN_BROWSE);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(LocalAppComposite.this.btnBrowse.getShell());
                dialog.setFilterNames(LocalAppComposite.this.getFilterNames());
                dialog.setFilterExtensions(LocalAppComposite.this.getFilterExtensions());
                String absolutePath = dialog.open();
                if (StringUtils.isEmpty((String)absolutePath)) {
                    return;
                }
                LocalAppComposite.this.preferencesHelper.setLastAppFile(absolutePath);
                LocalAppComposite.this.txtAppFile.setText(absolutePath);
            }
        });
    }

    private String[] getFilterNames() {
        if (StringUtils.equals((String)Platform.getOS(), (String)"macosx")) {
            return new String[]{this.ANDROID_FILTER_NAMES, this.IOS_FILTER_NAMES};
        }
        return new String[]{this.ANDROID_FILTER_NAMES};
    }

    private String[] getFilterExtensions() {
        if (StringUtils.equals((String)Platform.getOS(), (String)"macosx")) {
            return new String[]{this.ANDROID_FILTER_EXTS, this.IOS_FILTER_EXTS};
        }
        return new String[]{this.ANDROID_FILTER_EXTS};
    }

    public boolean isAbleToStart() {
        return StringUtils.isNotBlank((String)this.getAppFile()) && this.cbbDevices.getSelectionIndex() >= 0;
    }

    public void updateLocalDevices() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(StringConstants.DIA_JOB_TASK_LOADING_DEVICES, -1);
                LocalAppComposite.this.updateDeviceList();
                final List devices = LocalAppComposite.this.getAllDevicesName();
                LocalAppComposite.this.checkMonitorCanceled(monitor);
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!devices.isEmpty()) {
                            LocalAppComposite.this.cbbDevices.setItems(devices.toArray(new String[0]));
                            LocalAppComposite.this.cbbDevices.select(Math.max(0, devices.indexOf(LocalAppComposite.this.cbbDevices.getText())));
                        }
                        LocalAppComposite.this.setLinkLabelVisible(devices.isEmpty());
                    }
                });
                monitor.done();
            }
        };
        new ProgressMonitorDialogWithThread(Display.getDefault().getActiveShell()).run(true, true, runnable);
    }

    private void checkMonitorCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException(StringConstants.DIA_ERROR_MSG_OPERATION_CANCELED);
        }
    }

    private List<String> getAllDevicesName() {
        ArrayList<String> devicesNameList = new ArrayList<String>();
        for (MobileDeviceInfo deviceInfo : this.deviceInfos) {
            devicesNameList.add(deviceInfo.getDisplayName());
        }
        return devicesNameList;
    }

    private void updateDeviceList() {
        this.deviceInfos.clear();
        this.deviceInfos.addAll(MobileDeviceUIProvider.getAllDevices());
    }

    public String getAppName() {
        return FilenameUtils.getName((String)this.getAppFile());
    }

    public String getAppFile() {
        return this.txtAppFile.getText();
    }

    public MobileDeviceInfo getSelectedMobileDeviceInfo() {
        if (this.cbbDevices == null || this.cbbDevices.isDisposed()) {
            return this.selectedDevice;
        }
        int selectedMobileDeviceIndex = this.cbbDevices.getSelectionIndex();
        if (selectedMobileDeviceIndex < 0 || selectedMobileDeviceIndex >= this.deviceInfos.size()) {
            this.selectedDevice = null;
            return this.selectedDevice;
        }
        this.selectedDevice = this.deviceInfos.get(selectedMobileDeviceIndex);
        return this.selectedDevice;
    }

    public boolean startLocalApp(final MobileInspectorController inspectorController, final ProgressMonitorDialogWithThread progressDlg) throws InvocationTargetException, InterruptedException {
        final MobileDeviceInfo selectDeviceInfo = this.getSelectedMobileDeviceInfo();
        if (selectDeviceInfo == null) {
            return false;
        }
        if (selectDeviceInfo instanceof AndroidDeviceInfo && !MobileDeviceUIProvider.checkAndroidSDKExist((Shell)this.getShell())) {
            return false;
        }
        final String appFile = this.getAppFile();
        IRunnableWithProgress processToRun = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(StringConstants.DIA_LBL_STATUS_APP_STARTING, -1);
                progressDlg.runAndWait((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        inspectorController.startMobileApp(selectDeviceInfo, appFile, false);
                        return null;
                    }
                });
                LocalAppComposite.this.checkMonitorCanceled(monitor);
                monitor.done();
            }
        };
        progressDlg.run(true, true, processToRun);
        return true;
    }

    public boolean validateLocalAppSetting() {
        if (this.cbbDevices.getSelectionIndex() < 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.DIA_ERROR_MSG_PLS_CONNECT_AND_SELECT_DEVICE);
            return false;
        }
        String appFilePath = this.getAppFile().trim();
        if (appFilePath.equals("")) {
            MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.DIA_ERROR_MSG_PLS_SELECT_APP_FILE);
            return false;
        }
        File appFile = new File(appFilePath);
        if (!appFile.exists()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.DIA_ERROR_MSG_APP_FILE_NOT_EXIST);
            return false;
        }
        return true;
    }

    private void setLinkLabelVisible(boolean visible) {
        this.linkLabel.setVisible(visible);
        ((GridData)this.linkLabel.getLayoutData()).exclude = !visible;
        this.linkLabel.pack();
        this.linkLabel.getParent().layout(true, true);
    }
}

