/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.selection;

import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsSameExpression {
    public boolean isSame(Expression left, Expression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (this.handleSpecialCases(left, right)) {
            return true;
        }
        if (left.getClass() != right.getClass()) {
            return false;
        }
        if (left instanceof ArgumentListExpression) {
            return this.visit((TupleExpression)((ArgumentListExpression)left), (TupleExpression)((ArgumentListExpression)right));
        }
        if (left instanceof ArrayExpression) {
            return this.visit((ArrayExpression)left, (ArrayExpression)right);
        }
        if (left instanceof BinaryExpression) {
            return this.visit((BinaryExpression)left, (BinaryExpression)right);
        }
        if (left instanceof BitwiseNegationExpression) {
            return this.visit((BitwiseNegationExpression)left, (BitwiseNegationExpression)right);
        }
        if (left instanceof BooleanExpression) {
            return this.visit((BooleanExpression)left, (BooleanExpression)right);
        }
        if (left instanceof CastExpression) {
            return this.visit((CastExpression)left, (CastExpression)right);
        }
        if (left instanceof ClassExpression) {
            return this.visit((ClassExpression)left, (ClassExpression)right);
        }
        if (left instanceof ClosureExpression) {
            return this.visit((ClosureExpression)left, (ClosureExpression)right);
        }
        if (left instanceof ConstantExpression) {
            return this.visit((ConstantExpression)left, (ConstantExpression)right);
        }
        if (left instanceof ConstructorCallExpression) {
            return this.visit((ConstructorCallExpression)left, (ConstructorCallExpression)right);
        }
        if (left instanceof EmptyExpression) {
            return this.visit((EmptyExpression)left, (EmptyExpression)right);
        }
        if (left instanceof FieldExpression) {
            return this.visit((FieldExpression)left, (FieldExpression)right);
        }
        if (left instanceof GStringExpression) {
            return this.visit((GStringExpression)left, (GStringExpression)right);
        }
        if (left instanceof ListExpression) {
            return this.visit((ListExpression)left, (ListExpression)right);
        }
        if (left instanceof MapExpression) {
            return this.visit((MapExpression)left, (MapExpression)right);
        }
        if (left instanceof MethodCallExpression) {
            return this.visit((MethodCallExpression)left, (MethodCallExpression)right);
        }
        if (left instanceof MethodPointerExpression) {
            return this.visit((MethodPointerExpression)left, (MethodPointerExpression)right);
        }
        if (left instanceof PostfixExpression) {
            return this.visit((PostfixExpression)left, (PostfixExpression)right);
        }
        if (left instanceof PrefixExpression) {
            return this.visit((PrefixExpression)left, (PrefixExpression)right);
        }
        if (left instanceof PropertyExpression) {
            return this.visit((PropertyExpression)left, (PropertyExpression)right);
        }
        if (left instanceof RangeExpression) {
            return this.visit((RangeExpression)left, (RangeExpression)right);
        }
        if (left instanceof SpreadExpression) {
            return this.visit((SpreadExpression)left, (SpreadExpression)right);
        }
        if (left instanceof SpreadMapExpression) {
            return this.visit((SpreadMapExpression)left, (SpreadMapExpression)right);
        }
        if (left instanceof StaticMethodCallExpression) {
            return this.visit((StaticMethodCallExpression)left, (StaticMethodCallExpression)right);
        }
        if (left instanceof TernaryExpression) {
            return this.visit((TernaryExpression)left, (TernaryExpression)right);
        }
        if (left instanceof TupleExpression) {
            return this.visit((TupleExpression)left, (TupleExpression)right);
        }
        if (left instanceof UnaryMinusExpression) {
            return this.visit((UnaryMinusExpression)left, (UnaryMinusExpression)right);
        }
        if (left instanceof UnaryPlusExpression) {
            return this.visit((UnaryPlusExpression)left, (UnaryPlusExpression)right);
        }
        if (left instanceof VariableExpression) {
            return this.visit((VariableExpression)left, (VariableExpression)right);
        }
        return false;
    }

    private boolean handleSpecialCases(Expression left, Expression right) {
        if (left instanceof ConstantExpression && right instanceof ClassExpression) {
            return right.getType().getName().equals(((ConstantExpression)left).getValue());
        }
        if (left instanceof ClassExpression && right instanceof ConstantExpression) {
            return left.getType().getName().equals(((ConstantExpression)right).getValue());
        }
        return false;
    }

    private boolean visit(VariableExpression left, VariableExpression right) {
        return left.getName().equals(right.getName());
    }

    private boolean visit(UnaryPlusExpression left, UnaryPlusExpression right) {
        return this.isSame(left.getExpression(), right.getExpression());
    }

    private boolean visit(UnaryMinusExpression left, UnaryMinusExpression right) {
        return this.isSame(left.getExpression(), right.getExpression());
    }

    private boolean visit(TupleExpression left, TupleExpression right) {
        return this.checkExpressionList(left.getExpressions(), right.getExpressions());
    }

    private boolean visit(TernaryExpression left, TernaryExpression right) {
        return this.isSame((Expression)left.getBooleanExpression(), (Expression)right.getBooleanExpression()) && this.isSame(left.getTrueExpression(), right.getTrueExpression()) && this.isSame(left.getFalseExpression(), right.getFalseExpression());
    }

    private boolean visit(StaticMethodCallExpression left, StaticMethodCallExpression right) {
        return this.visit(left.getType(), right.getType()) && left.getMethod().equals(right.getMethod()) && this.isSame(left.getArguments(), right.getArguments());
    }

    private boolean visit(SpreadExpression left, SpreadExpression right) {
        return this.isSame(left.getExpression(), right.getExpression());
    }

    private boolean visit(SpreadMapExpression left, SpreadMapExpression right) {
        return this.isSame(left.getExpression(), right.getExpression());
    }

    private boolean visit(RangeExpression left, RangeExpression right) {
        return this.isSame(left.getFrom(), right.getFrom()) && this.isSame(left.getTo(), right.getTo());
    }

    private boolean visit(PropertyExpression left, PropertyExpression right) {
        return this.isSame(left.getObjectExpression(), right.getObjectExpression()) && this.isSame(left.getProperty(), right.getProperty());
    }

    private boolean visit(PrefixExpression left, PrefixExpression right) {
        return this.nullEquals(left.getOperation(), right.getOperation()) && this.isSame(left.getExpression(), right.getExpression());
    }

    private boolean visit(PostfixExpression left, PostfixExpression right) {
        return this.nullEquals(left.getOperation(), right.getOperation()) && this.isSame(left.getExpression(), right.getExpression());
    }

    private boolean visit(MethodPointerExpression left, MethodPointerExpression right) {
        return this.isSame(left.getExpression(), right.getExpression()) && this.isSame(left.getMethodName(), right.getMethodName());
    }

    private boolean visit(MethodCallExpression left, MethodCallExpression right) {
        return this.isSame(left.getObjectExpression(), right.getObjectExpression()) && this.isSame(left.getMethod(), right.getMethod()) && this.isSame(left.getArguments(), right.getArguments());
    }

    private boolean visit(MapExpression left, MapExpression right) {
        return this.checkExpressionList(left.getMapEntryExpressions(), right.getMapEntryExpressions());
    }

    private boolean visit(ListExpression left, ListExpression right) {
        return this.checkExpressionList(left.getExpressions(), right.getExpressions());
    }

    private boolean visit(GStringExpression left, GStringExpression right) {
        return this.checkExpressionList(left.getStrings(), right.getStrings()) && this.checkExpressionList(left.getValues(), right.getValues());
    }

    private boolean visit(FieldExpression left, FieldExpression right) {
        return this.visit(left.getField().getDeclaringClass(), right.getField().getDeclaringClass()) && this.nullEquals(left.getFieldName(), right.getFieldName());
    }

    private boolean visit(EmptyExpression left, EmptyExpression right) {
        return true;
    }

    private boolean visit(ConstructorCallExpression left, ConstructorCallExpression right) {
        return this.visit(left.getType(), right.getType()) && this.isSame(left.getArguments(), right.getArguments());
    }

    private boolean visit(ConstantExpression left, ConstantExpression right) {
        return this.nullEquals(left.getText(), right.getText());
    }

    private boolean visit(ClosureExpression left, ClosureExpression right) {
        return false;
    }

    private boolean visit(ClassExpression left, ClassExpression right) {
        return this.visit(left.getType(), right.getType());
    }

    private boolean visit(CastExpression left, CastExpression right) {
        return this.visit(left.getType(), right.getType()) && this.isSame(left.getExpression(), right.getExpression());
    }

    private boolean visit(BooleanExpression left, BooleanExpression right) {
        return this.isSame(left.getExpression(), right.getExpression());
    }

    private boolean visit(BitwiseNegationExpression left, BitwiseNegationExpression right) {
        return this.isSame(left.getExpression(), right.getExpression());
    }

    private boolean visit(BinaryExpression left, BinaryExpression right) {
        return left.getOperation().getType() == right.getOperation().getType() && this.isSame(left.getLeftExpression(), right.getLeftExpression()) && this.isSame(left.getRightExpression(), right.getRightExpression());
    }

    private boolean visit(ArrayExpression left, ArrayExpression right) {
        return this.checkExpressionList(left.getExpressions(), right.getExpressions()) && this.checkExpressionList(left.getSizeExpression(), right.getSizeExpression());
    }

    private boolean visit(ClassNode left, ClassNode right) {
        return this.nullEquals(left, right);
    }

    private boolean nullEquals(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    private <T extends Expression> boolean checkExpressionList(List<T> left, List<T> right) {
        if (right == null && left == null) {
            return true;
        }
        if (right == null || left == null) {
            return false;
        }
        if (left.size() != right.size()) {
            return false;
        }
        Iterator<T> leftIter = left.iterator();
        Iterator<T> rightIter = right.iterator();
        boolean success = true;
        while (leftIter.hasNext() && rightIter.hasNext()) {
            success &= this.isSame((Expression)leftIter.next(), (Expression)rightIter.next());
        }
        return success;
    }
}

