/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.requestor;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;

public class Region {
    private final int start;
    private final int length;

    public Region(ASTNode node) {
        this.start = node.getStart();
        this.length = node.getLength();
    }

    public Region(IASTFragment node) {
        this.start = node.getStart();
        this.length = node.getLength();
    }

    public Region(int start, int length) {
        this.start = start;
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.start;
    }

    public int getEnd() {
        return this.start + this.length;
    }

    public boolean regionCoversNode(ASTNode node) {
        return this.start <= node.getStart() && this.getEnd() >= node.getEnd();
    }

    public boolean regionIsCoveredByNode(ASTNode node) {
        return this.start >= node.getStart() && this.getEnd() <= node.getEnd();
    }

    public boolean regionIsCoveredByNameRange(AnnotatedNode node) {
        return this.start >= node.getNameStart() && this.getEnd() <= node.getNameEnd() + 1;
    }

    public boolean regionIsGStringCoveredByNode(ASTNode node) {
        if (node instanceof VariableExpression) {
            return this.start >= node.getStart() - 1 && this.getEnd() <= node.getEnd();
        }
        return this.regionIsCoveredByNode(node);
    }

    public boolean isNonOverlapping(ASTNode node) {
        return this.getEnd() <= node.getStart() || this.start >= node.getEnd();
    }

    public boolean isSame(ASTNode node) {
        return this.start == node.getStart() && this.getEnd() == node.getEnd();
    }

    public boolean isSame(IASTFragment node) {
        return this.start == node.getStart() && this.getEnd() == node.getEnd();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Region other = (Region)obj;
        if (this.length != other.length) {
            return false;
        }
        return this.start == other.start;
    }

    public String toString() {
        return "Region [start=" + this.start + ", length=" + this.length + "]";
    }

    public boolean endsIn(ASTNode node) {
        return node.getStart() < this.getEnd() && this.length < node.getLength();
    }

    public boolean isEmpty() {
        return this.start == 0 && this.length == 0;
    }
}

