/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.requestor;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.ASTNodeFinder;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.CodeSelectRequestor;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.ICodeSelectHelper;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;

public class CodeSelectHelper
implements ICodeSelectHelper {
    public IJavaElement[] select(GroovyCompilationUnit unit, int start, int length) {
        ModuleNode module;
        char[] contents = unit.getContents();
        if (length > 1 && start + length < contents.length && contents[start] == '$' && contents[start + 1] != '{') {
            ++start;
            --length;
        }
        if ((module = unit.getModuleNode()) != null) {
            String event;
            block11: {
                IJavaElement[] iJavaElementArray;
                block14: {
                    Region region;
                    ASTNode node;
                    Region select;
                    block12: {
                        IJavaElement[] iJavaElementArray2;
                        block13: {
                            event = null;
                            if (GroovyLogManager.manager.hasLoggers()) {
                                GroovyLogManager.manager.log(TraceCategory.CODESELECT, "Code select starting on " + unit.getElementName() + " at [ " + start + "," + length + " ]");
                                event = "Code select: " + unit.getElementName();
                                GroovyLogManager.manager.logStart(event);
                            }
                            select = new Region(start, length);
                            Object[] result = this.findNodeForRegion(module, select);
                            node = (ASTNode)result[0];
                            region = (Region)result[1];
                            if (node == null) break block11;
                            if (!CodeSelectHelper.isTypeDeclaration(module, node)) break block12;
                            iJavaElementArray2 = CodeSelectHelper.returnThisNode(unit, node);
                            if (event == null) break block13;
                            GroovyLogManager.manager.logEnd(event, TraceCategory.CODESELECT);
                        }
                        return iJavaElementArray2;
                    }
                    try {
                        CodeSelectRequestor requestor = this.createRequestor(node, region, select, unit);
                        TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(unit);
                        visitor.visitCompilationUnit((ITypeRequestor)requestor);
                        IJavaElement element = requestor.getRequestedElement();
                        if (element == null) break block11;
                        iJavaElementArray = new IJavaElement[]{element};
                        if (event == null) break block14;
                    }
                    catch (RuntimeException e) {
                        try {
                            if (event != null) {
                                GroovyLogManager.manager.logException(TraceCategory.CODESELECT, (Throwable)e);
                            }
                            throw e;
                        }
                        catch (Throwable throwable) {
                            if (event != null) {
                                GroovyLogManager.manager.logEnd(event, TraceCategory.CODESELECT);
                            }
                            throw throwable;
                        }
                    }
                    GroovyLogManager.manager.logEnd(event, TraceCategory.CODESELECT);
                }
                return iJavaElementArray;
            }
            if (event != null) {
                GroovyLogManager.manager.logEnd(event, TraceCategory.CODESELECT);
            }
        }
        return new IJavaElement[0];
    }

    public ASTNode selectASTNode(GroovyCompilationUnit unit, int start, int length) {
        ModuleNode module = unit.getModuleNode();
        if (module != null) {
            String event;
            block7: {
                ASTNode aSTNode;
                block10: {
                    Region region;
                    ASTNode node;
                    Region select;
                    block8: {
                        ClassNode classNode;
                        block9: {
                            event = null;
                            if (GroovyLogManager.manager.hasLoggers()) {
                                GroovyLogManager.manager.log(TraceCategory.CODESELECT, "Code select starting on " + unit.getElementName() + " at [ " + start + "," + length + " ]");
                                event = "Code select: " + unit.getElementName();
                                GroovyLogManager.manager.logStart(event);
                            }
                            try {
                                select = new Region(start, length);
                                Object[] result = this.findNodeForRegion(module, select);
                                node = (ASTNode)result[0];
                                region = (Region)result[1];
                                if (node == null) break block7;
                                if (!CodeSelectHelper.isTypeDeclaration(module, node)) break block8;
                                classNode = ((ClassNode)node).redirect();
                                if (event == null) break block9;
                            }
                            catch (Throwable throwable) {
                                if (event != null) {
                                    GroovyLogManager.manager.logEnd(event, TraceCategory.CODESELECT);
                                }
                                throw throwable;
                            }
                            GroovyLogManager.manager.logEnd(event, TraceCategory.CODESELECT);
                        }
                        return classNode;
                    }
                    CodeSelectRequestor requestor = this.createRequestor(node, region, select, unit);
                    TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(unit);
                    visitor.visitCompilationUnit((ITypeRequestor)requestor);
                    aSTNode = requestor.getRequestedNode();
                    if (event == null) break block10;
                    GroovyLogManager.manager.logEnd(event, TraceCategory.CODESELECT);
                }
                return aSTNode;
            }
            if (event != null) {
                GroovyLogManager.manager.logEnd(event, TraceCategory.CODESELECT);
            }
        }
        return null;
    }

    protected CodeSelectRequestor createRequestor(ASTNode node, Region nodeRegion, Region selectRegion, GroovyCompilationUnit unit) {
        return new CodeSelectRequestor(node, nodeRegion, selectRegion, unit);
    }

    protected static IJavaElement[] returnThisNode(GroovyCompilationUnit unit, ASTNode nodeToLookFor) {
        String rawName = ((ClassNode)nodeToLookFor).getNameWithoutPackage();
        String[] enclosingTypes = rawName.split("\\$");
        IJavaElement candidate = null;
        int i = 0;
        int n = enclosingTypes.length;
        while (i < n) {
            candidate = i == 0 ? unit.getType(enclosingTypes[i]) : candidate.getType(enclosingTypes[i]);
            ++i;
        }
        IJavaElement result = unit instanceof GroovyClassFileWorkingCopy ? ((GroovyClassFileWorkingCopy)unit).convertToBinary(candidate) : candidate;
        return new IJavaElement[]{result};
    }

    protected static boolean isTypeDeclaration(ModuleNode module, ASTNode nodeToLookFor) {
        if (nodeToLookFor instanceof ClassNode && !(nodeToLookFor instanceof InnerClassNode)) {
            for (ClassNode clazz : module.getClasses()) {
                if (clazz != nodeToLookFor) continue;
                return true;
            }
        }
        return false;
    }

    protected Object[] findNodeForRegion(ModuleNode module, Region r) {
        ASTNodeFinder finder = new ASTNodeFinder(r);
        finder.doVisit(module);
        return new Object[]{finder.result, finder.sloc};
    }
}

