/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.requestor;

import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ImportNodeCompatibilityWrapper;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.core.util.ArrayUtils;
import org.codehaus.groovy.eclipse.core.util.VisitCompleteException;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;

public class ASTNodeFinder
extends ClassCodeVisitorSupport {
    protected ModuleNode module;
    protected ASTNode result;
    protected Region sloc;
    private static final Pattern EXTENDS_ = Pattern.compile("\\bextends\\s+");
    private static final Pattern IMPLEMENTS_ = Pattern.compile("\\bimplements\\s+");
    private static final Pattern _IMPLEMENTS = Pattern.compile("\\s+implements\\b");

    public ASTNodeFinder(Region sloc) {
        this.sloc = sloc;
    }

    public ASTNode doVisit(ModuleNode node) {
        this.module = node;
        try {
            this.visitPackage(node.getPackage());
            this.visitImports(node);
            for (ClassNode clazz : node.getClasses()) {
                this.visitClass(clazz);
            }
        }
        catch (VisitCompleteException visitCompleteException) {}
        return this.result;
    }

    public void visitPackage(PackageNode node) {
        if (node != null) {
            this.visitAnnotations((AnnotatedNode)node);
            this.check((ASTNode)node);
        }
    }

    public void visitImports(ModuleNode node) {
        for (ImportNode importNode : new ImportNodeCompatibilityWrapper(node).getAllImportNodes()) {
            this.visitImport(importNode);
        }
    }

    protected void visitImport(ImportNode node) {
        if (node.getType() != null) {
            this.visitAnnotations((AnnotatedNode)node);
            this.check((ASTNode)node.getType());
            if (node.getFieldNameExpr() != null) {
                this.check((ASTNode)node.getFieldNameExpr());
            }
            if (node.getAliasExpr() != null) {
                this.check((ASTNode)node.getAliasExpr());
            }
        }
        this.check((ASTNode)node);
    }

    public void visitClass(ClassNode node) {
        this.visitAnnotations((AnnotatedNode)node);
        if (node.getNameEnd() > 0) {
            this.checkNameRange((AnnotatedNode)node);
            if (this.sloc.getEnd() > node.getNameEnd()) {
                ClassNode[] superTypes;
                String name;
                GenericsType type = (GenericsType)ArrayUtils.lastElement((Object[])node.getGenericsTypes());
                int offset = (type != null ? type.getEnd() : node.getNameEnd()) + 1;
                String source = this.readClassDeclaration(node).substring(offset - node.getStart());
                ClassNode superClass = node.getUnresolvedSuperClass();
                if (superClass != null && source.indexOf(name = GroovyUtils.splitName((ClassNode)superClass)[1]) > 0) {
                    int a = ASTNodeFinder.endIndexOf(source, EXTENDS_);
                    int b = ASTNodeFinder.indexOf(source, _IMPLEMENTS);
                    if (b < 0) {
                        b = source.length();
                    }
                    this.check((ASTNode)superClass, offset + a, offset + b);
                }
                if ((superTypes = node.getUnresolvedInterfaces()) != null && superTypes.length > 0) {
                    int i = 0;
                    int n = superTypes.length;
                    while (i < n) {
                        String name2 = GroovyUtils.splitName((ClassNode)superTypes[i])[1];
                        if (source.indexOf(name2) > 0) {
                            char c;
                            int a = ASTNodeFinder.endIndexOf(source, IMPLEMENTS_);
                            int b = source.length();
                            int j = i - 1;
                            while (j >= 0) {
                                if (superTypes[j].getEnd() > 0) {
                                    a = superTypes[j].getEnd() - offset;
                                    while ((c = source.charAt(a)) == ',' || Character.isWhitespace(c)) {
                                        ++a;
                                    }
                                    break;
                                }
                                --j;
                            }
                            j = i + 1;
                            while (j < n) {
                                if (superTypes[j].getStart() > 0) {
                                    b = superTypes[j].getStart() - 1 - offset;
                                    while ((c = source.charAt(b - 1)) == ',' || Character.isWhitespace(c)) {
                                        --b;
                                    }
                                    break;
                                }
                                ++j;
                            }
                            this.check((ASTNode)superTypes[i], offset + a, offset + b);
                        }
                        ++i;
                    }
                }
            }
        }
        if (node.getObjectInitializerStatements() != null) {
            for (Statement statement : node.getObjectInitializerStatements()) {
                statement.visit((GroovyCodeVisitor)this);
            }
        }
        VisitCompleteException vce = null;
        try {
            MethodNode clinit = node.getMethod("<clinit>", Parameter.EMPTY_ARRAY);
            if (clinit != null && clinit.getCode() instanceof BlockStatement) {
                for (Statement statement : ((BlockStatement)clinit.getCode()).getStatements()) {
                    statement.visit((GroovyCodeVisitor)this);
                }
            }
        }
        catch (VisitCompleteException e) {
            vce = e;
        }
        node.visitContents((GroovyClassVisitor)this);
        Iterator innerClasses = node.getInnerClasses();
        if (innerClasses != null) {
            while (innerClasses.hasNext()) {
                ClassNode inner = (ClassNode)innerClasses.next();
                if (inner.isSynthetic() && !(inner instanceof GeneratedClosure)) continue;
                this.visitClass(inner);
            }
        }
        if (vce != null) {
            throw vce;
        }
    }

    public void visitField(FieldNode node) {
        if (node.getNameEnd() > 0) {
            this.checkNameRange((AnnotatedNode)node);
        }
        super.visitField(node);
        this.check((ASTNode)node.getType(), node.getStart(), node.getEnd() - node.getName().length());
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        if (node.getEnd() > 0) {
            ClassNode returnType = node.getReturnType();
            if (returnType != null) {
                int offset = -1;
                if (returnType.getEnd() < 1) {
                    ASTNode last = (ASTNode)ArrayUtils.lastElement((Object[])node.getGenericsTypes());
                    if (last != null) {
                        offset = last.getEnd() + 1;
                    } else {
                        int n = node.getAnnotations().size();
                        if (n > 0) {
                            int i = n - 1;
                            while (i >= 0) {
                                last = GroovyUtils.lastElement((AnnotationNode)((AnnotationNode)node.getAnnotations().get(i)));
                                if (last.getEnd() > 0) {
                                    offset = last.getEnd() + 1;
                                    break;
                                }
                                --i;
                            }
                        }
                    }
                }
                this.check((ASTNode)returnType, Math.max(offset, node.getStart()), node.getNameStart() - 1);
            }
            if (node.getNameEnd() > 0) {
                this.checkNameRange((AnnotatedNode)node);
            }
            this.checkParameters(node.getParameters());
            if (node.getExceptions() != null) {
                ClassNode[] classNodeArray = node.getExceptions();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode e = classNodeArray[n2];
                    this.check((ASTNode)e);
                    ++n2;
                }
            }
        }
        super.visitConstructorOrMethod(node, isConstructor);
    }

    protected void visitAnnotation(AnnotationNode node) {
        this.check((ASTNode)node.getClassNode());
        int start = node.getEnd() + 2;
        for (Map.Entry pair : node.getMembers().entrySet()) {
            String name = (String)pair.getKey();
            Expression expr = (Expression)pair.getValue();
            this.check((ASTNode)node.getClassNode().getMethod(name, Parameter.EMPTY_ARRAY), start, expr.getStart() - 1);
            start = expr.getEnd() + 1;
        }
        super.visitAnnotation(node);
    }

    public void visitArrayExpression(ArrayExpression expression) {
        ClassNode arrayClass = expression.getElementType();
        if (arrayClass != arrayClass.redirect()) {
            this.check((ASTNode)arrayClass);
        }
        super.visitArrayExpression(expression);
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        super.visitBinaryExpression(expression);
        this.check((ASTNode)expression);
    }

    public void visitCastExpression(CastExpression expression) {
        this.check((ASTNode)expression.getType());
        super.visitCastExpression(expression);
    }

    public void visitClassExpression(ClassExpression expression) {
        if (expression.getEnd() > 0 && expression.getStart() == expression.getType().getStart()) {
            this.check((ASTNode)expression.getType());
        } else {
            this.check((ASTNode)expression);
        }
        super.visitClassExpression(expression);
    }

    public void visitClosureExpression(ClosureExpression expression) {
        this.checkParameters(expression.getParameters());
        super.visitClosureExpression(expression);
    }

    public void visitFieldExpression(FieldExpression expression) {
        this.check((ASTNode)expression);
        super.visitFieldExpression(expression);
    }

    public void visitVariableExpression(VariableExpression expression) {
        if (expression == expression.getAccessedVariable() || expression.getName().charAt(0) == '$') {
            this.visitAnnotations((AnnotatedNode)expression);
            int until = expression.getStart() - 1;
            int start = Math.max(0, until - expression.getOriginType().getName().length() - 1);
            this.check((ASTNode)expression.getOriginType(), start, until);
        }
        this.check((ASTNode)expression);
    }

    public void visitConstantExpression(ConstantExpression expression) {
        if (expression == ConstantExpression.NULL) {
            return;
        }
        if (expression.getText().length() == 0 && expression.getLength() != 0) {
            return;
        }
        if (expression instanceof AnnotationConstantExpression) {
            this.check((ASTNode)expression.getType());
        }
        this.check((ASTNode)expression);
        super.visitConstantExpression(expression);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        if (call.getEnd() > 0) {
            int until;
            int start;
            if (call.getNameStart() > 0) {
                this.checkNameRange((AnnotatedNode)call);
                this.checkGenerics(call.getType());
                start = call.getStart();
                until = call.getNameStart() - 1;
            } else {
                try {
                    start = call.getStart() + "new ".length();
                    until = call.getArguments().getStart() - 1;
                    this.check((ASTNode)call.getType(), start, until);
                    until = start;
                    start = call.getStart();
                }
                catch (VisitCompleteException e) {
                    this.result = call;
                    throw e;
                }
            }
            this.check(null, start, until);
        }
        super.visitConstructorCallExpression(call);
        if (call.isUsingAnonymousInnerClass()) {
            call.getType().visitContents((GroovyClassVisitor)this);
        }
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        if (call.getOwnerType() != call.getOwnerType().redirect()) {
            this.check((ASTNode)call.getOwnerType());
        }
        super.visitStaticMethodCallExpression(call);
        this.check((ASTNode)call);
    }

    public void visitCatchStatement(CatchStatement statement) {
        this.checkParameter(statement.getVariable());
        super.visitCatchStatement(statement);
    }

    public void visitForLoop(ForStatement statement) {
        this.checkParameter(statement.getVariable());
        super.visitForLoop(statement);
    }

    protected void check(ASTNode node) {
        if (node instanceof ClassNode) {
            this.checkGenerics((ClassNode)node);
        }
        if (node.getEnd() > 0 && this.sloc.regionIsCoveredByNode(node)) {
            this.completeVisitation(node, null);
        }
    }

    protected void check(ASTNode node, int start, int until) {
        if (node != null && node.getEnd() > 0) {
            this.check(node);
        } else {
            if (node instanceof ClassNode) {
                this.checkGenerics((ClassNode)node);
            }
            if (this.sloc.getOffset() >= start && this.sloc.getEnd() <= until) {
                this.completeVisitation(node, new Region(start, until - start));
            }
        }
    }

    protected void checkNameRange(AnnotatedNode node) {
        if (this.sloc.regionIsCoveredByNameRange(node)) {
            this.completeVisitation((ASTNode)node, new Region(node.getNameStart(), node.getNameEnd() - node.getNameStart()));
        }
        if (node instanceof ClassNode) {
            this.checkGenerics((ClassNode)node);
        }
    }

    private void checkGenerics(ClassNode node) {
        if (node.isUsingGenerics() && node.getGenericsTypes() != null) {
            GenericsType[] genericsTypeArray = node.getGenericsTypes();
            int n = genericsTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType generics = genericsTypeArray[n2];
                int start = generics.getStart();
                int until = start + generics.getName().length();
                if (generics.getType() != null && generics.getType().getName().charAt(0) != '?') {
                    this.check((ASTNode)generics.getType(), start, until);
                }
                start = until + 1;
                until = generics.getEnd();
                if (generics.getLowerBound() != null) {
                    this.check((ASTNode)generics.getLowerBound(), start += "super ".length(), until);
                } else if (generics.getUpperBounds() != null) {
                    start += "extends ".length();
                    ClassNode[] classNodeArray = generics.getUpperBounds();
                    int n3 = classNodeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ClassNode upper = classNodeArray[n4];
                        String name = upper.getName();
                        if (!name.equals(node.getName())) {
                            this.check((ASTNode)upper, start, Math.min(start + name.length(), until));
                            if (upper.getEnd() > 0) {
                                start = upper.getEnd() + 1;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void checkParameter(Parameter param) {
        if (param != null && param.getEnd() > 0) {
            this.checkNameRange((AnnotatedNode)param);
            if (param.getInitialExpression() != null) {
                param.getInitialExpression().visit((GroovyCodeVisitor)this);
            }
            this.check((ASTNode)param.getType(), param.getStart(), param.getEnd());
        }
    }

    private void checkParameters(Parameter[] params) {
        if (params != null) {
            Parameter[] parameterArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter p = parameterArray[n2];
                this.checkParameter(p);
                ++n2;
            }
        }
    }

    protected final void completeVisitation(ASTNode node, Region sloc) throws VisitCompleteException {
        this.result = node;
        if (sloc != null) {
            this.sloc = sloc;
        }
        throw new VisitCompleteException();
    }

    private String readClassDeclaration(ClassNode node) {
        String code = (String)node.getNodeMetaData((Object)"groovy.source");
        if (code == null) {
            code = String.valueOf(GroovyUtils.readSourceRange((SourceUnit)this.module.getContext(), (int)node.getStart(), (int)node.getLength()));
            node.setNodeMetaData((Object)"groovy.source", (Object)code);
        }
        return code.substring(0, code.indexOf(123));
    }

    private static int endIndexOf(String s, Pattern p) {
        Matcher m = p.matcher(s);
        if (m.find()) {
            return m.start() + m.group().length();
        }
        return -1;
    }

    private static int indexOf(String s, Pattern p) {
        Matcher m = p.matcher(s);
        if (m.find()) {
            return m.start();
        }
        return -1;
    }
}

