/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.fragments;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentFactory;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.EmptyASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.FragmentVisitor;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.selection.IsSameExpression;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;

public class SimpleExpressionASTFragment
implements IASTFragment {
    private final Expression expression;
    private int actualStartPosition;

    SimpleExpressionASTFragment(Expression expression) {
        this.expression = expression;
        this.actualStartPosition = expression.getStart();
    }

    public Expression getAssociatedExpression() {
        return this.expression;
    }

    public ASTNode getAssociatedNode() {
        return this.expression;
    }

    void setActualStartPosition(int actualStartPosition) {
        this.actualStartPosition = actualStartPosition;
    }

    public int getEnd() {
        return this.expression.getEnd();
    }

    public int getStart() {
        return this.actualStartPosition;
    }

    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    public int getTrimmedEnd(GroovyCompilationUnit unit) {
        char[] contents = unit.getContents();
        int end = this.getEnd();
        while (end > this.actualStartPosition && Character.isWhitespace(contents[end])) {
            --end;
        }
        return end;
    }

    public int getTrimmedLength(GroovyCompilationUnit unit) {
        return this.getTrimmedEnd(unit) - this.getStart();
    }

    public boolean matches(IASTFragment other) {
        if (!(other instanceof SimpleExpressionASTFragment)) {
            return false;
        }
        return new IsSameExpression().isSame(this.expression, other.getAssociatedExpression());
    }

    public String toString() {
        return this.print(0);
    }

    public String print(int indentLvl) {
        return String.valueOf(ASTFragmentFactory.spaces(indentLvl)) + "(S) " + this.expression.toString();
    }

    public int fragmentLength() {
        return 1;
    }

    public void accept(FragmentVisitor visitor) {
        visitor.previsit(this);
        visitor.visit(this);
    }

    public ASTFragmentKind kind() {
        return ASTFragmentKind.SIMPLE_EXPRESSION;
    }

    public IASTFragment findMatchingSubFragment(IASTFragment other) {
        if (other.kind() == ASTFragmentKind.SIMPLE_EXPRESSION && new IsSameExpression().isSame(this.getAssociatedExpression(), other.getAssociatedExpression())) {
            return new SimpleExpressionASTFragment(this.expression);
        }
        return new EmptyASTFragment();
    }
}

