/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.fragments;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentFactory;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.EmptyASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.FragmentVisitor;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.selection.IsSameExpression;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;

public class MethodCallFragment
implements IASTFragment {
    private final Expression arguments;
    private final Expression methodExpression;
    private final IASTFragment next;
    private int actualEndPosition;

    MethodCallFragment(Expression methodExpression, Expression arguments, IASTFragment next, int actualEndPosition) {
        this.methodExpression = methodExpression;
        this.arguments = arguments;
        this.next = next;
        this.actualEndPosition = actualEndPosition;
    }

    public MethodCallFragment(Expression methodExpression, Expression arguments, int actualEndPosition) {
        this(methodExpression, arguments, null, actualEndPosition);
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public int getEnd() {
        return this.hasNext() ? this.next.getEnd() : this.actualEndPosition;
    }

    public int getStart() {
        return this.methodExpression.getStart();
    }

    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    public int getTrimmedEnd(GroovyCompilationUnit unit) {
        if (this.hasNext()) {
            return this.getNext().getTrimmedEnd(unit);
        }
        char[] contents = unit.getContents();
        int end = this.actualEndPosition;
        while (end > this.methodExpression.getStart() && Character.isWhitespace(contents[end])) {
            --end;
        }
        return end;
    }

    public int getTrimmedLength(GroovyCompilationUnit unit) {
        return this.getTrimmedEnd(unit) - this.getStart();
    }

    public Expression getArguments() {
        return this.arguments;
    }

    public IASTFragment getNext() {
        return this.next;
    }

    public boolean matches(IASTFragment other) {
        if (!(other instanceof MethodCallFragment)) {
            return false;
        }
        MethodCallFragment otherCall = (MethodCallFragment)other;
        if (otherCall.hasNext() != this.hasNext()) {
            return false;
        }
        return new IsSameExpression().isSame(this.arguments, otherCall.getArguments()) && new IsSameExpression().isSame(this.methodExpression, otherCall.getAssociatedExpression());
    }

    public int fragmentLength() {
        return this.hasNext() ? 1 + this.next.fragmentLength() : 1;
    }

    public Expression getAssociatedExpression() {
        return this.methodExpression;
    }

    public ASTNode getAssociatedNode() {
        return this.methodExpression;
    }

    public String print(int indentLvl) {
        return String.valueOf(ASTFragmentFactory.spaces(indentLvl)) + "(M) " + this.methodExpression + "." + this.arguments + (this.hasNext() ? "\n" + this.next.print(indentLvl + 1) : "");
    }

    public void accept(FragmentVisitor visitor) {
        if (visitor.previsit(this) && visitor.visit(this) && this.hasNext()) {
            this.next.accept(visitor);
        }
    }

    public ASTFragmentKind kind() {
        return ASTFragmentKind.METHOD_CALL;
    }

    public IASTFragment findMatchingSubFragment(IASTFragment other) {
        if (other.fragmentLength() > this.fragmentLength()) {
            return new EmptyASTFragment();
        }
        if (other.kind() == this.kind()) {
            MethodCallFragment toMatchCall = (MethodCallFragment)other;
            if (new IsSameExpression().isSame(this.getAssociatedExpression(), toMatchCall.getAssociatedExpression()) && new IsSameExpression().isSame(this.getArguments(), toMatchCall.getArguments())) {
                if (!toMatchCall.hasNext()) {
                    return new MethodCallFragment(this.getAssociatedExpression(), this.getArguments(), this.actualEndPosition);
                }
                IASTFragment result = this.getNext().findMatchingSubFragment(toMatchCall.getNext());
                if (result.kind() == ASTFragmentKind.EMPTY) {
                    return new EmptyASTFragment();
                }
                MethodCallFragment newFragment = new MethodCallFragment(this.getAssociatedExpression(), this.getArguments(), result, this.actualEndPosition);
                return newFragment;
            }
        }
        return new EmptyASTFragment();
    }
}

