/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.fragments;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.FragmentVisitor;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.Assert;

public class EnclosingASTNodeFragment
implements IASTFragment {
    private final ASTNode node;

    EnclosingASTNodeFragment(ASTNode node) {
        this.node = node;
    }

    public void accept(FragmentVisitor visitor) {
        visitor.previsit(this);
        visitor.visit(this);
    }

    public IASTFragment findMatchingSubFragment(IASTFragment other) {
        return null;
    }

    public int fragmentLength() {
        return 1;
    }

    public Expression getAssociatedExpression() {
        Assert.isLegal((boolean)false, (String)"EnclosingASTNodeFragment has no associated expression");
        return null;
    }

    public ASTNode getAssociatedNode() {
        return this.node;
    }

    public int getEnd() {
        return this.node.getEnd();
    }

    public int getStart() {
        return this.node.getStart();
    }

    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    public int getTrimmedEnd(GroovyCompilationUnit unit) {
        char[] contents = unit.getContents();
        int end = this.getEnd();
        int start = this.node.getStart();
        while (end > start && Character.isWhitespace(contents[end])) {
            --end;
        }
        return end;
    }

    public int getTrimmedLength(GroovyCompilationUnit unit) {
        return this.getTrimmedEnd(unit) - this.getStart();
    }

    public ASTFragmentKind kind() {
        return ASTFragmentKind.ENCLOSING;
    }

    public boolean matches(IASTFragment other) {
        return this.kind() == other.kind() && this.node == ((EnclosingASTNodeFragment)other).getAssociatedNode();
    }

    public String print(int indentLvl) {
        return "(E) " + this.node.toString();
    }

    public String toString() {
        return this.print(0);
    }
}

