/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.fragments;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentFactory;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.EmptyASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.FragmentVisitor;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.SimpleExpressionASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.selection.IsSameExpression;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.Assert;

public class BinaryExpressionFragment
implements IASTFragment {
    private final Token token;
    private final Expression expression;
    private final IASTFragment next;
    private int actualStartPosition;

    BinaryExpressionFragment(Token token, Expression expression, IASTFragment next) {
        Assert.isNotNull((Object)next);
        this.token = token;
        this.expression = expression;
        this.next = next;
        this.actualStartPosition = expression.getStart();
    }

    void setActualStartPosition(int actualStartPosition) {
        this.actualStartPosition = actualStartPosition;
    }

    public Expression getAssociatedExpression() {
        return this.expression;
    }

    public ASTNode getAssociatedNode() {
        return this.expression;
    }

    public int getEnd() {
        return this.getNext().getEnd();
    }

    public int getStart() {
        return this.actualStartPosition;
    }

    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    public int getTrimmedEnd(GroovyCompilationUnit unit) {
        return this.getNext().getTrimmedEnd(unit);
    }

    public int getTrimmedLength(GroovyCompilationUnit unit) {
        return this.getTrimmedEnd(unit) - this.getStart();
    }

    public Token getToken() {
        return this.token;
    }

    public IASTFragment getNext() {
        return this.next;
    }

    public boolean matches(IASTFragment other) {
        if (!(other instanceof BinaryExpressionFragment)) {
            return false;
        }
        BinaryExpressionFragment otherBinary = (BinaryExpressionFragment)other;
        return otherBinary.getToken().getText().equals(this.token.getText()) && new IsSameExpression().isSame(this.expression, otherBinary.getAssociatedExpression()) && this.next.matches(otherBinary.getNext());
    }

    public String toString() {
        return this.print(0);
    }

    public String print(int indentLvl) {
        return String.valueOf(ASTFragmentFactory.spaces(indentLvl)) + "(B) " + this.expression.toString() + "\n" + this.next.print(indentLvl + 1);
    }

    public int fragmentLength() {
        return 1 + this.next.fragmentLength();
    }

    public void accept(FragmentVisitor visitor) {
        if (visitor.previsit(this) && visitor.visit(this)) {
            this.next.accept(visitor);
        }
    }

    public ASTFragmentKind kind() {
        return ASTFragmentKind.BINARY;
    }

    public IASTFragment findMatchingSubFragment(IASTFragment other) {
        if (this.fragmentLength() < other.fragmentLength()) {
            return new EmptyASTFragment();
        }
        if (other.kind() == ASTFragmentKind.SIMPLE_EXPRESSION && new IsSameExpression().isSame(this.getAssociatedExpression(), other.getAssociatedExpression())) {
            return new SimpleExpressionASTFragment(this.expression);
        }
        if (other.kind() == ASTFragmentKind.BINARY) {
            BinaryExpressionFragment otherBinary = (BinaryExpressionFragment)other;
            if (new IsSameExpression().isSame(this.getAssociatedExpression(), other.getAssociatedExpression()) && this.getToken().getText().equals(otherBinary.getToken().getText())) {
                IASTFragment result = this.next.findMatchingSubFragment(otherBinary.next);
                if (result.kind() == ASTFragmentKind.EMPTY) {
                    return new EmptyASTFragment();
                }
                BinaryExpressionFragment newResult = new BinaryExpressionFragment(this.token, this.expression, result);
                newResult.setActualStartPosition(this.actualStartPosition);
                return newResult;
            }
        }
        return new EmptyASTFragment();
    }
}

