/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.fragments;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.BinaryExpressionFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.EmptyASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.EnclosingASTNodeFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.MethodCallFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.PropertyExpressionFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.SimpleExpressionASTFragment;
import org.codehaus.groovy.syntax.Token;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTFragmentFactory {
    public IASTFragment createFragment(ASTNode node) {
        if (node instanceof Expression) {
            return this.createFragment((Expression)node);
        }
        return new EnclosingASTNodeFragment(node);
    }

    public IASTFragment createFragment(Expression expression, int start, int end) {
        Expression inner;
        Assert.isLegal((expression.getStart() <= start ? 1 : 0) != 0, (String)("Invalid start position: " + start));
        Assert.isLegal((expression.getEnd() >= end ? 1 : 0) != 0, (String)("Invalid end position: " + end));
        if (expression instanceof BooleanExpression) {
            inner = ((BooleanExpression)expression).getExpression();
            if (inner.getStart() == expression.getStart() && inner.getEnd() == expression.getEnd()) {
                expression = inner;
            }
        } else if (expression instanceof TupleExpression && ((TupleExpression)expression).getExpressions().size() == 1 && (inner = ((TupleExpression)expression).getExpression(0)).getStart() == expression.getStart() && inner.getEnd() == expression.getEnd()) {
            expression = inner;
        }
        if (expression instanceof BinaryExpression) {
            IASTFragment fragment = this.createBinaryFragment((BinaryExpression)expression, start, end);
            if (expression instanceof DeclarationExpression) {
                if (fragment.kind() == ASTFragmentKind.BINARY) {
                    ((BinaryExpressionFragment)fragment).setActualStartPosition(((DeclarationExpression)expression).getStart());
                } else if (fragment.kind() == ASTFragmentKind.SIMPLE_EXPRESSION) {
                    ((SimpleExpressionASTFragment)fragment).setActualStartPosition(((DeclarationExpression)expression).getStart());
                }
            }
            return fragment;
        }
        if (expression instanceof PropertyExpression) {
            return this.createPropertyBasedFragment(expression, start, end);
        }
        if (expression instanceof MethodCallExpression) {
            return this.createPropertyBasedFragment(expression, start, end);
        }
        if (expression instanceof MethodPointerExpression) {
            return this.createPropertyBasedFragment(expression, start, end);
        }
        if (expression.getStart() == start && expression.getEnd() == end) {
            return new SimpleExpressionASTFragment(expression);
        }
        return new EmptyASTFragment();
    }

    public IASTFragment createFragment(Expression expression) {
        return this.createFragment(expression, expression.getStart(), expression.getEnd());
    }

    private IASTFragment createBinaryFragment(BinaryExpression expression, int start, int end) {
        ArrayList<Expression> exprs = new ArrayList<Expression>();
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.walkBinaryExpr(expression, exprs, tokens);
        Expression firstExpr = (Expression)exprs.get(exprs.size() - 1);
        IASTFragment next = new EmptyASTFragment();
        if (firstExpr.getStart() >= start && firstExpr.getEnd() <= end) {
            next = new SimpleExpressionASTFragment(firstExpr);
        }
        int i = tokens.size() - 1;
        while (i >= 0) {
            Expression nextExpr = (Expression)exprs.get(i);
            if (nextExpr.getStart() >= start && nextExpr.getEnd() <= end) {
                next = next.kind() == ASTFragmentKind.EMPTY ? new SimpleExpressionASTFragment(nextExpr) : new BinaryExpressionFragment((Token)tokens.get(i), nextExpr, next);
            }
            --i;
        }
        return next;
    }

    private void walkBinaryExpr(BinaryExpression expression, List<Expression> exprs, List<Token> tokens) {
        if (expression.getLeftExpression() instanceof BinaryExpression) {
            this.walkBinaryExpr((BinaryExpression)expression.getLeftExpression(), exprs, tokens);
        } else {
            exprs.add(expression.getLeftExpression());
        }
        tokens.add(expression.getOperation());
        if (expression.getRightExpression() instanceof BinaryExpression) {
            this.walkBinaryExpr((BinaryExpression)expression.getRightExpression(), exprs, tokens);
        } else {
            exprs.add(expression.getRightExpression());
        }
    }

    private IASTFragment createPropertyBasedFragment(Expression expression, int start, int end) {
        ArrayList<ASTFragmentKind> kinds = new ArrayList<ASTFragmentKind>();
        ArrayList<Expression> exprs = new ArrayList<Expression>();
        ArrayList<Expression> args = new ArrayList<Expression>();
        ArrayList<Integer> ends = new ArrayList<Integer>();
        this.walkPropertyExpr(expression, exprs, args, kinds, ends);
        IASTFragment prev = new EmptyASTFragment();
        boolean wasImplicitCall = false;
        Expression firstExpr = (Expression)exprs.get(exprs.size() - 1);
        if (firstExpr.getStart() >= start && firstExpr.getEnd() <= end) {
            prev = kinds.get(kinds.size() - 1) == ASTFragmentKind.METHOD_CALL ? new MethodCallFragment(firstExpr, (Expression)args.get(exprs.size() - 1), (Integer)ends.get(exprs.size() - 1)) : new SimpleExpressionASTFragment(firstExpr);
        } else if (this.checkWasImplicitCall(firstExpr)) {
            wasImplicitCall = true;
        }
        int i = exprs.size() - 2;
        while (i >= 0) {
            Expression expr = (Expression)exprs.get(i);
            if (expr.getStart() >= start && expr.getEnd() <= end) {
                prev = kinds.get(i) == ASTFragmentKind.METHOD_CALL ? new MethodCallFragment(expr, (Expression)args.get(i), prev.kind() == ASTFragmentKind.EMPTY ? null : prev, (Integer)ends.get(i)) : (prev.kind() == ASTFragmentKind.EMPTY ? (!wasImplicitCall ? new SimpleExpressionASTFragment(expr) : new MethodCallFragment(expr, (Expression)args.get(i + 1), null, (Integer)ends.get(i))) : (!wasImplicitCall ? new PropertyExpressionFragment((ASTFragmentKind)((Object)kinds.get(i)), expr, prev) : new MethodCallFragment(expr, (Expression)args.get(i + 1), prev, (Integer)ends.get(i))));
                wasImplicitCall = false;
            } else if (this.checkWasImplicitCall(expr)) {
                wasImplicitCall = true;
            }
            --i;
        }
        return prev;
    }

    private boolean checkWasImplicitCall(Expression firstExpr) {
        return firstExpr.getEnd() == 0 && firstExpr instanceof ConstantExpression && ((ConstantExpression)firstExpr).getText().equals("call");
    }

    private void walkPropertyExpr(Expression startExpression, List<Expression> targetExprs, List<Expression> targetArgs, List<ASTFragmentKind> targetKinds, List<Integer> targetEnds) {
        if (startExpression instanceof PropertyExpression) {
            PropertyExpression propertyExpression = (PropertyExpression)startExpression;
            ASTFragmentKind kind = ASTFragmentKind.toPropertyKind((Expression)propertyExpression);
            this.walkPropertyExpr(propertyExpression.getObjectExpression(), targetExprs, targetArgs, targetKinds, targetEnds);
            int toRemove = targetKinds.size() - 1;
            if (targetKinds.get(toRemove) == ASTFragmentKind.SIMPLE_EXPRESSION) {
                targetKinds.set(toRemove, kind);
                targetArgs.set(toRemove, null);
            }
            this.walkPropertyExpr(propertyExpression.getProperty(), targetExprs, targetArgs, targetKinds, targetEnds);
        } else if (startExpression instanceof MethodCallExpression) {
            MethodCallExpression methodCallExpression = (MethodCallExpression)startExpression;
            this.walkPropertyExpr(methodCallExpression.getObjectExpression(), targetExprs, targetArgs, targetKinds, targetEnds);
            int toRemove = targetKinds.size() - 1;
            if (targetKinds.get(toRemove) == ASTFragmentKind.SIMPLE_EXPRESSION) {
                targetKinds.set(toRemove, ASTFragmentKind.PROPERTY);
                targetArgs.set(toRemove, null);
            }
            this.walkPropertyExpr(methodCallExpression.getMethod(), targetExprs, targetArgs, targetKinds, targetEnds);
            toRemove = targetKinds.size() - 1;
            targetKinds.set(toRemove, ASTFragmentKind.METHOD_CALL);
            targetArgs.set(toRemove, methodCallExpression.getArguments());
            targetEnds.set(toRemove, methodCallExpression.getEnd());
        } else if (startExpression instanceof MethodPointerExpression) {
            MethodPointerExpression methodPointerExpression = (MethodPointerExpression)startExpression;
            this.walkPropertyExpr(methodPointerExpression.getExpression(), targetExprs, targetArgs, targetKinds, targetEnds);
            int toRemove = targetKinds.size() - 1;
            if (targetKinds.get(toRemove) == ASTFragmentKind.SIMPLE_EXPRESSION) {
                targetKinds.set(toRemove, ASTFragmentKind.METHOD_POINTER);
                targetArgs.set(toRemove, null);
            }
            this.walkPropertyExpr(methodPointerExpression.getMethodName(), targetExprs, targetArgs, targetKinds, targetEnds);
        } else {
            targetKinds.add(ASTFragmentKind.SIMPLE_EXPRESSION);
            targetArgs.add(null);
            targetExprs.add(startExpression);
            targetEnds.add(startExpression.getEnd());
        }
    }

    public static String spaces(int num) {
        StringBuilder sb = new StringBuilder();
        while (num-- > 0) {
            sb.append("  ");
        }
        return sb.toString();
    }
}

