/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.util;

import com.kms.katalon.composer.testcase.ast.treetable.AstBuiltInKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstCallTestCaseKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstCompositeInputEditableStatementTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstCompositeStatementTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstCustomKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstInputEditableStatementTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstStatementTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstSwitchStatementTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BinaryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.AssertStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BreakStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.CatchStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ContinueStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.DoWhileStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ElseIfStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ForStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.IfStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ReturnStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.SwitchStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.SynchronizedStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ThrowStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.TryCatchStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.WhileStatementWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WrapperToAstTreeConverter {
    private static WrapperToAstTreeConverter instance;
    private static HashMap<String, Converter<? extends StatementWrapper>> converters;
    private static Converter<ExpressionStatementWrapper> expressionConverter;
    private static Converter<ForStatementWrapper> forConverter;
    private static Converter<WhileStatementWrapper> whileConverter;
    private static Converter<SwitchStatementWrapper> switchConverter;
    private static Converter<AssertStatementWrapper> assertConverter;
    private static Converter<BreakStatementWrapper> breakConverter;
    private static Converter<ContinueStatementWrapper> continueConverter;
    private static Converter<ReturnStatementWrapper> returnConverter;
    private static Converter<ThrowStatementWrapper> throwConverter;
    private static Converter<IfStatementWrapper> ifConverter;
    private static Converter<ElseIfStatementWrapper> elseIfConverter;
    private static Converter<TryCatchStatementWrapper> tryCatchConverter;
    private static Converter<CatchStatementWrapper> catchConverter;
    private static Converter<DoWhileStatementWrapper> doWhileConverter;
    private static Converter<SynchronizedStatementWrapper> synchronizedConverter;

    static {
        expressionConverter = new Converter<ExpressionStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(ExpressionStatementWrapper expressionStatement, AstTreeTableNode parentNode) {
                return new ArrayList<AstTreeTableNode>(expressionStatement, parentNode){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(this.convertExpressionWrapper(expressionStatementWrapper, astTreeTableNode));
                    }
                };
            }

            public AstTreeTableNode convertExpressionWrapper(ExpressionStatementWrapper statementWrapper, AstTreeTableNode parentNode) {
                ExpressionWrapper expression = statementWrapper.getExpression();
                if (expression instanceof MethodCallExpressionWrapper) {
                    return this.convert(statementWrapper, (MethodCallExpressionWrapper)expression, parentNode);
                }
                if (expression instanceof BinaryExpressionWrapper) {
                    return this.convert(statementWrapper, (BinaryExpressionWrapper)expression, parentNode);
                }
                if (expression instanceof ConstantExpressionWrapper && ((ConstantExpressionWrapper)expression).getValue() instanceof String) {
                    return new AstInputEditableStatementTreeTableNode(statementWrapper, parentNode, ImageConstants.IMG_16_COMMENT, StringConstants.TREE_COMMENT);
                }
                if (expression instanceof ClosureExpressionWrapper) {
                    return new AstInputEditableStatementTreeTableNode(statementWrapper, parentNode, ImageConstants.IMG_16_BINARY, StringConstants.TREE_CLOSURE);
                }
                return new AstInputEditableStatementTreeTableNode(statementWrapper, parentNode);
            }

            private AstTreeTableNode convert(ExpressionStatementWrapper statementWrapper, BinaryExpressionWrapper expression, AstTreeTableNode parentNode) {
                if (expression.getRightExpression() instanceof MethodCallExpressionWrapper) {
                    MethodCallExpressionWrapper methodCallExpression = (MethodCallExpressionWrapper)expression.getRightExpression();
                    if (methodCallExpression.isBuiltInKeywordMethodCall()) {
                        return new AstBuiltInKeywordTreeTableNode(statementWrapper, parentNode);
                    }
                    if (methodCallExpression.isCustomKeywordMethodCall()) {
                        return new AstCustomKeywordTreeTableNode(statementWrapper, parentNode);
                    }
                }
                return new AstInputEditableStatementTreeTableNode(statementWrapper, parentNode, ImageConstants.IMG_16_BINARY, StringConstants.TREE_BINARY_STATEMENT);
            }

            private AstTreeTableNode convert(ExpressionStatementWrapper statementWrapper, MethodCallExpressionWrapper methodCallExpression, AstTreeTableNode parentNode) {
                if (methodCallExpression.isBuiltInKeywordMethodCall()) {
                    if (methodCallExpression.isCallTestCaseMethodCall()) {
                        return new AstCallTestCaseKeywordTreeTableNode(statementWrapper, parentNode);
                    }
                    return new AstBuiltInKeywordTreeTableNode(statementWrapper, parentNode);
                }
                if (methodCallExpression.isCustomKeywordMethodCall()) {
                    return new AstCustomKeywordTreeTableNode(statementWrapper, parentNode);
                }
                return new AstInputEditableStatementTreeTableNode(statementWrapper, parentNode, ImageConstants.IMG_16_FUNCTION, StringConstants.TREE_METHOD_CALL_STATEMENT);
            }
        };
        forConverter = new Converter<ForStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(ForStatementWrapper forStatement, AstTreeTableNode parentNode) {
                return new ArrayList<AstTreeTableNode>(forStatement, parentNode){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(new AstCompositeInputEditableStatementTreeTableNode(forStatementWrapper, astTreeTableNode, ImageConstants.IMG_16_LOOP, StringConstants.TREE_FOR_STATEMENT));
                    }
                };
            }
        };
        whileConverter = new Converter<WhileStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(WhileStatementWrapper whileStatement, AstTreeTableNode parentNode) {
                return new ArrayList<AstTreeTableNode>(whileStatement, parentNode){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(new AstCompositeInputEditableStatementTreeTableNode(whileStatementWrapper, astTreeTableNode, ImageConstants.IMG_16_LOOP, StringConstants.TREE_WHILE_STATEMENT));
                    }
                };
            }
        };
        switchConverter = new Converter<SwitchStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(SwitchStatementWrapper switchStatement, AstTreeTableNode parentNode) {
                return new ArrayList<AstTreeTableNode>(switchStatement, parentNode){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(new AstSwitchStatementTreeTableNode(switchStatementWrapper, astTreeTableNode));
                    }
                };
            }
        };
        assertConverter = new Converter<AssertStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(AssertStatementWrapper assertStatement, AstTreeTableNode parentNode) {
                return new ArrayList<AstTreeTableNode>(assertStatement, parentNode){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(new AstInputEditableStatementTreeTableNode(assertStatementWrapper, astTreeTableNode, ImageConstants.IMG_16_ASSERT, StringConstants.TREE_ASSERT_STATEMENT));
                    }
                };
            }
        };
        breakConverter = new Converter<BreakStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(BreakStatementWrapper breakStatement, AstTreeTableNode parentNode) {
                return new ArrayList<AstTreeTableNode>(breakStatement, parentNode){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(new AstStatementTreeTableNode((StatementWrapper)breakStatementWrapper, astTreeTableNode, StringConstants.TREE_BREAK_STATEMENT));
                    }
                };
            }
        };
        continueConverter = new Converter<ContinueStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(ContinueStatementWrapper continueStatement, AstTreeTableNode parentNode) {
                return new ArrayList<AstTreeTableNode>(continueStatement, parentNode){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(new AstStatementTreeTableNode((StatementWrapper)continueStatementWrapper, astTreeTableNode, StringConstants.TREE_CONTINUE_STATEMENT));
                    }
                };
            }
        };
        returnConverter = new Converter<ReturnStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(ReturnStatementWrapper returnStatement, AstTreeTableNode parentNode) {
                return new ArrayList<AstTreeTableNode>(returnStatement, parentNode){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(new AstStatementTreeTableNode((StatementWrapper)returnStatementWrapper, astTreeTableNode, StringConstants.TREE_RETURN_STATEMENT));
                    }
                };
            }
        };
        throwConverter = new Converter<ThrowStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(ThrowStatementWrapper throwStatement, AstTreeTableNode parentNode) {
                return new ArrayList<AstTreeTableNode>(throwStatement, parentNode){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(new AstStatementTreeTableNode((StatementWrapper)throwStatementWrapper, astTreeTableNode, StringConstants.TREE_THROW_STATEMENT));
                    }
                };
            }
        };
        ifConverter = new Converter<IfStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(IfStatementWrapper ifStatement, AstTreeTableNode parentNode) {
                ArrayList<AstTreeTableNode> astTreeTableNodes = new ArrayList<AstTreeTableNode>();
                astTreeTableNodes.add(new AstCompositeInputEditableStatementTreeTableNode(ifStatement, parentNode, ImageConstants.IMG_16_IF, StringConstants.TREE_IF_STATEMENT));
                for (ElseIfStatementWrapper elseIfStatement : ifStatement.getComplexChildStatements()) {
                    astTreeTableNodes.addAll(elseIfConverter.convert(elseIfStatement, parentNode));
                }
                if (ifStatement.hasLastStatement()) {
                    astTreeTableNodes.add(new AstCompositeStatementTreeTableNode((StatementWrapper)ifStatement.getLastStatement(), parentNode, ImageConstants.IMG_16_ELSE, StringConstants.TREE_ELSE_STATEMENT));
                }
                return astTreeTableNodes;
            }
        };
        elseIfConverter = new Converter<ElseIfStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(ElseIfStatementWrapper elseIfStatement, AstTreeTableNode parentNode) {
                return new ArrayList<AstTreeTableNode>(elseIfStatement, parentNode){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(new AstCompositeInputEditableStatementTreeTableNode(elseIfStatementWrapper, astTreeTableNode, ImageConstants.IMG_16_ELSE_IF, StringConstants.TREE_ELSE_IF_STATEMENT));
                    }
                };
            }
        };
        tryCatchConverter = new Converter<TryCatchStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(TryCatchStatementWrapper tryCatchStatement, AstTreeTableNode parentNode) {
                ArrayList<AstTreeTableNode> astTreeTableNodes = new ArrayList<AstTreeTableNode>();
                astTreeTableNodes.add(new AstCompositeStatementTreeTableNode((StatementWrapper)tryCatchStatement, parentNode, StringConstants.TREE_TRY_STATEMENT));
                for (CatchStatementWrapper catchStatement : tryCatchStatement.getComplexChildStatements()) {
                    astTreeTableNodes.addAll(catchConverter.convert(catchStatement, parentNode));
                }
                if (tryCatchStatement.hasLastStatement()) {
                    astTreeTableNodes.add(new AstCompositeInputEditableStatementTreeTableNode((StatementWrapper)tryCatchStatement.getLastStatement(), parentNode, StringConstants.TREE_FINALLY_STATEMENT));
                }
                return astTreeTableNodes;
            }
        };
        catchConverter = new Converter<CatchStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(CatchStatementWrapper catchStatement, AstTreeTableNode parentNode) {
                return new ArrayList<AstTreeTableNode>(catchStatement, parentNode){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(new AstCompositeInputEditableStatementTreeTableNode((StatementWrapper)catchStatementWrapper, astTreeTableNode, StringConstants.TREE_CATCH_STATEMENT));
                    }
                };
            }
        };
        doWhileConverter = new Converter<DoWhileStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(DoWhileStatementWrapper doWhileStatement, AstTreeTableNode parentNode) {
                return new ArrayList<AstTreeTableNode>(doWhileStatement, parentNode){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(new AstCompositeInputEditableStatementTreeTableNode(doWhileStatementWrapper, astTreeTableNode, ImageConstants.IMG_16_LOOP, StringConstants.TREE_DO_WHILE_STATEMENT));
                    }
                };
            }
        };
        synchronizedConverter = new Converter<SynchronizedStatementWrapper>(){

            @Override
            public List<AstTreeTableNode> convert(SynchronizedStatementWrapper synchronizedStatement, AstTreeTableNode parentNode) {
                return new ArrayList<AstTreeTableNode>(synchronizedStatement, parentNode){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(new AstStatementTreeTableNode(synchronizedStatementWrapper, astTreeTableNode){});
                    }
                };
            }
        };
    }

    public static WrapperToAstTreeConverter getInstance() {
        if (instance == null) {
            instance = new WrapperToAstTreeConverter();
            WrapperToAstTreeConverter.initConverters();
        }
        return instance;
    }

    public List<AstTreeTableNode> convert(List<? extends StatementWrapper> statementWrappers, AstTreeTableNode parentNode) {
        ArrayList<AstTreeTableNode> astTreeTableNodes = new ArrayList<AstTreeTableNode>();
        for (StatementWrapper statementWrapper : statementWrappers) {
            Converter<StatementWrapper> converter = this.getConverter(statementWrapper);
            if (converter == null) continue;
            astTreeTableNodes.addAll(converter.convert(statementWrapper, parentNode));
        }
        return astTreeTableNodes;
    }

    public <T extends StatementWrapper> Converter<T> getConverter(T statementWrapper) {
        return converters.get(statementWrapper.getClass().getSimpleName());
    }

    private static void initConverters() {
        converters = new HashMap();
        converters.put(ForStatementWrapper.class.getSimpleName(), forConverter);
        converters.put(WhileStatementWrapper.class.getSimpleName(), whileConverter);
        converters.put(SwitchStatementWrapper.class.getSimpleName(), switchConverter);
        converters.put(AssertStatementWrapper.class.getSimpleName(), assertConverter);
        converters.put(BreakStatementWrapper.class.getSimpleName(), breakConverter);
        converters.put(ContinueStatementWrapper.class.getSimpleName(), continueConverter);
        converters.put(ReturnStatementWrapper.class.getSimpleName(), returnConverter);
        converters.put(ThrowStatementWrapper.class.getSimpleName(), throwConverter);
        converters.put(SynchronizedStatementWrapper.class.getSimpleName(), synchronizedConverter);
        converters.put(DoWhileStatementWrapper.class.getSimpleName(), doWhileConverter);
        converters.put(CatchStatementWrapper.class.getSimpleName(), catchConverter);
        converters.put(TryCatchStatementWrapper.class.getSimpleName(), tryCatchConverter);
        converters.put(ElseIfStatementWrapper.class.getSimpleName(), elseIfConverter);
        converters.put(IfStatementWrapper.class.getSimpleName(), ifConverter);
        converters.put(ExpressionStatementWrapper.class.getSimpleName(), expressionConverter);
    }

    public static interface Converter<T extends StatementWrapper> {
        public List<AstTreeTableNode> convert(T var1, AstTreeTableNode var2);
    }
}

