/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.util;

import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.TreeTableMenuItemConstants;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.core.keyword.internal.IKeywordContributor;
import com.kms.katalon.core.keyword.internal.KeywordContributorCollection;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.session.ExecutionSession;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import com.kms.katalon.execution.session.RemoteMobileExecutionSession;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class TestCaseMenuUtil {
    private static final int DEFAULT_MAX_EXISTING_SESSION_TITLE = 20;

    public static MenuItem addActionSubMenu(Menu menu, TreeTableMenuItemConstants.AddAction addAction, String MenuText, SelectionListener selectionListener) {
        MenuItem actionMenuItem = new MenuItem(menu, 64);
        actionMenuItem.setText(MenuText);
        Menu actionMenu = new Menu(menu);
        actionMenuItem.setMenu(actionMenu);
        TestCaseMenuUtil.fillActionMenu(addAction, selectionListener, actionMenu);
        return actionMenuItem;
    }

    public static void fillActionMenu(TreeTableMenuItemConstants.AddAction addAction, SelectionListener selectionListener, Menu actionMenu, int[] excludes) {
        TestCaseMenuUtil.fillActionMenu(addAction, selectionListener, actionMenu);
        HashSet<Integer> excludeIds = new HashSet<Integer>(Arrays.asList(ArrayUtils.toObject((int[])excludes)));
        MenuItem[] menuItemArray = actionMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (excludeIds.contains(item.getID())) {
                item.dispose();
            }
            ++n2;
        }
    }

    public static void fillActionMenu(TreeTableMenuItemConstants.AddAction addAction, SelectionListener selectionListener, Menu actionMenu) {
        TestCaseMenuUtil.addBuiltInKeywordMenuItems(addAction, selectionListener, actionMenu);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, TreeTableMenuItemConstants.CUSTOM_KEYWORD_MENU_ITEM_LABEL, 32, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, TreeTableMenuItemConstants.CALL_TEST_CASE_MENU_ITEM_LABEL, 70, 8);
        new MenuItem(actionMenu, 2);
        MenuItem decisionMakingStatementWrappersMenuItem = TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, TreeTableMenuItemConstants.DECISION_MAKING_STATEMENT_MENU_ITEM_LABEL, 20, 64);
        Menu decisionMakingStatementWrappersMenu = new Menu(actionMenu);
        decisionMakingStatementWrappersMenuItem.setMenu(decisionMakingStatementWrappersMenu);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, decisionMakingStatementWrappersMenu, TreeTableMenuItemConstants.IF_STATEMENT_MENU_ITEM_LABEL, 1, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, decisionMakingStatementWrappersMenu, TreeTableMenuItemConstants.ELSE_STATEMENT_MENU_ITEM_LABEL, 2, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, decisionMakingStatementWrappersMenu, TreeTableMenuItemConstants.ELSE_IF_STATEMENT_MENU_ITEM_LABEL, 3, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, decisionMakingStatementWrappersMenu, TreeTableMenuItemConstants.SWITCH_STATEMENT_MENU_ITEM_LABEL, 12, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, decisionMakingStatementWrappersMenu, TreeTableMenuItemConstants.CASE_STATEMENT_MENU_ITEM_LABEL, 13, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, decisionMakingStatementWrappersMenu, TreeTableMenuItemConstants.DEFAULT_STATEMENT_MENU_ITEM_LABEL, 14, 8);
        MenuItem loopingStatementWrappersMenuItem = TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, TreeTableMenuItemConstants.LOOPING_STATEMENT_MENU_ITEM_LABEL, 21, 64);
        Menu loopingMakingStatementWrappersMenu = new Menu(actionMenu);
        loopingStatementWrappersMenuItem.setMenu(loopingMakingStatementWrappersMenu);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, loopingMakingStatementWrappersMenu, TreeTableMenuItemConstants.FOR_STATEMENT_MENU_ITEM_LABEL, 5, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, loopingMakingStatementWrappersMenu, TreeTableMenuItemConstants.WHILE_STATEMENT_MENU_ITEM_LABEL, 4, 8);
        MenuItem branchingStatementWrappersMenuItem = TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, TreeTableMenuItemConstants.BRANCHING_STATEMENT_MENU_ITEM_LABEL, 22, 64);
        Menu branchingMakingStatementWrappersMenu = new Menu(actionMenu);
        branchingStatementWrappersMenuItem.setMenu(branchingMakingStatementWrappersMenu);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, branchingMakingStatementWrappersMenu, TreeTableMenuItemConstants.BREAK_STATEMENT_MENU_ITEM_LABEL, 9, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, branchingMakingStatementWrappersMenu, TreeTableMenuItemConstants.CONTINUE_STATEMENT_MENU_ITEM_LABEL, 10, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, branchingMakingStatementWrappersMenu, TreeTableMenuItemConstants.RETURN_STATEMENT_MENU_ITEM_LABEL, 11, 8);
        MenuItem exceptionHandlingStatementWrappersMenuItem = TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, TreeTableMenuItemConstants.EXCEPTION_HANDLING_STATEMENT_MENU_ITEM_LABEL, 23, 64);
        new MenuItem(actionMenu, 2);
        Menu exceptionHandlingStatementWrappersMenu = new Menu(actionMenu);
        exceptionHandlingStatementWrappersMenuItem.setMenu(exceptionHandlingStatementWrappersMenu);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, exceptionHandlingStatementWrappersMenu, TreeTableMenuItemConstants.TRY_STATEMENT_MENU_ITEM_LABEL, 15, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, exceptionHandlingStatementWrappersMenu, TreeTableMenuItemConstants.CATCH_STATEMENT_MENU_ITEM_LABEL, 16, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, exceptionHandlingStatementWrappersMenu, TreeTableMenuItemConstants.FINALLY_STATEMENT_MENU_ITEM_LABEL, 17, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, exceptionHandlingStatementWrappersMenu, TreeTableMenuItemConstants.THROW_STATEMENT_MENU_ITEM_LABEL, 18, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, TreeTableMenuItemConstants.BINARY_STATEMENT_MENU_ITEM_LABEL, 6, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, TreeTableMenuItemConstants.ASSERT_STATEMENT_MENU_ITEM_LABEL, 7, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, TreeTableMenuItemConstants.CALL_METHOD_STATEMENT_MENU_ITEM_LABEL, 8, 8);
        new MenuItem(actionMenu, 2);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, TreeTableMenuItemConstants.METHOD_MENU_ITEM_LABEL, 72, 8);
    }

    public static void generateExecuteFromTestStepSubMenu(Menu menu, SelectionListener selectionListener) {
        TestCaseMenuUtil.generateExecuteFromTestStepSubMenu(menu, selectionListener, -1);
    }

    public static void generateExecuteFromTestStepSubMenu(Menu menu, SelectionListener selectionListener, int menuIndex) {
        List allAvailableExecutionSessions = ExecutionSessionSocketServer.getInstance().getAllAvailableExecutionSessions();
        boolean isExecutionSessionsEmpty = allAvailableExecutionSessions.isEmpty();
        MenuItem executeFromTestStepMenuItem = menuIndex >= 0 ? new MenuItem(menu, isExecutionSessionsEmpty ? 8 : 64, menuIndex) : new MenuItem(menu, isExecutionSessionsEmpty ? 8 : 64);
        executeFromTestStepMenuItem.setText(ComposerTestcaseMessageConstants.ADAP_MENU_CONTEXT_EXECUTE_FROM_TEST_STEP);
        executeFromTestStepMenuItem.addSelectionListener(selectionListener);
        if (isExecutionSessionsEmpty) {
            executeFromTestStepMenuItem.setEnabled(false);
            return;
        }
        HashMap<String, Integer> labelMap = new HashMap<String, Integer>();
        Menu executeSessionMenu = new Menu(executeFromTestStepMenuItem);
        for (ExecutionSession executionSession : allAvailableExecutionSessions) {
            MenuItem executionSessionMenuItem = new MenuItem(executeSessionMenu, 8);
            String menuLabel = TestCaseMenuUtil.getLabelForExecutionSession(executionSession);
            if (labelMap.containsKey(menuLabel)) {
                Integer numberOfInstances = (Integer)labelMap.get(menuLabel) + 1;
                labelMap.put(menuLabel, numberOfInstances);
                menuLabel = String.valueOf(menuLabel) + " (" + numberOfInstances + ")";
            } else {
                labelMap.put(menuLabel, 1);
            }
            executionSessionMenuItem.setText(menuLabel);
            executionSessionMenuItem.addSelectionListener(selectionListener);
            executionSessionMenuItem.setID(50);
            executionSessionMenuItem.setData((Object)executionSession);
            executionSessionMenuItem.setImage(TestCaseMenuUtil.getImageForDriverType(executionSession));
        }
        executeFromTestStepMenuItem.setMenu(executeSessionMenu);
    }

    private static String getLabelForExecutionSession(ExecutionSession executionSession) {
        String executionTitle = executionSession.getTitle();
        if (executionTitle.isEmpty()) {
            executionTitle = ComposerTestcaseMessageConstants.LBL_EXECUTION_EXISTING_SESSION_BLANK_TITLE;
        }
        return StringUtils.abbreviate((String)executionTitle, (int)20);
    }

    private static Image getImageForDriverType(ExecutionSession executionSession) {
        String driverTypeName = executionSession.getDriverTypeName();
        if (WebUIDriverType.KOBITON_WEB_DRIVER.toString().equals(driverTypeName) || executionSession instanceof RemoteMobileExecutionSession && ((RemoteMobileExecutionSession)executionSession).getRemoteType().equals(WebUIDriverType.KOBITON_WEB_DRIVER.getName())) {
            return ImageManager.getImage((String)"kobiton_16.png");
        }
        if (WebUIDriverType.ANDROID_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/android_16.png");
        }
        if (WebUIDriverType.CHROME_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/chrome_16.png");
        }
        if (WebUIDriverType.EDGE_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/edge_16.png");
        }
        if (WebUIDriverType.FIREFOX_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/firefox_16.png");
        }
        if (WebUIDriverType.HEADLESS_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/chrome_headless_16.png");
        }
        if (WebUIDriverType.IE_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/ie_16.png");
        }
        if (WebUIDriverType.IOS_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/apple_16.png");
        }
        if (WebUIDriverType.SAFARI_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/safari_16.png");
        }
        if (WebUIDriverType.FIREFOX_HEADLESS_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/firefox_headless_16.png");
        }
        return null;
    }

    public static void fillActionMenuAddTestSuite(TreeTableMenuItemConstants.AddAction addAction, SelectionListener selectionListener, Menu actionMenu) {
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, TreeTableMenuItemConstants.ADD_TO_AN_EXISTING_TEST_SUITE_LABEL, 80, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, TreeTableMenuItemConstants.ADD_TO_A_NEW_TEST_SUITE_LABEL, 81, 8);
    }

    private static MenuItem addNewMenuItem(TreeTableMenuItemConstants.AddAction addAction, SelectionListener selectionListener, Menu actionMenu, String text, int id, int type) {
        MenuItem newMenuItem = new MenuItem(actionMenu, type);
        newMenuItem.setText(text);
        newMenuItem.addSelectionListener(selectionListener);
        newMenuItem.setID(id);
        newMenuItem.setData("ACTION", (Object)addAction);
        return newMenuItem;
    }

    private static void addBuiltInKeywordMenuItems(TreeTableMenuItemConstants.AddAction addAction, SelectionListener selectionListener, Menu actionMenu) {
        TreeTableMenuItemConstants.generateBuiltInKeywordMenuItemIDs(KeywordController.getInstance().getBuiltInKeywordClasses());
        for (IKeywordContributor contributor : KeywordContributorCollection.getKeywordContributors()) {
            TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, contributor.getLabelName(), TreeTableMenuItemConstants.getMenuItemID(contributor.getAliasName()), 8);
        }
    }
}

