/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.support;

import com.kms.katalon.composer.components.operation.OperationExecutor;
import com.kms.katalon.composer.testcase.ast.editors.TestStepDescriptionBuilderCellEditor;
import com.kms.katalon.composer.testcase.ast.treetable.AstStatementTreeTableNode;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class DescriptionColumnEditingSupport
extends EditingSupport {
    private TreeViewer treeViewer;
    private ITestCasePart parentTestCasePart;

    public DescriptionColumnEditingSupport(TreeViewer viewer, ITestCasePart parentTestCasePart) {
        super((ColumnViewer)viewer);
        this.treeViewer = viewer;
        this.parentTestCasePart = parentTestCasePart;
    }

    protected CellEditor getCellEditor(Object element) {
        return new TestStepDescriptionBuilderCellEditor((Composite)this.treeViewer.getTree());
    }

    protected boolean canEdit(Object element) {
        return element instanceof AstStatementTreeTableNode && ((AstStatementTreeTableNode)element).canHaveDescription();
    }

    protected Object getValue(Object element) {
        return ((AstStatementTreeTableNode)element).getDescription();
    }

    protected void setValue(Object element, Object value) {
        if (!(value instanceof String)) {
            return;
        }
        new OperationExecutor((Object)this.parentTestCasePart).executeOperation((IUndoableOperation)new NodeDescriptionValueChangeOperation((AstStatementTreeTableNode)element, (String)value));
    }

    private class NodeDescriptionValueChangeOperation
    extends AbstractOperation {
        private AstStatementTreeTableNode node;
        private String value;
        private String oldValue;

        public NodeDescriptionValueChangeOperation(AstStatementTreeTableNode node, String value) {
            super(NodeDescriptionValueChangeOperation.class.getName());
            this.node = node;
            this.value = value;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldValue = this.node.getDescription();
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetDescriptionValue(this.value);
        }

        protected IStatus doSetDescriptionValue(String description) {
            if (!this.node.setDescription(description)) {
                return Status.CANCEL_STATUS;
            }
            TestCaseTreeTableInput treeTableInput = DescriptionColumnEditingSupport.this.parentTestCasePart.getTreeTableInput();
            treeTableInput.setDirty(true);
            DescriptionColumnEditingSupport.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.node));
            treeTableInput.refresh(this.node);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetDescriptionValue(this.oldValue);
        }
    }
}

