/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.providers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testcase.ast.treetable.AstBuiltInKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.composer.testcase.exceptions.GroovyParsingException;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.keywords.IKeywordBrowserTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserControlTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserTreeEntity;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.composer.testcase.treetable.transfer.ScriptTransferData;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.composer.testcase.util.TestCaseEntityUtil;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TestStepTableDropListener
extends TreeDropTargetEffect {
    private TreeViewer treeViewer;
    private ITestCasePart testCasePart;

    public TestStepTableDropListener(TreeViewer viewer, ITestCasePart parentPart) {
        super(viewer.getTree());
        this.treeViewer = viewer;
        this.testCasePart = parentPart;
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 24;
        if (event.item == null || !(event.item instanceof TreeItem)) {
            return;
        }
        event.feedback |= TestStepTableDropListener.getFeedBackByLocation(event.display.map(null, (Control)this.treeViewer.getTree(), event.x, event.y), (TreeItem)event.item);
    }

    private static int getFeedBackByLocation(Point point, TreeItem treeItem) {
        if (treeItem == null || point == null) {
            return 0;
        }
        Rectangle bounds = treeItem.getBounds();
        if (point.y < bounds.y + bounds.height / 3) {
            return 2;
        }
        if (point.y > bounds.y + 2 * bounds.height / 3) {
            return 4;
        }
        return 1;
    }

    public void drop(DropTargetEvent event) {
        try {
            event.detail = 1;
            if (event.data instanceof ITreeEntity[]) {
                this.handleDropForTreeEntity(event, (ITreeEntity[])event.data);
            } else if (event.data instanceof IKeywordBrowserTreeEntity[]) {
                this.handleDropForKeywordBrowserTreeEntities(event, (IKeywordBrowserTreeEntity[])event.data);
            } else if (event.data instanceof String) {
                this.handleDropForScriptSnippet(event, (String)event.data);
            } else if (event.data instanceof ScriptTransferData[]) {
                this.handleDropForScriptTransferData(event, (ScriptTransferData[])event.data);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)StringConstants.ERR_CANNOT_DROP_ON_TEST_STEP_TABLE);
        }
    }

    private void handleDropForScriptTransferData(DropTargetEvent event, ScriptTransferData[] scriptTransferDatas) throws GroovyParsingException {
        if (scriptTransferDatas.length <= 0) {
            return;
        }
        List<AstTreeTableNode> dragNodes = this.testCasePart.getDragNodes();
        AstTreeTableNode hoveredTreeTableNode = this.getHoveredTreeTableNode(event);
        if (dragNodes != null && dragNodes.contains(hoveredTreeTableNode)) {
            event.detail = 0;
            return;
        }
        ScriptTransferData firstScriptTransferData = scriptTransferDatas[0];
        String testCaseId = firstScriptTransferData.getTestCaseId();
        TestCaseTreeTableInput.NodeAddType addType = this.getNodeAddType(event);
        List<StatementWrapper> dropStatements = this.getStatementsFromScriptSnippet(firstScriptTransferData.getScriptSnippet());
        if (StringUtils.equals((String)testCaseId, (String)this.testCasePart.getTestCase().getId())) {
            this.getTestCaseTreeTableInput().dragAndDropAstObjects(new ArrayList<AstTreeTableNode>(dragNodes), dropStatements, hoveredTreeTableNode, addType);
            return;
        }
        this.handleDropForScriptSnippet(dropStatements, hoveredTreeTableNode, addType);
    }

    private boolean handleDropForScriptSnippet(DropTargetEvent event, String snippet) throws GroovyParsingException {
        List<StatementWrapper> dropStatements = this.getStatementsFromScriptSnippet(snippet);
        AstTreeTableNode hoveredTreeTableNode = this.getHoveredTreeTableNode(event);
        TestCaseTreeTableInput.NodeAddType nodeAddType = this.getNodeAddType(event);
        return this.handleDropForScriptSnippet(dropStatements, hoveredTreeTableNode, nodeAddType);
    }

    private boolean handleDropForScriptSnippet(List<StatementWrapper> dropStatements, AstTreeTableNode hoveredTreeTableNode, TestCaseTreeTableInput.NodeAddType nodeAddType) {
        return this.getTestCaseTreeTableInput().addNewAstObjects(dropStatements, hoveredTreeTableNode, nodeAddType);
    }

    private List<StatementWrapper> getStatementsFromScriptSnippet(String snippet) throws GroovyParsingException {
        ScriptNodeWrapper scriptNode = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper(snippet);
        if (scriptNode == null) {
            return Collections.emptyList();
        }
        ArrayList<StatementWrapper> dropStatements = new ArrayList<StatementWrapper>(scriptNode.getBlock().getStatements());
        return dropStatements;
    }

    private void handleDropForKeywordBrowserTreeEntities(DropTargetEvent event, IKeywordBrowserTreeEntity[] treeEntities) throws Exception {
        if (treeEntities == null || treeEntities.length <= 0) {
            return;
        }
        int i = 0;
        while (i < treeEntities.length) {
            if (treeEntities[i] instanceof KeywordBrowserTreeEntity) {
                this.handleDropForKeywordBrowserTreeEntity(event, (KeywordBrowserTreeEntity)treeEntities[i]);
            } else if (treeEntities[i] instanceof KeywordBrowserControlTreeEntity) {
                this.handleDropForKeywordBrowserControlEntity(event, (KeywordBrowserControlTreeEntity)treeEntities[i]);
            }
            ++i;
        }
    }

    private void handleDropForKeywordBrowserControlEntity(DropTargetEvent event, KeywordBrowserControlTreeEntity keywordBrowserControlTreeEntity) {
        this.getTestCaseTreeTableInput().addNewAstObject(keywordBrowserControlTreeEntity.getControlStatementId(), this.getHoveredTreeTableNode(event), this.getNodeAddType(event));
    }

    private void handleDropForKeywordBrowserTreeEntity(DropTargetEvent event, KeywordBrowserTreeEntity keywordBrowserTreeEntity) {
        TestCaseTreeTableInput testCaseTableInput = this.getTestCaseTreeTableInput();
        testCaseTableInput.addDefaultImports();
        AstTreeTableNode hoveredTreeTableNode = this.getHoveredTreeTableNode(event);
        ASTNodeWrapper parentWrapper = hoveredTreeTableNode != null ? hoveredTreeTableNode.getASTObject() : testCaseTableInput.getMainClassNode();
        this.addNewStatementWrapperToTreeTable(event, this.createNewKeywordStatementFromKeywordBrowserEntity(keywordBrowserTreeEntity, parentWrapper));
    }

    private ExpressionStatementWrapper createNewKeywordStatementFromKeywordBrowserEntity(KeywordBrowserTreeEntity keywordBrowserTreeEntity, ASTNodeWrapper parentWrapper) {
        if (keywordBrowserTreeEntity.isCustom()) {
            return AstKeywordsInputUtil.createNewCustomKeywordStatement(keywordBrowserTreeEntity.getClassName(), keywordBrowserTreeEntity.getName(), parentWrapper);
        }
        return AstKeywordsInputUtil.createBuiltInKeywordStatement(KeywordController.getInstance().getBuiltInKeywordClassByName(keywordBrowserTreeEntity.getClassName()).getAliasName(), keywordBrowserTreeEntity.getName(), parentWrapper);
    }

    private void handleDropForTreeEntity(DropTargetEvent event, ITreeEntity[] treeEntities) throws Exception {
        Set<TestCaseEntity> calledTestCases;
        Widget item = event.item;
        if (item != null && item.getData() instanceof AstBuiltInKeywordTreeTableNode) {
            this.handleDropTestObject(this.getTestObjectFromSelectionIfAvailable(treeEntities), (AstBuiltInKeywordTreeTableNode)item.getData());
        }
        if ((calledTestCases = this.collectCallTestCasesFromTreeEntities(treeEntities)).isEmpty()) {
            return;
        }
        TestCaseTreeTableInput testCaseTableInput = this.getTestCaseTreeTableInput();
        testCaseTableInput.addDefaultImports();
        testCaseTableInput.addCallTestCases(this.getHoveredTreeTableNode(event), this.getNodeAddType(event), calledTestCases.toArray(new TestCaseEntity[calledTestCases.size()]));
    }

    private WebElementTreeEntity getTestObjectFromSelectionIfAvailable(ITreeEntity[] treeEntities) {
        ITreeEntity[] iTreeEntityArray = treeEntities;
        int n = treeEntities.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeEntity treeEntity = iTreeEntityArray[n2];
            if (treeEntity instanceof WebElementTreeEntity) {
                return (WebElementTreeEntity)treeEntity;
            }
            ++n2;
        }
        return null;
    }

    private void handleDropTestObject(WebElementTreeEntity webElementTreeEntity, AstBuiltInKeywordTreeTableNode tableNode) {
        if (webElementTreeEntity == null) {
            return;
        }
        ExpressionWrapper findTestObject = this.convertWebElementToTestObject(webElementTreeEntity, tableNode);
        if (findTestObject == null) {
            return;
        }
        if (!tableNode.setTestObject(findTestObject)) {
            return;
        }
        this.testCasePart.getTreeTableInput().setDirty(true);
        this.treeViewer.refresh((Object)tableNode);
    }

    private ExpressionWrapper convertWebElementToTestObject(WebElementTreeEntity webElementTreeEntity, AstBuiltInKeywordTreeTableNode node) {
        String objectPk;
        block4: {
            objectPk = null;
            if (webElementTreeEntity.getObject() instanceof WebElementEntity) break block4;
            return null;
        }
        try {
            objectPk = ((WebElementEntity)webElementTreeEntity.getObject()).getIdForDisplay();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        if (objectPk == null) {
            return null;
        }
        return AstEntityInputUtil.createNewFindTestObjectMethodCall(objectPk, node.getASTObject());
    }

    private Set<TestCaseEntity> collectCallTestCasesFromTreeEntities(ITreeEntity[] treeEntities) throws Exception {
        if (treeEntities == null || treeEntities.length <= 0) {
            return Collections.emptySet();
        }
        TestCaseTreeTableInput treeTableInput = this.getTestCaseTreeTableInput();
        LinkedHashSet<TestCaseEntity> callTestCases = new LinkedHashSet<TestCaseEntity>();
        int i = 0;
        while (i < treeEntities.length) {
            if (treeEntities[i] instanceof TestCaseTreeEntity) {
                TestCaseEntity testCase = ((TestCaseTreeEntity)treeEntities[i]).getObject();
                if (treeTableInput.validateTestCase(testCase)) {
                    callTestCases.add(testCase);
                }
            } else if (treeEntities[i] instanceof FolderTreeEntity) {
                List<TestCaseEntity> testCases = TestCaseEntityUtil.getTestCasesFromFolderTree((FolderTreeEntity)treeEntities[i]);
                for (TestCaseEntity testCase : testCases) {
                    if (!treeTableInput.validateTestCase(testCase)) continue;
                    callTestCases.add(testCase);
                }
            }
            ++i;
        }
        return callTestCases;
    }

    protected boolean addNewStatementWrapperToTreeTable(DropTargetEvent event, StatementWrapper statement) {
        if (statement == null) {
            return false;
        }
        TestCaseTreeTableInput testCaseTreeTableInput = this.getTestCaseTreeTableInput();
        testCaseTreeTableInput.addDefaultImports();
        return testCaseTreeTableInput.addNewAstObject(statement, this.getHoveredTreeTableNode(event), this.getNodeAddType(event));
    }

    private TestCaseTreeTableInput.NodeAddType getNodeAddType(DropTargetEvent event) {
        switch (TestStepTableDropListener.getFeedBackByLocation(event.display.map(null, (Control)this.treeViewer.getTree(), event.x, event.y), (TreeItem)event.item)) {
            case 2: {
                return TestCaseTreeTableInput.NodeAddType.InserBefore;
            }
            case 4: {
                return TestCaseTreeTableInput.NodeAddType.InserAfter;
            }
        }
        return TestCaseTreeTableInput.NodeAddType.Add;
    }

    private AstTreeTableNode getHoveredTreeTableNode(DropTargetEvent event) {
        Point pt = Display.getCurrent().map(null, (Control)this.treeViewer.getTree(), event.x, event.y);
        TreeItem treeItem = this.treeViewer.getTree().getItem(pt);
        return treeItem != null ? (AstTreeTableNode)treeItem.getData() : null;
    }

    protected TestCaseTreeTableInput getTestCaseTreeTableInput() {
        return this.testCasePart.getTreeTableInput();
    }
}

