/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.providers;

import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Caret;

public class TestObjectScriptDropListener
implements DropTargetListener {
    private StyledText text;
    private int characterSize;
    private int beginLineX;

    public TestObjectScriptDropListener(StyledText text) {
        this.text = text;
    }

    public void dragEnter(DropTargetEvent event) {
        this.characterSize = this.getCharacterSize();
        this.beginLineX = this.getBeginLineX();
        this.text.getParent().setFocus();
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        Caret caret = this.text.getCaret();
        Point rawLocation = this.text.toControl(event.x, event.y);
        Point offsetLocation = this.convertMouseLocationToOffsetLocation(rawLocation, false);
        caret.setLocation(offsetLocation);
        this.text.redraw();
    }

    public void drop(DropTargetEvent event) {
        ITreeEntity[] treeEntities;
        if (!(event.data instanceof ITreeEntity[])) {
            return;
        }
        ITreeEntity[] iTreeEntityArray = treeEntities = (ITreeEntity[])event.data;
        int n = treeEntities.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeEntity treeEntity = iTreeEntityArray[n2];
            if (treeEntity instanceof WebElementTreeEntity) {
                WebElementTreeEntity webElementTreeEntity = (WebElementTreeEntity)treeEntity;
                String objectPk = null;
                try {
                    if (webElementTreeEntity.getObject() instanceof WebElementEntity) {
                        int maxXofCurrentLine;
                        String line;
                        Point rawLocation = this.text.toControl(event.x, event.y);
                        Point offsetLocation = this.convertMouseLocationToOffsetLocation(rawLocation, true);
                        int maxYOfText = this.text.getLineHeight() * this.text.getLineCount();
                        if (offsetLocation.y > maxYOfText) {
                            offsetLocation.y = maxYOfText;
                        }
                        if ((line = this.text.getLine(this.text.getLineAtOffset(this.text.getOffsetAtLocation(new Point(this.beginLineX, offsetLocation.y))))).length() == 0) {
                            offsetLocation.x = this.beginLineX;
                        }
                        if ((maxXofCurrentLine = line.length() * this.characterSize + this.beginLineX) < offsetLocation.x) {
                            offsetLocation.x = maxXofCurrentLine;
                        }
                        objectPk = ((WebElementEntity)webElementTreeEntity.getObject()).getIdForDisplay();
                        this.text.replaceTextRange(this.text.getOffsetAtLocation(offsetLocation), 0, this.createfindObjectStatement(objectPk));
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
            ++n2;
        }
    }

    private int getCharacterSize() {
        Point currentCaret = this.text.getLocationAtOffset(0);
        Point nextCaret = this.text.getLocationAtOffset(1);
        return nextCaret.x - currentCaret.x;
    }

    private int getBeginLineX() {
        return this.text.getLocationAtOffset((int)0).x;
    }

    private Point convertMouseLocationToOffsetLocation(Point rawLocation, boolean isDrop) {
        Point newLocation = new Point(rawLocation.x, rawLocation.y);
        int lineHeigth = this.text.getLineHeight();
        newLocation.x = this.approximateLocationForOffset(newLocation.x, this.characterSize);
        int timeY = rawLocation.y / lineHeigth;
        if (isDrop && timeY == 0) {
            return newLocation;
        }
        newLocation.y = this.approximateLocationForOffset(newLocation.y, lineHeigth);
        return newLocation;
    }

    private String createfindObjectStatement(String objectPk) {
        StringBuilder builder = new StringBuilder();
        builder.append("findTestObject");
        builder.append("('");
        builder.append(objectPk);
        builder.append("')");
        return builder.toString();
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    private int approximateLocationForOffset(int value, int size) {
        if (size == 0) {
            return value;
        }
        int remain = value % size;
        if (remain == 0) {
            return value;
        }
        if (remain < size / 2) {
            value -= remain;
        } else {
            int time = value / size;
            value = (time + 1) * size;
        }
        return value;
    }
}

