/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.providers;

import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.composer.testcase.groovy.ast.AnnotationNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.MethodNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.core.annotation.SetUp;
import com.kms.katalon.core.annotation.TearDown;
import com.kms.katalon.core.annotation.TearDownIfError;
import com.kms.katalon.core.annotation.TearDownIfFailed;
import com.kms.katalon.core.annotation.TearDownIfPassed;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AstTestScriptGeneratorProvider {
    public static String generateScriptForExecuteFromTestStep(ScriptNodeWrapper scriptWrapper, StatementWrapper selectedNode) {
        if (!(selectedNode.getParent() instanceof BlockStatementWrapper) || !(selectedNode.getParent().getParent() instanceof MethodNodeWrapper)) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)ComposerTestcaseMessageConstants.ERR_MSG_UNABLE_TO_EXECUTE_FROM_TEST_STEP_STEP_INSIDE_BLOCK);
            return null;
        }
        ScriptNodeWrapper clonedScript = AstTestScriptGeneratorProvider.createClonedScript(selectedNode, scriptWrapper);
        StringBuilder scriptBuilder = new StringBuilder();
        GroovyWrapperParser parser = new GroovyWrapperParser(scriptBuilder);
        parser.parseGroovyAstIntoScript(clonedScript);
        return scriptBuilder.toString();
    }

    private static ScriptNodeWrapper createClonedScript(StatementWrapper selectedNode, ScriptNodeWrapper scriptWrapper) {
        MethodNodeWrapper methodNode = (MethodNodeWrapper)selectedNode.getParent().getParent();
        int methodIndex = scriptWrapper.getMethods().indexOf(methodNode);
        int statementIndex = methodNode.getBlock().getStatements().indexOf(selectedNode);
        ScriptNodeWrapper clonedScript = scriptWrapper.clone();
        List<MethodNodeWrapper> allMethods = clonedScript.getMethods();
        List<MethodNodeWrapper> setupMethods = AstTestScriptGeneratorProvider.collectMethod(SetUp.class, clonedScript);
        ArrayList<MethodNodeWrapper> mainMethods = new ArrayList<MethodNodeWrapper>();
        mainMethods.add(clonedScript.getRunMethod());
        List<MethodNodeWrapper> tearDownIfPassedMethods = AstTestScriptGeneratorProvider.collectMethod(TearDownIfPassed.class, clonedScript);
        List<MethodNodeWrapper> tearDownIfFailedMethods = AstTestScriptGeneratorProvider.collectMethod(TearDownIfFailed.class, clonedScript);
        List<MethodNodeWrapper> tearDownIfErrorMethods = AstTestScriptGeneratorProvider.collectMethod(TearDownIfError.class, clonedScript);
        List<MethodNodeWrapper> tearDownMethods = AstTestScriptGeneratorProvider.collectMethod(TearDown.class, clonedScript);
        ArrayList<List<MethodNodeWrapper>> methodsCollections = new ArrayList<List<MethodNodeWrapper>>();
        methodsCollections.add(setupMethods);
        methodsCollections.add(mainMethods);
        methodsCollections.add(tearDownIfPassedMethods);
        methodsCollections.add(tearDownIfFailedMethods);
        methodsCollections.add(tearDownIfErrorMethods);
        methodsCollections.add(tearDownMethods);
        AstTestScriptGeneratorProvider.iterateThroughMethodsCollections(methodIndex, statementIndex, methodsCollections, allMethods);
        return clonedScript;
    }

    private static void iterateThroughMethodsCollections(int seletedMethodIndex, int selectedStatementIndex, List<List<MethodNodeWrapper>> methodsColletions, List<MethodNodeWrapper> allMethods) {
        boolean reachSelectedStatement = false;
        for (List<MethodNodeWrapper> methods : methodsColletions) {
            if (reachSelectedStatement) break;
            reachSelectedStatement = AstTestScriptGeneratorProvider.iterateThroughMethods(seletedMethodIndex, selectedStatementIndex, methods, allMethods);
        }
    }

    private static boolean iterateThroughMethods(int seletedMethodIndex, int selectedStatementIndex, List<MethodNodeWrapper> methods, List<MethodNodeWrapper> allMethods) {
        boolean reachSelectedStatement = false;
        block0: for (MethodNodeWrapper method : methods) {
            if (reachSelectedStatement) break;
            int methodIndex = allMethods.indexOf(method);
            List<StatementWrapper> statements = method.getBlock().getStatements();
            int childStatementIndex = 0;
            while (childStatementIndex < statements.size()) {
                if (methodIndex == seletedMethodIndex && childStatementIndex == selectedStatementIndex) {
                    reachSelectedStatement = true;
                    continue block0;
                }
                statements.get(childStatementIndex).disable();
                ++childStatementIndex;
            }
        }
        return reachSelectedStatement;
    }

    private static List<MethodNodeWrapper> collectMethod(Class<?> annotationClass, ScriptNodeWrapper clonedScript) {
        ArrayList<MethodNodeWrapper> methods = new ArrayList<MethodNodeWrapper>();
        block0: for (MethodNodeWrapper method : clonedScript.getMethods()) {
            for (AnnotationNodeWrapper annotationNode : method.getAnnotations()) {
                String annotationNodeName = annotationNode.getClassNode().getName();
                if (!annotationNodeName.equals(annotationClass.getName()) && !annotationNodeName.equals(annotationClass.getSimpleName())) continue;
                methods.add(method);
                continue block0;
            }
        }
        return methods;
    }
}

